/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.playercooldowns;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.metadata.LazyMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class QuestCooldown
implements Serializable {
    private final String permission;
    private final boolean permanent;
    private long targetUnixTime = 0L;
    private transient BukkitTask bukkitTask = null;

    public QuestCooldown(int delayInMinutes, String permission, UUID player) {
        boolean bl = this.permanent = delayInMinutes < 1;
        if (!this.permanent) {
            this.targetUnixTime = System.currentTimeMillis() + 60000L * (long)delayInMinutes;
        }
        this.permission = permission;
        this.startCooldown(player);
    }

    public void startCooldown(final UUID player) {
        long delay = Math.max((this.targetUnixTime - System.currentTimeMillis()) / 1000L * 20L, 0L);
        final PermissionAttachment permissionAttachment = Objects.requireNonNull(Bukkit.getPlayer((UUID)player)).addAttachment((Plugin)MetadataHandler.PLUGIN);
        if (!this.permanent && delay < 1L) {
            permissionAttachment.unsetPermission(this.permission);
            return;
        }
        permissionAttachment.setPermission(this.permission, true);
        Bukkit.getPlayer((UUID)player).setMetadata(this.permission, (MetadataValue)new LazyMetadataValue((Plugin)MetadataHandler.PLUGIN, () -> true));
        if (!this.permanent) {
            this.bukkitTask = new BukkitRunnable(){

                public void run() {
                    if (Bukkit.getPlayer((UUID)player) != null) {
                        permissionAttachment.unsetPermission(QuestCooldown.this.permission);
                        Bukkit.getPlayer((UUID)player).removeMetadata(QuestCooldown.this.permission, (Plugin)MetadataHandler.PLUGIN);
                        PlayerData.updatePlayerQuestCooldowns(player, PlayerData.getPlayerQuestCooldowns(player));
                    }
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, delay);
        }
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public long getTargetUnixTime() {
        return this.targetUnixTime;
    }

    @Generated
    public BukkitTask getBukkitTask() {
        return this.bukkitTask;
    }
}

