/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.thirdparty.worldguard;

import com.magmaguy.magmacore.util.Logger;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.IntegerFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import lombok.Generated;
import org.bukkit.Bukkit;

public class WorldGuardCompatibility {
    private static final StateFlag.State allow = StateFlag.State.ALLOW;
    private static final StateFlag.State deny = StateFlag.State.DENY;
    private static StateFlag ELITEMOBS_SPAWN_FLAG;
    private static StateFlag ELITEMOBS_ONLY_SPAWN_FLAG;
    private static StateFlag ELITEMOBS_ANTIEXPLOIT;
    private static StateFlag ELITEMOBS_DUNGEON;
    private static StateFlag ELITEMOBS_EVENTS;
    private static IntegerFlag ELITEMOBS_MINIMUM_LEVEL;
    private static IntegerFlag ELITEMOBS_MAXIMUM_LEVEL;
    private static StateFlag ELITEMOBS_EXPLOSION_REGEN;
    private static StateFlag ELITEMOBS_EXPLOSION_BLOCK_DAMAGE;

    public static boolean initialize() {
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") == null) {
            return false;
        }
        Logger.info(" WorldGuard detected.");
        FlagRegistry registry = null;
        try {
            registry = WorldGuard.getInstance().getFlagRegistry();
        }
        catch (Exception ex) {
            Logger.warn("Something went wrong while loading WorldGuard. Are you using the right WorldGuard version?");
            return false;
        }
        try {
            ELITEMOBS_SPAWN_FLAG = new StateFlag("elitemob-spawning", true);
            registry.register((Flag)ELITEMOBS_SPAWN_FLAG);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_SPAWN_FLAG = (StateFlag)registry.get("elitemob-spawning");
        }
        try {
            ELITEMOBS_ONLY_SPAWN_FLAG = new StateFlag("elitemob-only-spawning", false);
            registry.register((Flag)ELITEMOBS_ONLY_SPAWN_FLAG);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_ONLY_SPAWN_FLAG = (StateFlag)registry.get("elitemob-only-spawning");
        }
        try {
            ELITEMOBS_ANTIEXPLOIT = new StateFlag("elitemobs-antiexploit", true);
            registry.register((Flag)ELITEMOBS_ANTIEXPLOIT);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_ANTIEXPLOIT = (StateFlag)registry.get("elitemobs-antiexploit");
        }
        try {
            ELITEMOBS_DUNGEON = new StateFlag("elitemobs-dungeon", false);
            registry.register((Flag)ELITEMOBS_DUNGEON);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_DUNGEON = (StateFlag)registry.get("elitemobs-dungeon");
        }
        try {
            ELITEMOBS_EVENTS = new StateFlag("elitemobs-events", true);
            registry.register((Flag)ELITEMOBS_EVENTS);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_EVENTS = (StateFlag)registry.get("elitemobs-events");
        }
        try {
            ELITEMOBS_MINIMUM_LEVEL = new IntegerFlag("elitemobs-minimum-level");
            registry.register((Flag)ELITEMOBS_MINIMUM_LEVEL);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_MINIMUM_LEVEL = (IntegerFlag)registry.get("elitemobs-minimum-level");
        }
        try {
            ELITEMOBS_MAXIMUM_LEVEL = new IntegerFlag("elitemobs-maximum-level");
            registry.register((Flag)ELITEMOBS_MAXIMUM_LEVEL);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_MAXIMUM_LEVEL = (IntegerFlag)registry.get("elitemobs-maximum-level");
        }
        try {
            ELITEMOBS_EXPLOSION_REGEN = new StateFlag("elitemobs-explosion-regen", true);
            registry.register((Flag)ELITEMOBS_EXPLOSION_REGEN);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_EXPLOSION_REGEN = (StateFlag)registry.get("elitemobs-explosion-regen");
        }
        try {
            ELITEMOBS_EXPLOSION_BLOCK_DAMAGE = new StateFlag("elitemobs-explosion-block-damage", true);
            registry.register((Flag)ELITEMOBS_EXPLOSION_BLOCK_DAMAGE);
        }
        catch (FlagConflictException | IllegalStateException e) {
            ELITEMOBS_EXPLOSION_REGEN = (StateFlag)registry.get("elitemobs-explosion-block-damage");
        }
        return true;
    }

    @Generated
    public static StateFlag.State getAllow() {
        return allow;
    }

    @Generated
    public static StateFlag.State getDeny() {
        return deny;
    }

    @Generated
    public static StateFlag getELITEMOBS_SPAWN_FLAG() {
        return ELITEMOBS_SPAWN_FLAG;
    }

    @Generated
    public static StateFlag getELITEMOBS_ONLY_SPAWN_FLAG() {
        return ELITEMOBS_ONLY_SPAWN_FLAG;
    }

    @Generated
    public static StateFlag getELITEMOBS_ANTIEXPLOIT() {
        return ELITEMOBS_ANTIEXPLOIT;
    }

    @Generated
    public static StateFlag getELITEMOBS_DUNGEON() {
        return ELITEMOBS_DUNGEON;
    }

    @Generated
    public static StateFlag getELITEMOBS_EVENTS() {
        return ELITEMOBS_EVENTS;
    }

    @Generated
    public static IntegerFlag getELITEMOBS_MINIMUM_LEVEL() {
        return ELITEMOBS_MINIMUM_LEVEL;
    }

    @Generated
    public static IntegerFlag getELITEMOBS_MAXIMUM_LEVEL() {
        return ELITEMOBS_MAXIMUM_LEVEL;
    }

    @Generated
    public static StateFlag getELITEMOBS_EXPLOSION_REGEN() {
        return ELITEMOBS_EXPLOSION_REGEN;
    }

    @Generated
    public static StateFlag getELITEMOBS_EXPLOSION_BLOCK_DAMAGE() {
        return ELITEMOBS_EXPLOSION_BLOCK_DAMAGE;
    }
}

