/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemStackSerializer {
    public static FileConfiguration serialize(String identifier, ItemStack itemStack, FileConfiguration fileConfiguration) {
        fileConfiguration.addDefault(identifier + ".material", (Object)itemStack.getType().toString());
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            fileConfiguration.addDefault(identifier + ".name", (Object)itemStack.getItemMeta().getDisplayName());
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasLore()) {
            fileConfiguration.addDefault(identifier + ".lore", (Object)itemStack.getItemMeta().getLore());
        }
        if (itemStack.getType().equals((Object)Material.PLAYER_HEAD)) {
            fileConfiguration.addDefault(identifier + ".owner", (Object)((SkullMeta)itemStack.getItemMeta()).getOwner());
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasCustomModelData() && itemStack.getItemMeta().getCustomModelData() != 0) {
            fileConfiguration.addDefault(identifier + ".customModelID", (Object)itemStack.getItemMeta().getCustomModelData());
        }
        return fileConfiguration;
    }

    public static ItemStack deserialize(String identifier, FileConfiguration fileConfiguration) {
        Material material;
        identifier = (String)identifier + ".";
        try {
            material = Material.valueOf((String)fileConfiguration.getString((String)identifier + "material"));
        }
        catch (Exception ex) {
            Logger.warn("Attempted to add material name " + fileConfiguration.getString("material") + " to a menu. This is not a valid material. Item will default to glass.");
            material = Material.RED_STAINED_GLASS_PANE;
        }
        String name = "";
        if (fileConfiguration.contains((String)identifier + "name")) {
            name = ChatColorConverter.convert(fileConfiguration.getString((String)identifier + "name"));
        }
        ArrayList<String> lore = new ArrayList();
        if (fileConfiguration.contains((String)identifier + "lore")) {
            lore = ChatColorConverter.convert(fileConfiguration.getStringList((String)identifier + "lore"));
        }
        if (material.equals((Object)Material.PLAYER_HEAD)) {
            String owner = fileConfiguration.getString((String)identifier + "owner");
            return ItemStackGenerator.generateSkullItemStack(owner, name, lore);
        }
        int customModelID = 0;
        if (fileConfiguration.contains((String)identifier + "customModelID")) {
            customModelID = fileConfiguration.getInt((String)identifier + "customModelID");
        }
        return ItemStackGenerator.generateItemStack(material, name, lore, customModelID);
    }

    public static ItemStack itemStackPlaceholderReplacer(ItemStack itemStack, HashMap<String, String> placeholderReplacementPairs) {
        ItemStack cloneItemStack = itemStack.clone();
        ItemMeta newMeta = itemStack.getItemMeta();
        if (newMeta.hasDisplayName()) {
            String newName = newMeta.getDisplayName();
            for (String placeholder : placeholderReplacementPairs.keySet()) {
                if (!newMeta.getDisplayName().contains(placeholder)) continue;
                newName = newName.replace(placeholder, placeholderReplacementPairs.get(placeholder));
            }
            newMeta.setDisplayName(newName);
        }
        ArrayList<String> newLore = new ArrayList<String>();
        if (newMeta.hasLore()) {
            Iterator<String> iterator = newMeta.getLore().iterator();
            while (iterator.hasNext()) {
                String loreString;
                String newLoreString = loreString = iterator.next();
                for (String placeholder : placeholderReplacementPairs.keySet()) {
                    if (!loreString.contains(placeholder)) continue;
                    newLoreString = newLoreString.replace(placeholder, placeholderReplacementPairs.get(placeholder));
                }
                newLore.add(newLoreString);
            }
            newMeta.setLore(newLore);
        }
        cloneItemStack.setItemMeta(newMeta);
        return cloneItemStack;
    }
}

