/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.magmaguy.elitemobs.config.LegacyValueConverter;
import com.magmaguy.elitemobs.powers.scripts.primitives.ScriptDouble;
import com.magmaguy.elitemobs.powers.scripts.primitives.ScriptFloat;
import com.magmaguy.elitemobs.powers.scripts.primitives.ScriptInteger;
import com.magmaguy.elitemobs.powers.scripts.primitives.ScriptVector;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Particle;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class MapListInterpreter {
    private static void parsingErrorMessage(String key, Object value, String scriptName) {
        Logger.warn("Failed to read value " + value + " for key " + key + " in script " + scriptName);
    }

    public static String parseString(String key, Object value, String scriptName) {
        return ChatColorConverter.convert("" + value);
    }

    public static List<String> parseStringList(String key, Object value, String scriptName) {
        if (value == null) {
            return new ArrayList<String>();
        }
        try {
            return ChatColorConverter.convert((List)value);
        }
        catch (Exception ex) {
            Logger.warn("Failed to get string list for key " + key + " with value " + value + " in script " + scriptName);
            return new ArrayList<String>();
        }
    }

    public static Boolean parseBoolean(String key, Object value, String scriptName) {
        try {
            if (value instanceof Boolean) {
                Boolean boo = (Boolean)value;
                return boo;
            }
            return Boolean.parseBoolean((String)value);
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
    }

    public static Integer parseInteger(String key, Object value, String scriptName) {
        try {
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return intValue;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.contains("~")) {
                    String[] strings = stringValue.split("~");
                    return ThreadLocalRandom.current().nextInt(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]) + 1);
                }
                return Integer.parseInt(stringValue);
            }
            Logger.warn("Failed to get integer value from " + value + " in script " + scriptName);
            return null;
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
    }

    public static ScriptInteger parseScriptInteger(String key, Object value, String scriptName) {
        try {
            if (value instanceof Integer) {
                Integer intValue = (Integer)value;
                return new ScriptInteger(intValue);
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.contains("~")) {
                    String[] strings = stringValue.split("~");
                    return new ScriptInteger(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]));
                }
                return new ScriptInteger(Integer.parseInt(stringValue));
            }
            Logger.warn("Failed to get integer value from " + value + " in script " + scriptName);
            return null;
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
    }

    public static Double parseDouble(String key, Object value, String scriptName) {
        try {
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                return integer.doubleValue();
            }
            if (value instanceof Double) {
                Double dbl = (Double)value;
                return dbl;
            }
            if (value instanceof String) {
                String string = (String)value;
                return Double.parseDouble(string);
            }
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
        return null;
    }

    public static ScriptDouble parseScriptDouble(String key, Object value, String scriptName) {
        try {
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                return new ScriptDouble(integer.doubleValue());
            }
            if (value instanceof Double) {
                Double dbl = (Double)value;
                return new ScriptDouble(dbl);
            }
            if (value instanceof String) {
                String string = (String)value;
                if (((String)value).contains("~")) {
                    String[] strings = ((String)value).split("~");
                    return new ScriptDouble(Double.parseDouble(strings[0]), Double.parseDouble(strings[1]));
                }
                return new ScriptDouble(Double.parseDouble(string));
            }
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
        Logger.warn("Failed to parse " + value + " as double in " + scriptName + " for key " + key);
        return null;
    }

    public static Float parseFloat(String key, Object value, String scriptName) {
        try {
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                return Float.valueOf(integer.floatValue());
            }
            if (value instanceof Double) {
                Double dbl = (Double)value;
                return Float.valueOf(dbl.floatValue());
            }
            if (value instanceof String) {
                String string = (String)value;
                return Float.valueOf(Float.parseFloat(string));
            }
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
        return null;
    }

    public static ScriptFloat parseScriptFloat(String key, Object value, String scriptName) {
        try {
            if (value instanceof Integer) {
                Integer integer = (Integer)value;
                return new ScriptFloat(integer.floatValue());
            }
            if (value instanceof Double) {
                Double dbl = (Double)value;
                return new ScriptFloat(dbl.floatValue());
            }
            if (value instanceof Float) {
                Float flt = (Float)value;
                return new ScriptFloat(flt.floatValue());
            }
            if (value instanceof String) {
                String string = (String)value;
                if (((String)value).contains("~")) {
                    String[] strings = ((String)value).split("~");
                    return new ScriptFloat(Float.parseFloat(strings[0]), Float.parseFloat(strings[1]));
                }
                return new ScriptFloat(Float.parseFloat(string));
            }
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
        Logger.warn("Failed to parse " + value + " as double in " + scriptName + " for key " + key);
        return null;
    }

    public static <T extends Enum<T>> T parseEnum(String key, Object value, Class<T> enumClass, String scriptName) {
        if (enumClass.isAssignableFrom(Particle.class)) {
            value = LegacyValueConverter.parseParticle((String)value);
        } else if (enumClass.isAssignableFrom(PotionEffectType.class)) {
            value = LegacyValueConverter.parsePotionEffect((String)value);
        }
        try {
            return Enum.valueOf(enumClass, (String)value);
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
    }

    public static <T extends Enum<T>> List<T> parseEnumList(String key, Object value, Class<T> enumClass, String scriptName) {
        try {
            if (value instanceof List) {
                List valueList = (List)value;
                ArrayList<T> parsedList = new ArrayList<T>();
                for (Object rawEnum : valueList) {
                    if (!(rawEnum instanceof String)) {
                        Logger.warn("Expected string, got something else!");
                        MapListInterpreter.parsingErrorMessage(key, value, scriptName);
                        continue;
                    }
                    parsedList.add(Enum.valueOf(enumClass, (String)rawEnum));
                }
                return parsedList;
            }
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return null;
        }
    }

    public static <T extends Enum<T>> List<List<T>> parseEnumListList(String key, Object value, Class<T> enumClass, String scriptName) {
        ArrayList<List<T>> parsedList;
        block7: {
            parsedList = new ArrayList<List<T>>();
            try {
                if (value instanceof List) {
                    List valueList = (List)value;
                    for (Object rawLastList : valueList) {
                        if (!(rawLastList instanceof List)) {
                            Logger.warn("Expected list of list, got something else!");
                            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
                            return parsedList;
                        }
                        ArrayList<T> lastList = new ArrayList<T>();
                        for (Object rawEnum : (List)rawLastList) {
                            if (!(rawEnum instanceof String)) {
                                Logger.warn("Expected string, got something else!");
                                MapListInterpreter.parsingErrorMessage(key, value, scriptName);
                                continue;
                            }
                            lastList.add(Enum.valueOf(enumClass, (String)rawEnum));
                        }
                        parsedList.add(lastList);
                    }
                    break block7;
                }
                Logger.warn("Expected list, got something else!");
                MapListInterpreter.parsingErrorMessage(key, value, scriptName);
                return parsedList;
            }
            catch (Exception ex) {
                MapListInterpreter.parsingErrorMessage(key, value, scriptName);
                return parsedList;
            }
        }
        return parsedList;
    }

    public static Vector parseVector(String key, Object value, String scriptName) {
        try {
            String[] strings = ((String)value).split(",");
            return new Vector(Double.parseDouble(strings[0]), Double.parseDouble(strings[1]), Double.parseDouble(strings[2]));
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return new Vector(0, 0, 0);
        }
    }

    public static ScriptVector parseScriptVector(String key, Object value, String scriptName) {
        try {
            String[] strings = ((String)value).split(",");
            return new ScriptVector(MapListInterpreter.parseScriptFloat(key, strings[0], scriptName), MapListInterpreter.parseScriptFloat(key, strings[1], scriptName), MapListInterpreter.parseScriptFloat(key, strings[2], scriptName));
        }
        catch (Exception ex) {
            MapListInterpreter.parsingErrorMessage(key, value, scriptName);
            return new ScriptVector(new ScriptFloat(0.0f), new ScriptFloat(0.0f), new ScriptFloat(0.0f));
        }
    }
}

