/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils.shapes;

import com.magmaguy.elitemobs.utils.shapes.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class Cuboid
extends Shape {
    private final Float x;
    private final Float y;
    private final Float xBorder;
    private final Float yBorder;
    private Location centerLocation = null;
    private List<Vector> locationVectors = null;
    private List<Vector> edgeVectors = null;
    private Float z;
    private Float zBorder;

    public Cuboid(Float x, Float y, Float z, Float xBorder, Float yBorder, Float zBorder, Location centerLocation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xBorder = xBorder;
        this.yBorder = yBorder;
        this.zBorder = zBorder;
        this.centerLocation = centerLocation;
        if (x.floatValue() != 0.0f && z.floatValue() == 0.0f) {
            this.z = x;
        }
        if (xBorder.floatValue() != 0.0f && zBorder.floatValue() == 0.0f) {
            this.zBorder = xBorder;
        }
    }

    @Override
    public boolean contains(Location position) {
        Vector localVector = position.clone().subtract(this.centerLocation).toVector();
        if (Math.abs(localVector.getX()) > (double)this.x.floatValue()) {
            return false;
        }
        if (Math.abs(localVector.getY()) > (double)this.y.floatValue()) {
            return false;
        }
        return !(Math.abs(localVector.getZ()) > (double)this.z.floatValue());
    }

    @Override
    public boolean contains(LivingEntity livingEntity) {
        BoundingBox boundingBox = new BoundingBox(Math.floor((double)this.x.floatValue() / 2.0 + (double)this.centerLocation.getBlockX()), (double)this.y.floatValue() / 2.0 + (double)this.centerLocation.getBlockY(), Math.floor((double)this.z.floatValue() / 2.0 + (double)this.centerLocation.getBlockZ()), Math.floor((double)(-this.x.floatValue()) / 2.0 + (double)this.centerLocation.getBlockX()), (double)this.centerLocation.getBlockY(), Math.floor((double)(-this.z.floatValue()) / 2.0 + (double)this.centerLocation.getBlockZ()));
        return livingEntity.getBoundingBox().overlaps(boundingBox);
    }

    @Override
    public boolean borderContains(Location position) {
        Vector localVector = position.clone().subtract(this.centerLocation).toVector();
        if (!(Math.abs(localVector.getX()) <= (double)this.x.floatValue() / 2.0 && Math.abs(localVector.getX()) >= (double)this.xBorder.floatValue() / 2.0 || Math.abs(localVector.getZ()) <= (double)this.z.floatValue() / 2.0 && Math.abs(localVector.getZ()) >= (double)this.zBorder.floatValue() / 2.0)) {
            return false;
        }
        return !(this.y.floatValue() > 0.0f && Math.abs(localVector.getY()) <= (double)this.y.floatValue() && Math.abs(localVector.getY()) >= (double)this.yBorder.floatValue());
    }

    @Override
    public void visualize(Particle particle) {
    }

    @Override
    public Location getCenter() {
        return this.centerLocation;
    }

    @Override
    public List<Location> getEdgeLocations() {
        return this.convert(this.getEdgeVectors());
    }

    public List<Vector> getEdgeVectors() {
        if (this.edgeVectors != null) {
            return this.edgeVectors;
        }
        this.edgeVectors = new ArrayList<Vector>();
        for (Vector vector : this.getLocationVectors()) {
            if (!(vector.getY() <= (double)this.yBorder.floatValue()) || !(Math.abs(vector.getX()) >= Math.floor((double)this.xBorder.floatValue() / 2.0)) && !(Math.abs(vector.getZ()) >= Math.floor((double)this.zBorder.floatValue() / 2.0))) continue;
            this.edgeVectors.add(vector);
        }
        return this.edgeVectors;
    }

    private List<Vector> getLocationVectors() {
        if (this.locationVectors != null) {
            return this.locationVectors;
        }
        this.locationVectors = new ArrayList<Vector>();
        Float xHalf = Float.valueOf((float)Math.floor(this.x.floatValue() / 2.0f));
        Float zHalf = Float.valueOf((float)Math.floor(this.z.floatValue() / 2.0f));
        int localX = 0;
        while ((float)localX < this.x.floatValue()) {
            int localZ = 0;
            while ((float)localZ < this.z.floatValue()) {
                int localY = 0;
                while ((float)localY < this.y.floatValue()) {
                    this.locationVectors.add(new Vector((float)localX - xHalf.floatValue(), (float)localY, (float)localZ - zHalf.floatValue()));
                    ++localY;
                }
                ++localZ;
            }
            ++localX;
        }
        return this.locationVectors;
    }

    @Override
    public List<Location> getLocations() {
        return this.convert(this.getLocationVectors());
    }

    private List<Location> convert(List<Vector> vectors) {
        return vectors.stream().map(edge -> this.centerLocation.clone().add(edge)).collect(Collectors.toList());
    }
}

