/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils.shapes;

import com.magmaguy.elitemobs.utils.shapes.Shape;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class Ray
extends Shape {
    protected final double maxDistance = 500.0;
    protected final boolean ignoresSolidBlocks;
    protected double thickness;
    protected Location centerLocation;
    protected Location initialTargetLocation;
    protected List<Location> locations = new ArrayList<Location>();
    protected Location currentSource;
    protected Location currentTarget;

    public Ray(boolean ignoresSolidBlocks, double pointRadius, Location centerLocation, Location initialTargetLocation) {
        this.ignoresSolidBlocks = ignoresSolidBlocks;
        this.thickness = pointRadius;
        this.centerLocation = centerLocation;
        this.initialTargetLocation = initialTargetLocation;
        this.currentSource = centerLocation;
        this.currentTarget = initialTargetLocation;
    }

    protected List<Location> drawLine(Location location1, Location location2) {
        this.currentSource = location1;
        this.currentTarget = location2;
        ArrayList<Location> locations = new ArrayList<Location>();
        Vector raySegment = location2.clone().subtract(location1).toVector().normalize().multiply(this.thickness);
        Location currentLocation = location1.clone();
        locations.add(location1);
        int i = 0;
        while ((double)i < 500.0 && !(currentLocation.distanceSquared(location2) < Math.pow(this.thickness, 2.0))) {
            currentLocation.add(raySegment);
            if (!this.ignoresSolidBlocks && currentLocation.getBlock().getType().isSolid()) break;
            locations.add(currentLocation.clone());
            ++i;
        }
        return locations;
    }

    @Override
    public boolean contains(Location position) {
        for (Location location : this.locations) {
            if (!(location.distanceSquared(position) < Math.pow(this.thickness, 2.0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(LivingEntity livingEntity) {
        for (Location location : this.locations) {
            double closestX = this.clamp(location.getX(), livingEntity.getBoundingBox().getMinX(), livingEntity.getBoundingBox().getMaxX());
            double closestY = this.clamp(location.getY(), livingEntity.getBoundingBox().getMinY(), livingEntity.getBoundingBox().getMaxY());
            double closestZ = this.clamp(location.getZ(), livingEntity.getBoundingBox().getMinZ(), livingEntity.getBoundingBox().getMaxZ());
            double distanceSquared = location.distanceSquared(new Location(location.getWorld(), closestX, closestY, closestZ));
            if (!(distanceSquared <= this.thickness * this.thickness)) continue;
            return true;
        }
        return false;
    }

    private double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    @Override
    public boolean borderContains(Location position) {
        return false;
    }

    @Override
    public void visualize(Particle particle) {
    }

    @Override
    public Location getCenter() {
        return this.centerLocation;
    }

    @Override
    public List<Location> getEdgeLocations() {
        return null;
    }

    @Override
    public List<Location> getLocations() {
        return this.locations;
    }
}

