/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.wormhole;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.adventurersguild.GuildRank;
import com.magmaguy.elitemobs.config.WormholesConfig;
import com.magmaguy.elitemobs.economy.EconomyHandler;
import com.magmaguy.elitemobs.quests.playercooldowns.PlayerQuestCooldowns;
import com.magmaguy.elitemobs.utils.ChunkLocationChecker;
import com.magmaguy.elitemobs.wormhole.Wormhole;
import com.magmaguy.elitemobs.wormhole.WormholeEntry;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class WormholeManager {
    private static final long COOLDOWN_DURATION_SECONDS = 5L;
    private static final double PARTICLE_RENDER_DISTANCE = 30.0;
    private static final double SAFE_DISTANCE = 2.0;
    private static final double TELEPORT_DISTANCE_MULTIPLIER = 1.5;
    private static WormholeManager instance;
    private final Map<UUID, PlayerWormholeData> playerTeleportData = new HashMap<UUID, PlayerWormholeData>();
    private final Map<WormholeEntry, Integer> rotationCounters = new HashMap<WormholeEntry, Integer>();
    private BukkitTask wormholeTask;

    private WormholeManager() {
        this.startWormholeTask();
    }

    public static WormholeManager getInstance(boolean shuttingDown) {
        if (shuttingDown) {
            return instance;
        }
        if (instance == null) {
            instance = new WormholeManager();
        }
        if (WormholeManager.instance.wormholeTask == null || WormholeManager.instance.wormholeTask.isCancelled()) {
            instance.startWormholeTask();
        }
        return instance;
    }

    private HashSet<Player> getNearbyPlayers(WormholeEntry wormholeEntry) {
        HashSet<Player> nearbyPlayers = new HashSet<Player>();
        Location wormholeLocation = wormholeEntry.getLocation();
        if (wormholeLocation == null || wormholeLocation.getWorld() == null) {
            return nearbyPlayers;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getWorld().equals(wormholeLocation.getWorld()) || !(player.getLocation().distanceSquared(wormholeLocation) <= Math.pow(30.0, 2.0))) continue;
            nearbyPlayers.add(player);
        }
        return nearbyPlayers;
    }

    private void displayVisualEffects(WormholeEntry wormholeEntry, HashSet<Player> nearbyPlayers) {
        int rotationIndex = this.rotationCounters.getOrDefault(wormholeEntry, 0);
        if (rotationIndex >= wormholeEntry.getWormhole().getCachedRotations().size()) {
            rotationIndex = 0;
        }
        if (WormholesConfig.isReducedParticlesMode() && rotationIndex % 2 != 0) {
            this.rotationCounters.put(wormholeEntry, rotationIndex + 1);
            return;
        }
        if (wormholeEntry.getWormhole().getCachedRotations().isEmpty()) {
            return;
        }
        for (Player player : nearbyPlayers) {
            for (Vector vector : wormholeEntry.getWormhole().getCachedRotations().get(rotationIndex)) {
                Location particleLocation = wormholeEntry.getLocation().clone().add(vector);
                player.spawnParticle(Particle.DUST, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(wormholeEntry.getWormhole().getParticleColor(), 1.0f));
            }
        }
        this.rotationCounters.put(wormholeEntry, rotationIndex + 1);
    }

    private void checkForTeleports(WormholeEntry wormholeEntry, HashSet<Player> nearbyPlayers) {
        for (Player player : nearbyPlayers) {
            if (player.getLocation().distanceSquared(wormholeEntry.getLocation()) > Math.pow(1.5 * wormholeEntry.getWormhole().getWormholeConfigFields().getSizeMultiplier(), 2.0) || !this.canPlayerTeleport(wormholeEntry, player)) continue;
            this.teleportPlayer(wormholeEntry, player);
        }
    }

    private boolean canPlayerTeleport(WormholeEntry wormholeEntry, Player player) {
        PlayerWormholeData playerWormholeData;
        if (!(PlayerQuestCooldowns.getBypassedPlayers().contains(player) || wormholeEntry.getWormhole().getWormholeConfigFields().getPermission() == null || wormholeEntry.getWormhole().getWormholeConfigFields().getPermission().isEmpty() || player.hasPermission(wormholeEntry.getWormhole().getWormholeConfigFields().getPermission()))) {
            return false;
        }
        if (wormholeEntry.getWormhole().getWormholeConfigFields().getCoinCost() > 0.0) {
            double coinCost = wormholeEntry.getWormhole().getWormholeConfigFields().getCoinCost() + wormholeEntry.getWormhole().getWormholeConfigFields().getCoinCost() * GuildRank.currencyBonusMultiplier(player.getUniqueId());
            if (EconomyHandler.checkCurrency(player.getUniqueId()) < coinCost) {
                player.sendMessage(ChatColorConverter.convert(WormholesConfig.getInsufficientCurrencyForWormholeMessage()).replace("$amount", "" + coinCost));
                return false;
            }
            EconomyHandler.subtractCurrency(player.getUniqueId(), coinCost);
        }
        return (playerWormholeData = this.playerTeleportData.get(player.getUniqueId())) == null || playerWormholeData.canTeleport();
    }

    private void teleportPlayer(WormholeEntry sourceEntry, Player player) {
        WormholeEntry destinationEntry = sourceEntry == sourceEntry.getWormhole().getWormholeEntry1() ? sourceEntry.getWormhole().getWormholeEntry2() : sourceEntry.getWormhole().getWormholeEntry1();
        Location destination = destinationEntry.getLocation();
        if (destination == null || destination.getWorld() == null) {
            if (sourceEntry.getPortalMissingMessage() == null) {
                player.sendMessage(ChatColorConverter.convert(WormholesConfig.getDefaultPortalMissingMessage()));
            } else {
                player.sendMessage(sourceEntry.getPortalMissingMessage());
                if (player.isOp() || player.hasPermission("elitemobs.*")) {
                    player.sendMessage(sourceEntry.getOpMessage());
                }
            }
            return;
        }
        this.addPlayerToCooldown(player, destinationEntry);
        Location finalDestination = destination.clone();
        if (sourceEntry.getWormhole().getWormholeConfigFields().isBlindPlayer()) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 0));
        }
        player.teleport(finalDestination);
        player.playSound(player.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_CHARGE, 1.0f, 1.0f);
        player.setFlying(false);
    }

    public void addPlayerToCooldown(Player player, @NonNull WormholeEntry destinationEntry) {
        if (destinationEntry == null) {
            throw new NullPointerException("destinationEntry is marked non-null but is null");
        }
        this.playerTeleportData.put(player.getUniqueId(), new PlayerWormholeData(player, destinationEntry, System.currentTimeMillis()));
    }

    public void addPlayerToCooldown(Player player, Location destination) {
        WormholeEntry destinationEntry = null;
        for (WormholeEntry wormholeEntry : WormholeEntry.getWormholeEntries()) {
            if (wormholeEntry.getLocation() == null || wormholeEntry.getLocation().getWorld() == null || !wormholeEntry.getLocation().getWorld().equals(destination.getWorld()) || !(destination.distanceSquared(wormholeEntry.getLocation()) <= Math.pow(1.5 * wormholeEntry.getWormhole().getWormholeConfigFields().getSizeMultiplier(), 2.0))) continue;
            destinationEntry = wormholeEntry;
            break;
        }
        if (destinationEntry == null) {
            return;
        }
        this.addPlayerToCooldown(player, destinationEntry);
    }

    public void shutdown() {
        if (this.wormholeTask != null) {
            this.wormholeTask.cancel();
            this.wormholeTask = null;
        }
        this.playerTeleportData.clear();
        this.rotationCounters.clear();
    }

    private void startWormholeTask() {
        this.wormholeTask = new BukkitRunnable(){

            public void run() {
                WormholeManager.this.processWormholes();
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 5L);
    }

    private void processWormholes() {
        Collection<PlayerWormholeData> values = this.playerTeleportData.values();
        for (PlayerWormholeData value : values) {
            value.tick();
        }
        for (WormholeEntry wormholeEntry : WormholeEntry.getWormholeEntries()) {
            HashSet<Player> nearbyPlayers;
            if (wormholeEntry.getLocation() == null || !ChunkLocationChecker.locationIsLoaded(wormholeEntry.getLocation())) continue;
            if (!(wormholeEntry.getText() != null && wormholeEntry.getText().isValid() || wormholeEntry.getLocation() == null || wormholeEntry.getLocation().getWorld() == null)) {
                wormholeEntry.initializeTextDisplay();
            }
            if ((nearbyPlayers = this.getNearbyPlayers(wormholeEntry)).isEmpty()) continue;
            if (!WormholesConfig.isNoParticlesMode() && wormholeEntry.getWormhole().getWormholeConfigFields().getStyle() != Wormhole.WormholeStyle.NONE) {
                this.displayVisualEffects(wormholeEntry, nearbyPlayers);
            }
            this.checkForTeleports(wormholeEntry, nearbyPlayers);
        }
    }

    @Generated
    public Map<UUID, PlayerWormholeData> getPlayerTeleportData() {
        return this.playerTeleportData;
    }

    private class PlayerWormholeData {
        private final Player player;
        private final Location destination;
        private final long timeStamp;
        private final WormholeEntry wormholeEntry;
        private boolean hasLeftTeleportRadius = false;

        public PlayerWormholeData(Player player, WormholeEntry destinationWormhole, long timeStamp) {
            this.player = player;
            this.destination = destinationWormhole.getLocation();
            this.timeStamp = timeStamp;
            this.wormholeEntry = destinationWormhole;
        }

        public boolean canTeleport() {
            return this.timeStamp + 5000L < System.currentTimeMillis() && this.isHasLeftTeleportRadius();
        }

        public void tick() {
            if (this.isHasLeftTeleportRadius() && this.enoughTimeHasPassed()) {
                WormholeManager.this.playerTeleportData.remove(this.player.getUniqueId());
            }
        }

        private boolean enoughTimeHasPassed() {
            return this.timeStamp + 5000L < System.currentTimeMillis();
        }

        private boolean isHasLeftTeleportRadius() {
            if (this.hasLeftTeleportRadius) {
                return true;
            }
            if (!this.player.getWorld().equals(this.destination.getWorld())) {
                return false;
            }
            if (this.destination.distanceSquared(this.player.getLocation()) > Math.pow(1.5 * this.wormholeEntry.getWormhole().getWormholeConfigFields().getSizeMultiplier() + 2.0, 2.0)) {
                this.hasLeftTeleportRadius = true;
                return true;
            }
            return false;
        }
    }
}

