/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.api.utils;

import com.magmaguy.elitemobs.combatsystem.CombatSystem;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.items.EliteItemLore;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.SoulbindEnchantment;
import com.magmaguy.magmacore.util.AttributeManager;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class EliteItemManager {
    public static double getDPS(@Nullable ItemStack itemStack) {
        return EliteItemManager.getDPS(EliteItemManager.getAttackSpeed(itemStack), EliteItemManager.getBaseDamage(itemStack)) + EliteItemManager.getDPS(EliteItemManager.getAttackSpeed(itemStack), EliteItemManager.getEliteMobsSpecificDamage(itemStack));
    }

    public static double getDPS(Double attackSpeed, Double damage) {
        if (attackSpeed == null || damage == null) {
            return 4.0;
        }
        double attackSpeedPerSecond = 1.0 / attackSpeed;
        return damage / attackSpeedPerSecond;
    }

    public static double getBaseDamage(ItemStack itemStack) {
        double defaultDamage = 1.0;
        if (itemStack == null) {
            return defaultDamage;
        }
        if (itemStack.getType() == Material.BOW) {
            return 6.0;
        }
        if (itemStack.getType() == Material.CROSSBOW) {
            return 7.0;
        }
        try {
            for (AttributeModifier attributeModifier : itemStack.getType().getDefaultAttributeModifiers(EquipmentSlot.HAND).get((Object)AttributeManager.getAttribute("generic_attack_damage"))) {
                defaultDamage = EliteItemManager.attributeCrawler(defaultDamage, attributeModifier);
            }
        }
        catch (NoSuchMethodError e) {
            return 1.0;
        }
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta().getAttributeModifiers() != null && itemStack.getItemMeta().getAttributeModifiers(EquipmentSlot.HAND).containsKey((Object)AttributeManager.getAttribute("generic_attack_damage"))) {
            for (AttributeModifier attributeModifier : itemStack.getItemMeta().getAttributeModifiers().get((Object)AttributeManager.getAttribute("generic_attack_damage"))) {
                defaultDamage = EliteItemManager.attributeCrawler(defaultDamage, attributeModifier);
            }
        }
        return defaultDamage;
    }

    public static double getAttackSpeed(@Nullable ItemStack itemStack) {
        double defaultAttackSpeed = 4.0;
        if (itemStack == null) {
            return defaultAttackSpeed;
        }
        if (itemStack.getType() == Material.BOW) {
            return 1.0;
        }
        if (itemStack.getType() == Material.CROSSBOW) {
            return 0.8;
        }
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta().getAttributeModifiers() != null && itemStack.getItemMeta().getAttributeModifiers(EquipmentSlot.HAND).containsKey((Object)AttributeManager.getAttribute("generic_attack_speed"))) {
            for (AttributeModifier attributeModifier : itemStack.getItemMeta().getAttributeModifiers().get((Object)AttributeManager.getAttribute("generic_attack_speed"))) {
                defaultAttackSpeed = EliteItemManager.attributeCrawler(defaultAttackSpeed, attributeModifier);
            }
        } else {
            try {
                for (AttributeModifier attributeModifier : itemStack.getType().getDefaultAttributeModifiers(EquipmentSlot.HAND).get((Object)AttributeManager.getAttribute("generic_attack_speed"))) {
                    defaultAttackSpeed = EliteItemManager.attributeCrawler(defaultAttackSpeed, attributeModifier);
                }
            }
            catch (NoSuchMethodError e) {
                defaultAttackSpeed = 4.0;
            }
        }
        return defaultAttackSpeed;
    }

    private static double attributeCrawler(double baseValue, AttributeModifier attributeModifier) {
        switch (attributeModifier.getOperation()) {
            case ADD_NUMBER: {
                baseValue += attributeModifier.getAmount();
                break;
            }
            case MULTIPLY_SCALAR_1: 
            case ADD_SCALAR: {
                baseValue += baseValue * attributeModifier.getAmount();
            }
        }
        return baseValue;
    }

    public static double getWeaponLevel(@Nullable ItemStack itemStack) {
        return Math.max(Math.round((EliteItemManager.getDPS(EliteItemManager.getAttackSpeed(itemStack), EliteItemManager.getBaseDamage(itemStack)) + EliteItemManager.getDPS(EliteItemManager.getAttackSpeed(itemStack), ItemTagger.getEliteDamageAttribute(itemStack))) / 1.6), 0L);
    }

    public static double getEliteDamageFromEliteAttributes(@Nullable ItemStack itemStack) {
        return ItemTagger.getEliteDamageAttribute(itemStack);
    }

    public static double getEliteDamageFromEnchantments(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        int enchantmentLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.SHARPNESS.getKey());
        if (enchantmentLevel > 0 && ItemSettingsConfig.isUseEliteEnchantments()) {
            if ((enchantmentLevel -= Enchantment.SHARPNESS.getMaxLevel()) < 0) {
                enchantmentLevel = 0;
            }
        } else {
            enchantmentLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.POWER.getKey());
            if (enchantmentLevel > 0 && ItemSettingsConfig.isUseEliteEnchantments()) {
                enchantmentLevel -= Enchantment.POWER.getMaxLevel();
            }
            if (enchantmentLevel < 0) {
                enchantmentLevel = 0;
            }
        }
        if (enchantmentLevel < 1) {
            enchantmentLevel += itemStack.getEnchantmentLevel(Enchantment.POWER) + itemStack.getEnchantmentLevel(Enchantment.SHARPNESS);
        }
        if (enchantmentLevel == 0) {
            return 0.0;
        }
        return 1.0 + (double)enchantmentLevel * 0.5;
    }

    public static double getEliteMobsSpecificDamage(ItemStack itemStack) {
        return EliteItemManager.getEliteDamageFromEliteAttributes(itemStack) + EliteItemManager.getEliteDamageFromEnchantments(itemStack);
    }

    public static double getTotalDPS(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        double bonusDamage = EliteItemManager.getEliteMobsSpecificDamage(itemStack);
        if (bonusDamage == 0.0) {
            return 0.0;
        }
        return EliteItemManager.getDPS(EliteItemManager.getAttackSpeed(itemStack), bonusDamage);
    }

    public static double getEliteDefense(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return 0.0;
        }
        double materialValue = (double)CombatSystem.getMaterialTier(itemStack.getType()) / 4.0;
        double defenseAttribute = ItemTagger.getEliteDefenseAttribute(itemStack);
        return materialValue + defenseAttribute;
    }

    public static double getArmorLevel(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return 0.0;
        }
        return EliteItemManager.getEliteDefense(itemStack) * 4.0;
    }

    public static double getBonusEliteDefense(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return 0.0;
        }
        int enchantmentLevel = 0;
        enchantmentLevel = ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.PROTECTION.getKey());
        return (double)enchantmentLevel * 0.25;
    }

    public static double getItemLevel(@Nullable ItemStack itemStack) {
        double value = EliteItemManager.getWeaponLevel(itemStack);
        if (value > 3.0) {
            return value;
        }
        return EliteItemManager.getArmorLevel(itemStack);
    }

    public static int getRoundedItemLevel(@Nullable ItemStack itemStack) {
        return (int)Math.round(EliteItemManager.getItemLevel(itemStack));
    }

    public static boolean isWeapon(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.getType().equals((Object)Material.WOODEN_AXE) || itemStack.getType().equals((Object)Material.CROSSBOW)) {
            return true;
        }
        if (ItemSettingsConfig.isUseHoesAsWeapons() && (itemStack.getType().equals((Object)Material.WOODEN_HOE) || itemStack.getType().equals((Object)Material.GOLDEN_HOE) || itemStack.getType().equals((Object)Material.STONE_HOE) || itemStack.getType().equals((Object)Material.IRON_HOE) || itemStack.getType().equals((Object)Material.DIAMOND_HOE) || itemStack.getType().equals((Object)Material.NETHERITE_HOE))) {
            return true;
        }
        return EliteItemManager.getWeaponLevel(itemStack) > 3.0;
    }

    public static boolean isArmor(@Nullable ItemStack itemStack) {
        return EliteItemManager.getArmorLevel(itemStack) > 0.0;
    }

    public static void setEliteLevel(@Nullable ItemStack itemStack, int level) {
        double defense;
        if (itemStack == null) {
            return;
        }
        EliteItemManager.registerEliteItem(itemStack);
        if (EliteItemManager.isWeapon(itemStack)) {
            double damage = EliteItemManager.calculateEliteBonus(itemStack, level);
            if (damage > 0.0) {
                ItemTagger.setEliteDamageAttribute(itemStack, damage);
            }
        } else if (EliteItemManager.isArmor(itemStack) && (defense = EliteItemManager.calculateEliteBonus(itemStack, level)) > 0.0) {
            ItemTagger.setEliteDefenseAttribute(itemStack, defense);
        }
        new EliteItemLore(itemStack, false);
    }

    public static void setEliteLevel(@Nullable ItemStack itemStack, int level, boolean onlyArmorOrWeapons) {
        if (itemStack == null) {
            return;
        }
        if (EliteItemManager.isWeapon(itemStack)) {
            double damage = EliteItemManager.calculateEliteBonus(itemStack, level);
            if (damage > 0.0) {
                ItemTagger.setEliteDamageAttribute(itemStack, damage);
            }
        } else if (EliteItemManager.isArmor(itemStack)) {
            double defense = EliteItemManager.calculateEliteBonus(itemStack, level);
            if (defense > 0.0) {
                ItemTagger.setEliteDefenseAttribute(itemStack, defense);
            }
        } else if (onlyArmorOrWeapons) {
            return;
        }
        if (!EliteItemManager.isEliteMobsItem(itemStack)) {
            EliteItemManager.registerEliteItem(itemStack);
            new EliteItemLore(itemStack, false, true);
        } else {
            new EliteItemLore(itemStack, false, false);
        }
    }

    public static double calculateEliteBonus(ItemStack itemStack, int level) {
        if (EliteItemManager.isWeapon(itemStack)) {
            return (double)level * 1.6 / 1.0 / EliteItemManager.getAttackSpeed(itemStack) - EliteItemManager.getBaseDamage(itemStack);
        }
        if (EliteItemManager.isArmor(itemStack)) {
            return (double)(level - CombatSystem.getMaterialTier(itemStack.getType())) / 4.0;
        }
        return 0.0;
    }

    public static void tagArrow(@Nullable Projectile projectile) {
        if (projectile == null) {
            return;
        }
        if (!(projectile.getShooter() instanceof Player)) {
            return;
        }
        ItemTagger.setEliteDamageAttribute(projectile, EliteItemManager.getEliteMobsSpecificDamage(((Player)projectile.getShooter()).getInventory().getItemInMainHand()));
    }

    public static double getArrowEliteDamage(@Nullable Projectile projectile) {
        return ItemTagger.getEliteDamageAttribute(projectile);
    }

    public static boolean isEliteMobsItem(ItemStack itemStack) {
        return ItemTagger.isEliteItem(itemStack);
    }

    public static void registerEliteItem(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemTagger.registerEliteItem(itemMeta);
        itemStack.setItemMeta(itemMeta);
    }

    @Nullable
    public static boolean hasSoulbindEnchantment(@NotNull ItemMeta itemMeta) {
        return SoulbindEnchantment.itemHasSoulbindEnchantment(itemMeta);
    }

    @Nullable
    public static Player getSoulboundPlayer(@NotNull ItemMeta itemMeta) {
        return SoulbindEnchantment.getSoulboundPlayer(itemMeta);
    }
}

