/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.collateralminecraftchanges;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.config.ItemSettingsConfig;
import com.magmaguy.elitemobs.items.ItemTagger;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class AlternativeDurabilityLoss
implements Listener {
    private static double durabilityLoss(ItemStack itemStack) {
        boolean isWeaponMaterial = EliteItemManager.isWeapon(itemStack);
        int maxDurability = itemStack.getType().getMaxDurability() > (isWeaponMaterial ? (short)2000 : 1000) ? (isWeaponMaterial ? 2000 : 1000) : (int)itemStack.getType().getMaxDurability();
        double baseModifier = isWeaponMaterial ? 2000.0 : 1000.0;
        double durabilityLoss = (baseModifier - (double)maxDurability) / baseModifier * ItemSettingsConfig.getEliteDurabilityMultiplier();
        double durabilityLevel = 1.0 + (double)ItemTagger.getEnchantment(itemStack.getItemMeta(), Enchantment.UNBREAKING.getKey()) / 4.0;
        double defaultMultiplier = 0.5;
        return durabilityLoss / durabilityLevel * defaultMultiplier;
    }

    private static boolean isOnLastDamage(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!itemStack.hasItemMeta()) {
            return false;
        }
        if (!ItemTagger.isEliteItem(itemStack)) {
            return false;
        }
        if (!(itemStack.getItemMeta() instanceof Damageable)) {
            return false;
        }
        if (itemStack.getType().getMaxDurability() == 0) {
            return false;
        }
        return ((Damageable)itemStack.getItemMeta()).getDamage() + 1 >= itemStack.getType().getMaxDurability();
    }

    public static void doDurabilityLoss(Player player) {
        if (!ItemSettingsConfig.isEliteDurability()) {
            return;
        }
        ArrayList<ItemStack> itemsList = new ArrayList<ItemStack>(Arrays.stream(player.getInventory().getArmorContents()).toList());
        itemsList.add(player.getInventory().getItemInMainHand());
        itemsList.add(player.getInventory().getItemInOffHand());
        for (ItemStack itemStack : itemsList) {
            ItemMeta itemMeta;
            if (itemStack == null || itemStack.getType().getMaxDurability() == 0 || !EliteItemManager.isEliteMobsItem(itemStack) || !((itemMeta = itemStack.getItemMeta()) instanceof Damageable)) continue;
            Damageable damageable = (Damageable)itemMeta;
            short maxDurability = itemStack.getType().getMaxDurability();
            int durabilityLoss = (int)((double)maxDurability * AlternativeDurabilityLoss.durabilityLoss(itemStack));
            int currentDurability = damageable.getDamage();
            int newDurability = currentDurability + durabilityLoss;
            damageable.setDamage(newDurability);
            itemStack.setItemMeta((ItemMeta)damageable);
            if (newDurability < maxDurability) continue;
            if (ItemSettingsConfig.isPreventEliteItemsFromBreaking()) {
                damageable.setDamage(maxDurability - 1);
                itemStack.setItemMeta((ItemMeta)damageable);
                continue;
            }
            itemStack.setAmount(0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onDurabilityLoss(PlayerItemDamageEvent event) {
        if (!EliteItemManager.isEliteMobsItem(event.getItem())) {
            return;
        }
        if (!EliteItemManager.isArmor(event.getItem()) && !EliteItemManager.isWeapon(event.getItem())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDeath(PlayerDeathEvent event) {
        AlternativeDurabilityLoss.doDurabilityLoss(event.getEntity());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerShoot(EntityShootBowEvent event) {
        if (!EliteItemManager.isEliteMobsItem(event.getBow())) {
            return;
        }
        if (AlternativeDurabilityLoss.isOnLastDamage(event.getBow())) {
            event.setCancelled(true);
        }
    }
}

