/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.commands.admin;

import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.mobdata.aggressivemobs.EliteMobProperties;
import com.magmaguy.magmacore.util.ChatColorConverter;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class KillHandler {
    public static void killAggressiveMobs(CommandSender commandSender) {
        int counter = 0;
        for (EliteEntity eliteEntity : new ArrayList<EliteEntity>(EntityTracker.getEliteMobEntities().values())) {
            eliteEntity.remove(RemovalReason.OTHER);
            ++counter;
        }
        commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Killed " + counter + " Elite Mobs."));
    }

    public static void killEntityType(CommandSender commandSender, EntityType entityType) {
        if (EliteMobProperties.getValidMobTypes().contains(entityType)) {
            int counter = 0;
            for (EliteEntity eliteEntity : EntityTracker.getEliteMobEntities().values()) {
                if (!eliteEntity.getLivingEntity().getType().equals((Object)entityType)) continue;
                eliteEntity.remove(RemovalReason.OTHER);
                ++counter;
            }
            commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Killed " + counter + " Elite " + entityType.toString() + "."));
        } else {
            commandSender.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &cNot a valid entity type for EliteMobs!"));
        }
    }

    public static void radiusKillAggressiveMobs(Player player, int radius) {
        int counter = 0;
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(entity);
            if (eliteEntity == null) continue;
            eliteEntity.remove(RemovalReason.OTHER);
            ++counter;
        }
        player.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Killed " + counter + " Elite Mobs."));
    }

    public static void radiusKillSpecificMobs(Player player, EntityType entityType, int radius) {
        int counter = 0;
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            EliteEntity eliteEntity;
            if (!entity.getType().equals((Object)entityType) || (eliteEntity = EntityTracker.getEliteMobEntity(entity)) == null) continue;
            ((EliteEntity)entity).remove(RemovalReason.OTHER);
            ++counter;
        }
        player.sendMessage(ChatColorConverter.convert("&8[EliteMobs] &4Killed " + counter + " Elite Mobs."));
    }
}

