/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config;

import com.magmaguy.elitemobs.config.translations.TranslationsConfig;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class ConfigurationEngine
extends com.magmaguy.magmacore.config.ConfigurationEngine {
    public static String setString(File file, FileConfiguration fileConfiguration, String key, String defaultValue, boolean translatable) {
        fileConfiguration.addDefault(key, (Object)defaultValue);
        if (translatable) {
            return TranslationsConfig.add(file.getName(), key, ChatColorConverter.convert(fileConfiguration.getString(key)));
        }
        return ChatColorConverter.convert(fileConfiguration.getString(key));
    }

    public static String setString(List<String> comments, File file, FileConfiguration fileConfiguration, String key, String defaultValue, boolean translatable) {
        String value = ConfigurationEngine.setString(file, fileConfiguration, key, defaultValue, translatable);
        ConfigurationEngine.setComments(fileConfiguration, key, comments);
        return value;
    }

    public static List setList(File file, FileConfiguration fileConfiguration, String key, List defaultValue, boolean translatable) {
        fileConfiguration.addDefault(key, (Object)defaultValue);
        if (translatable) {
            return TranslationsConfig.add(file.getName(), key, fileConfiguration.getList(key));
        }
        return fileConfiguration.getList(key);
    }

    public static List setList(List<String> comment, File file, FileConfiguration fileConfiguration, String key, List defaultValue, boolean translatable) {
        List value = ConfigurationEngine.setList(file, fileConfiguration, key, defaultValue, translatable);
        ConfigurationEngine.setComments(fileConfiguration, key, comment);
        return value;
    }

    public static ItemStack setItemStack(File file, FileConfiguration fileConfiguration, String key, ItemStack itemStack, boolean translatable) {
        Material material;
        fileConfiguration.addDefault(key + ".material", (Object)itemStack.getType().toString());
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            fileConfiguration.addDefault(key + ".name", (Object)itemStack.getItemMeta().getDisplayName());
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasLore()) {
            fileConfiguration.addDefault(key + ".lore", (Object)itemStack.getItemMeta().getLore());
        }
        if (itemStack.getType().equals((Object)Material.PLAYER_HEAD)) {
            fileConfiguration.addDefault(key + ".owner", (Object)((SkullMeta)itemStack.getItemMeta()).getOwner());
        }
        try {
            material = Material.valueOf((String)fileConfiguration.getString(key + ".material"));
        }
        catch (Exception ex) {
            Logger.warn("Material type " + fileConfiguration.getString(key + ".material") + " is not valid! Correct it to make a valid item.");
            return null;
        }
        String name = "";
        try {
            name = ConfigurationEngine.setString(file, fileConfiguration, key + ".name", itemStack.getItemMeta().getDisplayName(), true);
        }
        catch (Exception ex) {
            Logger.warn("Item name " + fileConfiguration.getString(key + ".name") + " is not valid! Correct it to make a valid item.");
        }
        ArrayList<String> lore = new ArrayList();
        try {
            lore = ConfigurationEngine.setList(file, fileConfiguration, key + ".lore", null, true);
        }
        catch (Exception ex) {
            Logger.warn("Item lore " + fileConfiguration.getString(key + ".lore") + " is not valid! Correct it to make a valid item.");
        }
        ItemStack fileItemStack = ItemStackGenerator.generateItemStack(material, name, lore);
        if (material == Material.PLAYER_HEAD) {
            ((SkullMeta)itemStack.getItemMeta()).setOwningPlayer(Bukkit.getOfflinePlayer((String)fileConfiguration.getString(key + ".owner")));
        }
        return fileItemStack;
    }
}

