/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.customtreasurechests;

import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.items.customloottable.CustomLootTable;
import com.magmaguy.elitemobs.treasurechest.TreasureChest;
import com.magmaguy.elitemobs.utils.ConfigurationLocation;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;

public class CustomTreasureChestConfigFields
extends CustomConfigFields {
    private Material chestMaterial = Material.CHEST;
    private BlockFace facing = BlockFace.NORTH;
    private int chestTier = 0;
    private TreasureChest.DropStyle dropStyle = TreasureChest.DropStyle.SINGLE;
    private int restockTimer = 0;
    private List<Object> lootList = null;
    private double mimicChance = 0.0;
    private List<String> mimicCustomBossesList = null;
    private List<String> restockTimers = null;
    private List<String> effects = null;
    private String worldName;
    private Location location;
    private String locationString;
    private long restockTime = 0L;
    private List<String> locationsString = new ArrayList<String>();
    private CustomLootTable customLootTable = null;
    private boolean instanced = false;

    public CustomTreasureChestConfigFields(String filename, boolean isEnabled) {
        super(filename, isEnabled);
    }

    public CustomTreasureChestConfigFields(String fileName, boolean isEnabled, Material chestMaterial, BlockFace facing, int chestTier, Location location, TreasureChest.DropStyle dropStyle, int restockTimer, List<Object> lootList, double mimicChance, List<String> mimicCustomBossesList, long restockTime, List<String> restockTimers, List<String> effects) {
        super(fileName, isEnabled);
        this.chestMaterial = chestMaterial;
        this.facing = facing;
        this.chestTier = chestTier;
        this.location = location;
        this.dropStyle = dropStyle;
        this.restockTimer = restockTimer;
        this.lootList = lootList;
        this.mimicChance = mimicChance;
        this.mimicCustomBossesList = mimicCustomBossesList;
        this.restockTime = restockTime;
        this.restockTimers = restockTimers;
        this.effects = effects;
    }

    @Override
    public void processConfigFields() {
        this.isEnabled = this.processBoolean("isEnabled", this.isEnabled, false, false);
        this.chestMaterial = this.processEnum("chestType", this.chestMaterial, Material.CHEST, Material.class, true);
        this.facing = this.processEnum("facing", this.facing, BlockFace.NORTH, BlockFace.class, true);
        this.chestTier = this.processInt("chestTier", this.chestTier, 0, true);
        this.worldName = this.processString("location", this.worldName, null, false);
        if (this.worldName != null) {
            this.worldName = this.worldName.split(",")[0];
        }
        this.dropStyle = this.processEnum("dropStyle", this.dropStyle, TreasureChest.DropStyle.SINGLE, TreasureChest.DropStyle.class, true);
        this.restockTimer = this.processInt("restockTimer", this.restockTimer, 0, true);
        this.lootList = this.processList("lootList", this.lootList, new ArrayList<Object>(), false);
        this.customLootTable = new CustomLootTable(this);
        this.mimicChance = this.processDouble("mimicChance", this.mimicChance, 0.0, true);
        this.mimicCustomBossesList = this.processStringList("mimicCustomBossesList", this.mimicCustomBossesList, new ArrayList<String>(), true);
        this.restockTime = this.processLong("restockTime", this.restockTime, 0L, false);
        this.restockTimers = this.processStringList("restockTimers", this.restockTimers, new ArrayList<String>(), false);
        this.effects = this.processStringList("effects", this.effects, new ArrayList<String>(), false);
        this.locationsString = this.processStringList("locations", this.locationsString, new ArrayList<String>(), false);
        this.locationString = this.processString("location", this.locationString, null, false);
        this.instanced = this.processBoolean("instanced", this.instanced, false, false);
        if (this.locationString != null) {
            new TreasureChest(this, this.locationString, this.restockTime);
        } else if (this.locationsString != null) {
            for (String string : this.locationsString) {
                String[] strings = string.split(":");
                long timestamp = 0L;
                if (strings.length > 1) {
                    try {
                        timestamp = Long.parseLong(strings[1]);
                    }
                    catch (Exception exception) {
                        Logger.warn("Bad unix timestamp in locations for " + this.filename + " . Entry: " + strings[0]);
                    }
                }
                new TreasureChest(this, strings[0], timestamp);
            }
        } else {
            Logger.warn("No locations found for chest " + this.filename);
        }
    }

    public TreasureChest addTreasureChest(Location chestInstanceLocation, long unixTimeStamp) {
        int index = -1;
        String deserializedLocation = ConfigurationLocation.deserialize(chestInstanceLocation.getBlock().getLocation());
        for (String string : this.locationsString) {
            if (!string.split(":")[0].equals(deserializedLocation)) continue;
            index = this.locationsString.indexOf(string);
            break;
        }
        String serializedUpdatedLocation = deserializedLocation + ":" + unixTimeStamp;
        TreasureChest treasureChest = null;
        if (index != -1) {
            this.locationsString.set(index, serializedUpdatedLocation);
        } else {
            this.locationsString.add(serializedUpdatedLocation);
            treasureChest = new TreasureChest(this, ConfigurationLocation.deserialize(chestInstanceLocation), unixTimeStamp);
        }
        this.fileConfiguration.set("locations", this.locationsString);
        ConfigurationEngine.fileSaverCustomValues(this.fileConfiguration, this.file);
        return treasureChest;
    }

    public void setRestockTime(Location location, long newRestockTime) {
        if (this.isInstanced()) {
            return;
        }
        if (!this.locationsString.isEmpty()) {
            this.addTreasureChest(location, newRestockTime);
            return;
        }
        this.restockTime = newRestockTime;
        this.fileConfiguration.set("restockTime", (Object)newRestockTime);
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (Exception ex) {
            Logger.warn("Attempted to update restock time for a custom treasure chest and failed, did you delete it during runtime?");
        }
    }

    public void purgeLocations() {
        this.locationsString = new ArrayList<String>();
        ConfigurationEngine.writeValue(null, this.file, this.fileConfiguration, "locations");
        this.locationString = null;
        ConfigurationEngine.writeValue(null, this.file, this.fileConfiguration, "location");
    }

    @Generated
    public Material getChestMaterial() {
        return this.chestMaterial;
    }

    @Generated
    public BlockFace getFacing() {
        return this.facing;
    }

    @Generated
    public int getChestTier() {
        return this.chestTier;
    }

    @Generated
    public TreasureChest.DropStyle getDropStyle() {
        return this.dropStyle;
    }

    @Generated
    public int getRestockTimer() {
        return this.restockTimer;
    }

    @Generated
    public List<Object> getLootList() {
        return this.lootList;
    }

    @Generated
    public double getMimicChance() {
        return this.mimicChance;
    }

    @Generated
    public List<String> getMimicCustomBossesList() {
        return this.mimicCustomBossesList;
    }

    @Generated
    public List<String> getRestockTimers() {
        return this.restockTimers;
    }

    @Generated
    public List<String> getEffects() {
        return this.effects;
    }

    @Generated
    public String getWorldName() {
        return this.worldName;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public String getLocationString() {
        return this.locationString;
    }

    @Generated
    public long getRestockTime() {
        return this.restockTime;
    }

    @Generated
    public List<String> getLocationsString() {
        return this.locationsString;
    }

    @Generated
    public CustomLootTable getCustomLootTable() {
        return this.customLootTable;
    }

    @Generated
    public boolean isInstanced() {
        return this.instanced;
    }

    @Generated
    public void setInstanced(boolean instanced) {
        this.instanced = instanced;
    }
}

