/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.config.npcs;

import com.magmaguy.elitemobs.config.ConfigurationEngine;
import com.magmaguy.elitemobs.config.CustomConfigFields;
import com.magmaguy.elitemobs.npcs.NPCInteractions;
import com.magmaguy.magmacore.util.Logger;
import com.magmaguy.magmacore.util.VersionChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.entity.Villager;

public class NPCsConfigFields
extends CustomConfigFields {
    public String noPreviousLocationMessage;
    private String name = "";
    private String role = "";
    private Villager.Profession profession = Villager.Profession.NITWIT;
    private String spawnLocation;
    private List<String> greetings = new ArrayList<String>();
    private List<String> dialog = new ArrayList<String>();
    private List<String> farewell = new ArrayList<String>();
    private boolean canTalk = true;
    private double activationRadius = 3.0;
    private NPCInteractions.NPCInteractionType interactionType = NPCInteractions.NPCInteractionType.NONE;
    private double timeout = 0.0;
    private List<String> questFilenames = null;
    private String disguise = null;
    private String customDisguiseData = null;
    private String customModel = null;
    private String arenaFilename;
    private List<String> locations = new ArrayList<String>();
    private String command;
    private boolean instanced = false;
    private double scale = 1.0;

    public NPCsConfigFields(String fileName, boolean isEnabled, String name, String role, Villager.Profession profession, String location, List<String> greetings, List<String> dialog, List<String> farewell, boolean canTalk, double activationRadius, NPCInteractions.NPCInteractionType interactionType) {
        super(fileName, isEnabled);
        this.name = name;
        this.role = role;
        this.profession = profession;
        this.spawnLocation = location;
        this.greetings = greetings;
        this.dialog = dialog;
        this.farewell = farewell;
        this.canTalk = canTalk;
        this.activationRadius = activationRadius;
        this.interactionType = interactionType;
    }

    public NPCsConfigFields(String filename, boolean isEnabled) {
        super(filename, isEnabled);
    }

    public void setSpawnLocation(String spawnLocation) {
        this.locations.add(spawnLocation);
        this.fileConfiguration.set("spawnLocations", this.locations);
        try {
            ConfigurationEngine.fileSaverCustomValues(this.fileConfiguration, this.file);
        }
        catch (Exception ex) {
            Logger.warn("Attempted to update the location status for an NPC with no config file! Did you delete it during runtime?");
        }
    }

    @Override
    public void processConfigFields() {
        block5: {
            this.isEnabled = this.processBoolean("isEnabled", this.isEnabled, true, true);
            this.name = this.translatable(this.filename, "name", this.processString("name", this.name, "", true));
            this.role = this.translatable(this.filename, "role", this.processString("role", this.role, "", true));
            try {
                if (VersionChecker.serverVersionOlderThan(21, 4)) {
                    this.profession = Villager.Profession.valueOf((String)this.processString("profession", this.profession.toString(), Villager.Profession.NITWIT.toString(), false));
                    break block5;
                }
                for (Villager.Profession value : Villager.Profession.values()) {
                    if (!value.getKey().getKey().toLowerCase(Locale.ROOT).equals(this.profession.toString().toLowerCase(Locale.ROOT))) continue;
                    this.profession = value;
                    break;
                }
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            }
            catch (Exception e) {
                Logger.warn("NPC in configuration file " + this.filename + " has an invalid profession!");
                e.printStackTrace();
            }
        }
        this.spawnLocation = this.processString("spawnLocation", this.spawnLocation, null, true);
        this.locations = this.processStringList("spawnLocations", this.locations, null, false);
        this.greetings = this.translatable(this.filename, "greetings", this.processStringList("greetings", this.greetings, new ArrayList<String>(), true));
        this.dialog = this.translatable(this.filename, "dialog", this.processStringList("dialog", this.dialog, new ArrayList<String>(), true));
        this.farewell = this.translatable(this.filename, "farewell", this.processStringList("farewell", this.farewell, new ArrayList<String>(), true));
        this.canTalk = this.processBoolean("canTalk", this.canTalk, true, true);
        this.activationRadius = this.processDouble("activationRadius", this.activationRadius, 3.0, true);
        this.interactionType = this.processEnum("interactionType", this.interactionType, NPCInteractions.NPCInteractionType.NONE, NPCInteractions.NPCInteractionType.class, true);
        this.timeout = this.processDouble("timeout", this.timeout, 0.0, false);
        this.noPreviousLocationMessage = this.translatable(this.filename, "noPreviousLocationMessage", this.processString("noPreviousLocationMessage", this.noPreviousLocationMessage, "", false));
        this.questFilenames = this.processStringList("questFileName", this.questFilenames, new ArrayList<String>(), false);
        this.disguise = this.processString("disguise", this.disguise, null, false);
        this.customDisguiseData = this.processString("customDisguiseData", this.customDisguiseData, null, false);
        this.customModel = this.processString("customModel", this.customModel, null, false);
        this.arenaFilename = this.processString("arena", this.arenaFilename, null, false);
        this.command = this.processString("command", this.command, null, false);
        this.instanced = this.processBoolean("instanced", this.instanced, false, false);
        this.scale = this.processDouble("scale", this.scale, 1.0, false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.fileConfiguration.set("isEnabled", (Object)enabled);
        try {
            ConfigurationEngine.fileSaverCustomValues(this.fileConfiguration, this.file);
        }
        catch (Exception e) {
            Logger.warn("Attempted to update the enabled status for an NPC with no config file! Did you delete it during runtime?");
        }
    }

    public void removeNPC(String locationString) {
        if (this.locations == null) {
            return;
        }
        this.locations.removeIf(entry -> entry.equals(locationString));
        this.fileConfiguration.set("spawnLocations", this.locations);
        try {
            ConfigurationEngine.fileSaverCustomValues(this.fileConfiguration, this.file);
        }
        catch (Exception ex) {
            Logger.warn("Attempted to update the location status for an NPC with no config file! Did you delete it during runtime?");
        }
    }

    @Generated
    public String getNoPreviousLocationMessage() {
        return this.noPreviousLocationMessage;
    }

    @Generated
    public void setNoPreviousLocationMessage(String noPreviousLocationMessage) {
        this.noPreviousLocationMessage = noPreviousLocationMessage;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public Villager.Profession getProfession() {
        return this.profession;
    }

    @Generated
    public void setProfession(Villager.Profession profession) {
        this.profession = profession;
    }

    @Generated
    public String getSpawnLocation() {
        return this.spawnLocation;
    }

    @Generated
    public List<String> getGreetings() {
        return this.greetings;
    }

    @Generated
    public void setGreetings(List<String> greetings) {
        this.greetings = greetings;
    }

    @Generated
    public List<String> getDialog() {
        return this.dialog;
    }

    @Generated
    public void setDialog(List<String> dialog) {
        this.dialog = dialog;
    }

    @Generated
    public List<String> getFarewell() {
        return this.farewell;
    }

    @Generated
    public void setFarewell(List<String> farewell) {
        this.farewell = farewell;
    }

    @Generated
    public boolean isCanTalk() {
        return this.canTalk;
    }

    @Generated
    public void setCanTalk(boolean canTalk) {
        this.canTalk = canTalk;
    }

    @Generated
    public double getActivationRadius() {
        return this.activationRadius;
    }

    @Generated
    public void setActivationRadius(double activationRadius) {
        this.activationRadius = activationRadius;
    }

    @Generated
    public NPCInteractions.NPCInteractionType getInteractionType() {
        return this.interactionType;
    }

    @Generated
    public void setInteractionType(NPCInteractions.NPCInteractionType interactionType) {
        this.interactionType = interactionType;
    }

    @Generated
    public double getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(double timeout) {
        this.timeout = timeout;
    }

    @Generated
    public List<String> getQuestFilenames() {
        return this.questFilenames;
    }

    @Generated
    public void setQuestFilenames(List<String> questFilenames) {
        this.questFilenames = questFilenames;
    }

    @Generated
    public String getDisguise() {
        return this.disguise;
    }

    @Generated
    public void setDisguise(String disguise) {
        this.disguise = disguise;
    }

    @Generated
    public String getCustomDisguiseData() {
        return this.customDisguiseData;
    }

    @Generated
    public void setCustomDisguiseData(String customDisguiseData) {
        this.customDisguiseData = customDisguiseData;
    }

    @Generated
    public String getCustomModel() {
        return this.customModel;
    }

    @Generated
    public void setCustomModel(String customModel) {
        this.customModel = customModel;
    }

    @Generated
    public String getArenaFilename() {
        return this.arenaFilename;
    }

    @Generated
    public void setArenaFilename(String arenaFilename) {
        this.arenaFilename = arenaFilename;
    }

    @Generated
    public List<String> getLocations() {
        return this.locations;
    }

    @Generated
    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public boolean isInstanced() {
        return this.instanced;
    }

    @Generated
    public void setInstanced(boolean instanced) {
        this.instanced = instanced;
    }

    @Generated
    public double getScale() {
        return this.scale;
    }

    @Generated
    public void setScale(double scale) {
        this.scale = scale;
    }
}

