/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.entitytracker;

import com.magmaguy.elitemobs.CrashFix;
import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobSpawnEvent;
import com.magmaguy.elitemobs.api.NPCEntitySpawnEvent;
import com.magmaguy.elitemobs.api.internal.RemovalReason;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.tagger.PersistentTagger;
import com.magmaguy.elitemobs.utils.EventCaller;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EntityTracker
implements Listener {
    private static final HashMap<UUID, EliteEntity> eliteMobEntities = new HashMap();
    private static final HashMap<UUID, NPCEntity> npcEntities = new HashMap();
    private static final HashSet<Block> temporaryBlocks = new HashSet();
    private static BukkitTask ManagedEntityTask = null;

    public static void registerEliteMob(EliteEntity eliteEntity) {
        EliteMobSpawnEvent eliteMobSpawnEvent = new EliteMobSpawnEvent(eliteEntity);
        new EventCaller(eliteMobSpawnEvent);
        if (eliteMobSpawnEvent.isCancelled()) {
            return;
        }
        PersistentTagger.tagElite((Entity)eliteEntity.getLivingEntity(), eliteEntity.getEliteUUID());
        eliteMobEntities.put(eliteEntity.getEliteUUID(), eliteEntity);
    }

    public static void registerEliteMob(EliteEntity eliteEntity, LivingEntity livingEntity) {
        EliteMobSpawnEvent eliteMobSpawnEvent = new EliteMobSpawnEvent(eliteEntity);
        new EventCaller(eliteMobSpawnEvent);
        if (eliteMobSpawnEvent.isCancelled()) {
            return;
        }
        PersistentTagger.tagElite((Entity)livingEntity, eliteEntity.getEliteUUID());
        eliteMobEntities.put(eliteEntity.getEliteUUID(), eliteEntity);
    }

    public static boolean isEliteMob(Entity entity) {
        return PersistentTagger.isEliteEntity(entity);
    }

    @Nullable
    public static EliteEntity getEliteMobEntity(Entity entity) {
        return PersistentTagger.getEliteEntity(entity);
    }

    public static void registerVisualEffects(Entity entity) {
        PersistentTagger.tagVisualEffect(entity);
    }

    public static boolean isVisualEffect(Entity entity) {
        return PersistentTagger.isVisualEffect(entity);
    }

    public static boolean unregisterEliteEntity(Entity entity, RemovalReason removalReason) {
        EliteEntity eliteEntity = EntityTracker.getEliteMobEntity(entity);
        if (eliteEntity == null) {
            return false;
        }
        eliteEntity.remove(removalReason);
        return true;
    }

    public static void registerNPCEntity(NPCEntity npc) {
        NPCEntitySpawnEvent npcEntitySpawnEvent = new NPCEntitySpawnEvent((LivingEntity)npc.getVillager(), npc);
        new EventCaller(npcEntitySpawnEvent);
        if (npcEntitySpawnEvent.isCancelled()) {
            return;
        }
        npcEntities.put(npc.getUuid(), npc);
        PersistentTagger.tagNPC((Entity)npc.getVillager(), npc.getUuid());
    }

    public static boolean isNPCEntity(Entity entity) {
        return PersistentTagger.isNPC(entity);
    }

    public static NPCEntity getNPCEntity(Entity entity) {
        return PersistentTagger.getNPC(entity);
    }

    public static boolean unregisterVisualEffect(Entity entity) {
        if (EntityTracker.isVisualEffect(entity)) {
            entity.remove();
            return true;
        }
        return false;
    }

    public static void addTemporaryBlock(final Block block, int ticks, Material replacementMaterial) {
        BlockData previousBlockData = block.getBlockData().clone();
        if (temporaryBlocks.contains(block)) {
            previousBlockData = null;
        }
        if (temporaryBlocks.contains(block) && block.getType().equals((Object)Material.RED_BANNER)) {
            return;
        }
        temporaryBlocks.add(block);
        block.setType(replacementMaterial);
        final UUID worldUUID = block.getWorld().getUID();
        final BlockData finalPreviousBlockData = previousBlockData;
        if (ticks < 0) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (Bukkit.getWorld((UUID)worldUUID) == null) {
                    return;
                }
                temporaryBlocks.remove(block);
                if (!block.getBlockData().equals(finalPreviousBlockData)) {
                    if (finalPreviousBlockData != null) {
                        block.setBlockData(finalPreviousBlockData);
                    } else {
                        block.setType(Material.AIR);
                    }
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, (long)ticks);
    }

    public static boolean isTemporaryBlock(Block block) {
        return temporaryBlocks.contains(block);
    }

    public static void removeTemporaryBlock(Block block) {
        temporaryBlocks.remove(block);
    }

    public static void registerProjectileEntity(Projectile projectile) {
        PersistentTagger.tagEliteProjectile(projectile);
    }

    public static boolean isProjectileEntity(Entity entity) {
        return PersistentTagger.isEliteProjectile(entity);
    }

    public static boolean unregisterNPCEntity(Entity entity, RemovalReason removalReason) {
        NPCEntity npcEntity = EntityTracker.getNPCEntity(entity);
        if (npcEntity == null) {
            return false;
        }
        npcEntity.remove(removalReason);
        return true;
    }

    public static boolean unregisterProjectileEntity(Entity entity) {
        if (EntityTracker.isProjectileEntity(entity)) {
            entity.remove();
            return true;
        }
        return false;
    }

    public static void wipeChunk(Chunk chunk, RemovalReason removalReason) {
        for (Entity entity : chunk.getEntities()) {
            EntityTracker.unregister(entity, removalReason);
        }
    }

    public static void wipeWorld(World world, RemovalReason removalReason) {
        for (Chunk chunk : world.getLoadedChunks()) {
            EntityTracker.wipeChunk(chunk, removalReason);
        }
    }

    public static void unregister(Entity entity, RemovalReason removalReason) {
        if (EntityTracker.unregisterEliteEntity(entity, removalReason)) {
            return;
        }
        if (EntityTracker.unregisterVisualEffect(entity)) {
            return;
        }
        if (EntityTracker.unregisterProjectileEntity(entity)) {
            return;
        }
        if (EntityTracker.unregisterNPCEntity(entity, removalReason)) {
            // empty if block
        }
    }

    public static void wipeShutdown() {
        if (ManagedEntityTask != null) {
            ManagedEntityTask.cancel();
        }
        for (EliteEntity eliteEntity : ((HashMap)eliteMobEntities.clone()).values()) {
            eliteEntity.remove(RemovalReason.SHUTDOWN);
        }
        EntityTracker.getEliteMobEntities().clear();
        for (NPCEntity npcEntity : ((HashMap)npcEntities.clone()).values()) {
            npcEntity.remove(RemovalReason.SHUTDOWN);
        }
        EntityTracker.getNpcEntities().clear();
        for (Block block : temporaryBlocks) {
            block.setType(Material.AIR);
        }
        temporaryBlocks.clear();
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                EntityTracker.unregister(entity, RemovalReason.SHUTDOWN);
            }
        }
        CustomBossEntity.getTrackableCustomBosses().clear();
        CrashFix.knownSessionChunks.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent event) {
        EntityTracker.wipeWorld(event.getWorld(), RemovalReason.WORLD_UNLOAD);
        temporaryBlocks.removeIf(block -> block.getWorld().equals(event.getWorld()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onMine(BlockBreakEvent event) {
        if (!EntityTracker.isTemporaryBlock(event.getBlock())) {
            return;
        }
        event.setDropItems(false);
        EntityTracker.removeTemporaryBlock(event.getBlock());
    }

    public static void managedEntityWatchdog() {
        ManagedEntityTask = new BukkitRunnable(){

            public void run() {
                new HashSet<EliteEntity>(eliteMobEntities.values()).forEach(value -> {
                    if (value.getLivingEntity() != null && !value.getLivingEntity().isValid()) {
                        value.remove(RemovalReason.CHUNK_UNLOAD);
                    }
                });
                new HashSet<NPCEntity>(npcEntities.values()).forEach(value -> {
                    if (value.getVillager() != null && !value.getVillager().isValid()) {
                        value.remove(RemovalReason.CHUNK_UNLOAD);
                    }
                });
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onRemove(EntityRemoveEvent event) {
        if (event.getCause().equals((Object)EntityRemoveEvent.Cause.UNLOAD)) {
            EntityTracker.unregister(event.getEntity(), RemovalReason.CHUNK_UNLOAD);
        }
    }

    @Generated
    public static HashMap<UUID, EliteEntity> getEliteMobEntities() {
        return eliteMobEntities;
    }

    @Generated
    public static HashMap<UUID, NPCEntity> getNpcEntities() {
        return npcEntities;
    }

    @Generated
    public static HashSet<Block> getTemporaryBlocks() {
        return temporaryBlocks;
    }
}

