/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.instanced.dungeons;

import com.magmaguy.elitemobs.api.EliteMobDeathEvent;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonInstance;
import com.magmaguy.elitemobs.instanced.dungeons.DungeonObjective;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.InstancedBossEntity;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class DungeonKillTargetObjective
extends DungeonObjective {
    private static final List<DungeonKillTargetObjective> dungeonKillTargetObjectiveList = new ArrayList<DungeonKillTargetObjective>();
    private String bossFilename;
    private int targetAmount = 1;
    private int currentAmount = 0;

    public DungeonKillTargetObjective(DungeonInstance dungeonInstance, String objectiveString) {
        super(dungeonInstance, objectiveString);
        String[] strings;
        for (String seperatedByColon : strings = objectiveString.split(":")) {
            String[] separatedByEquals = seperatedByColon.split("=");
            if (separatedByEquals[0].equalsIgnoreCase("filename")) {
                this.bossFilename = separatedByEquals[1];
                continue;
            }
            if (separatedByEquals[0].equalsIgnoreCase("amount")) {
                try {
                    this.targetAmount = Integer.parseInt(separatedByEquals[1]);
                }
                catch (Exception ex) {
                    Logger.warn("Value " + separatedByEquals[1] + " is not a valid integer amount!");
                }
                continue;
            }
            Logger.warn("Invalid entry for objective string! " + objectiveString + " could not be parsed correctly.");
        }
        this.initializeObjective(dungeonInstance);
    }

    @Override
    protected void initializeObjective(DungeonInstance dungeonInstance) {
        super.initializeObjective(dungeonInstance);
        dungeonKillTargetObjectiveList.add(this);
    }

    public void incrementKills() {
        ++this.currentAmount;
        if (this.currentAmount >= this.targetAmount) {
            this.completed = true;
            this.dungeonInstance.checkCompletionStatus();
            dungeonKillTargetObjectiveList.remove(this);
        }
    }

    @Generated
    public String getBossFilename() {
        return this.bossFilename;
    }

    @Generated
    public int getTargetAmount() {
        return this.targetAmount;
    }

    @Generated
    public int getCurrentAmount() {
        return this.currentAmount;
    }

    public static class DungeonKillTargetObjectiveListener
    implements Listener {
        @EventHandler
        public void onEliteDeath(EliteMobDeathEvent event) {
            EliteEntity eliteEntity = event.getEliteEntity();
            if (!(eliteEntity instanceof InstancedBossEntity)) {
                return;
            }
            InstancedBossEntity instancedBossEntity = (InstancedBossEntity)eliteEntity;
            ArrayList<DungeonKillTargetObjective> cloneList = new ArrayList<DungeonKillTargetObjective>(dungeonKillTargetObjectiveList);
            for (DungeonKillTargetObjective dungeonKillTargetObjective : cloneList) {
                if (!instancedBossEntity.getCustomBossesConfigFields().getFilename().equals(dungeonKillTargetObjective.getBossFilename()) && (instancedBossEntity.getPhaseBossEntity() == null || !instancedBossEntity.getPhaseBossEntity().getPhase1Config().getFilename().equals(dungeonKillTargetObjective.getBossFilename()))) continue;
                dungeonKillTargetObjective.incrementKills();
            }
        }
    }
}

