/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.items.customenchantments;

import com.magmaguy.elitemobs.api.utils.EliteItemManager;
import com.magmaguy.elitemobs.items.ItemTagger;
import com.magmaguy.elitemobs.items.customenchantments.CustomEnchantment;
import com.magmaguy.elitemobs.items.customitems.CustomItem;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.magmacore.util.Logger;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RepairEnchantment
extends CustomEnchantment {
    public static String key = "repair";

    public RepairEnchantment() {
        super(key, false);
    }

    public static ItemStack generateScrap(ItemStack itemToScrap, Player player, EliteEntity eliteEntity) {
        CustomItem scrapItem;
        int tier = EliteItemManager.getRoundedItemLevel(itemToScrap);
        int scrapLevel = tier < 50 ? 1 : (tier < 100 ? 2 : (tier < 150 ? 3 : (tier < 200 ? 4 : 5)));
        switch (scrapLevel) {
            case 1: {
                CustomItem customItem = CustomItem.getCustomItem("elite_scrap_tiny.yml");
                break;
            }
            case 2: {
                CustomItem customItem = CustomItem.getCustomItem("elite_scrap_small.yml");
                break;
            }
            case 3: {
                CustomItem customItem = CustomItem.getCustomItem("elite_scrap_medium.yml");
                break;
            }
            case 4: {
                CustomItem customItem = CustomItem.getCustomItem("elite_scrap_large.yml");
                break;
            }
            case 5: {
                CustomItem customItem = CustomItem.getCustomItem("elite_scrap_huge.yml");
                break;
            }
            default: {
                CustomItem customItem = scrapItem = CustomItem.getCustomItem("elite_scrap_tiny.yml");
            }
        }
        if (scrapItem == null) {
            Logger.warn("Failed to generate scrap! Was the default elite scrap disabled?");
            return null;
        }
        return scrapItem.generateItemStack(scrapLevel, player, eliteEntity);
    }

    public static boolean isRepairItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return false;
        }
        return ItemTagger.hasEnchantment(itemStack.getItemMeta(), key);
    }

    public static int getRepairLevel(ItemStack itemStack) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return 0;
        }
        return ItemTagger.getEnchantment(itemStack.getItemMeta(), key);
    }
}

