/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.menus;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.CustomModelsConfig;
import com.magmaguy.elitemobs.config.DefaultConfig;
import com.magmaguy.elitemobs.config.menus.premade.BuyOrSellMenuConfig;
import com.magmaguy.elitemobs.menus.CustomShopMenu;
import com.magmaguy.elitemobs.menus.EliteMenu;
import com.magmaguy.elitemobs.menus.ProceduralShopMenu;
import com.magmaguy.elitemobs.menus.SellMenu;
import com.magmaguy.elitemobs.menus.SharedShopElements;
import com.magmaguy.elitemobs.utils.CustomModelAdder;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BuyOrSellMenu {
    public static void constructBuyOrSellMenu(Player player, ItemStack buyItemStack) {
        Object inventoryName = BuyOrSellMenuConfig.SHOP_NAME;
        if (DefaultConfig.useResourcePackModels()) {
            inventoryName = ChatColor.WHITE + "\uf801\udb80\udc7b\uf805       " + (String)inventoryName;
        }
        Inventory shopInventory = Bukkit.createInventory((InventoryHolder)player, (int)18, (String)inventoryName);
        BuyOrSellMenuEvents.menus.add(shopInventory);
        ItemStack info = BuyOrSellMenuConfig.INFORMATION_ITEM;
        if (DefaultConfig.useResourcePackModels()) {
            info.setType(Material.PAPER);
            ItemMeta itemMeta = info.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(MetadataHandler.signatureID));
            info.setItemMeta(itemMeta);
            CustomModelAdder.addCustomModel(info, CustomModelsConfig.goldenQuestionMark);
        }
        shopInventory.setItem(BuyOrSellMenuConfig.INFORMATION_SLOT, info);
        shopInventory.setItem(BuyOrSellMenuConfig.SELL_SLOT, BuyOrSellMenuConfig.SELL_ITEM);
        shopInventory.setItem(BuyOrSellMenuConfig.BUY_SLOT, buyItemStack);
        player.openInventory(shopInventory);
    }

    public static class BuyOrSellMenuEvents
    implements Listener {
        public static final Set<Inventory> menus = new HashSet<Inventory>();

        @EventHandler
        public void onInventoryInteraction(InventoryClickEvent event) {
            if (!EliteMenu.isEliteMenu(event, menus)) {
                return;
            }
            event.setCancelled(true);
            if (!SharedShopElements.itemNullPointerPrevention(event)) {
                return;
            }
            if (event.getCurrentItem().equals((Object)BuyOrSellMenuConfig.INFORMATION_ITEM)) {
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(BuyOrSellMenuConfig.BUY_CUSTOM_ITEM.getItemMeta().getDisplayName())) {
                CustomShopMenu.customShopConstructor((Player)event.getWhoClicked());
                menus.remove((Player)event.getWhoClicked());
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(BuyOrSellMenuConfig.BUY_PROCEDURAL_ITEM.getItemMeta().getDisplayName())) {
                ProceduralShopMenu.shopConstructor((Player)event.getWhoClicked());
                menus.remove((Player)event.getWhoClicked());
                return;
            }
            if (event.getCurrentItem().getItemMeta().getDisplayName().equals(BuyOrSellMenuConfig.SELL_ITEM.getItemMeta().getDisplayName())) {
                SellMenu sellMenu = new SellMenu();
                sellMenu.constructSellMenu((Player)event.getWhoClicked());
                menus.remove((Player)event.getWhoClicked());
            }
        }

        @EventHandler
        public void onClose(InventoryCloseEvent event) {
            menus.remove(event.getInventory());
        }
    }
}

