/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.mobconstructor.custombosses;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.PlayerTeleportEvent;
import com.magmaguy.elitemobs.config.contentpackages.ContentPackagesConfigFields;
import com.magmaguy.elitemobs.dungeons.EliteMobsWorld;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import com.magmaguy.magmacore.util.Logger;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CustomMusic {
    private static final HashMap<Player, CustomMusic> playerSongSingleton = new HashMap();
    private static final HashMap<World, CustomMusic> dungeonMusic = new HashMap();
    private final HashMap<Player, CustomMusic> players = new HashMap();
    private final ContentType contentType;
    private CustomBossEntity customBossEntity = null;
    private ContentPackagesConfigFields contentPackagesConfigFields = null;
    private String name;
    private int durationTicks;
    private String name2 = null;
    private int durationTicks2 = -1;
    private BukkitTask bossScannerTask = null;
    private BukkitTask songTask = null;
    private World world;

    public CustomMusic(String rawString, CustomBossEntity customBossEntity) {
        this.customBossEntity = customBossEntity;
        this.contentType = ContentType.BOSS;
        if (!rawString.contains("->")) {
            this.parse(rawString, 1);
        } else {
            String[] rawEntries = rawString.split("->");
            this.parse(rawEntries[0], 1);
            this.parse(rawEntries[1], 2);
        }
    }

    public CustomMusic(String rawString, ContentPackagesConfigFields contentPackagesConfigFields, World world) {
        this.world = world;
        this.contentPackagesConfigFields = contentPackagesConfigFields;
        this.contentType = ContentType.DUNGEON;
        if (!rawString.contains("->")) {
            this.parse(rawString, 1);
        } else {
            String[] rawEntries = rawString.split("->");
            this.parse(rawEntries[0], 1);
            this.parse(rawEntries[1], 2);
        }
        dungeonMusic.put(world, this);
    }

    public static void shutdown() {
        dungeonMusic.clear();
        playerSongSingleton.clear();
    }

    private void parse(String rawString, int entryNumber) {
        String[] strings;
        block8: for (String string : strings = rawString.split(" ")) {
            String[] parsed = string.split("=");
            switch (parsed[0]) {
                case "name": {
                    if (entryNumber == 1) {
                        this.name = parsed[1];
                        continue block8;
                    }
                    this.name2 = parsed[1];
                    continue block8;
                }
                case "length": {
                    if (entryNumber == 1) {
                        this.durationTicks = (int)((double)Integer.parseInt(parsed[1]) / 1000.0 * 20.0);
                        continue block8;
                    }
                    this.durationTicks2 = (int)((double)Integer.parseInt(parsed[1]) / 1000.0 * 20.0);
                    continue block8;
                }
                default: {
                    Logger.warn("Failed to get value for boss music!");
                }
            }
        }
    }

    public void start(final CustomBossEntity customBossEntity) {
        if (this.bossScannerTask != null) {
            this.bossScannerTask.cancel();
        }
        this.bossScannerTask = new BukkitRunnable(){

            public void run() {
                if (!customBossEntity.exists()) {
                    CustomMusic.this.stop();
                    return;
                }
                CustomMusic.this.play(customBossEntity.getLocation(), customBossEntity.getCustomBossesConfigFields().getFollowDistance().intValue());
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 10L);
    }

    public void stop() {
        if (this.bossScannerTask != null) {
            this.bossScannerTask.cancel();
        }
        for (Map.Entry<Player, CustomMusic> entry : this.players.entrySet()) {
            entry.getKey().stopSound(this.name);
            if (this.name2 != null) {
                entry.getKey().stopSound(this.name2);
            }
            entry.getValue().songTask.cancel();
        }
    }

    private void play(Location location, double range) {
        double rangeSquared = range * range;
        for (Player player : location.getWorld().getPlayers()) {
            if (player.getLocation().distanceSquared(location) > rangeSquared) continue;
            CustomMusic currentCustomMusic = playerSongSingleton.get(player);
            if (currentCustomMusic != null && !currentCustomMusic.equals(this)) {
                currentCustomMusic.songTask.cancel();
                player.stopSound(currentCustomMusic.name);
                if (currentCustomMusic.name2 != null) {
                    try {
                        player.stopSound(currentCustomMusic.name2);
                    }
                    catch (Exception e) {
                        Logger.warn("Error trying to stop song, key was " + this.name2 + " . Reporting this to the author would be appreciated. This does not break anything.");
                    }
                }
                playerSongSingleton.remove(player);
            }
            if (this.players.containsKey(player)) continue;
            player.playSound(player.getLocation(), this.name, SoundCategory.MUSIC, 1.0f, 1.0f);
            this.startLoopingTask(player, this.durationTicks);
        }
    }

    private void play(Player player) {
        this.startLoopingTask(player, this.durationTicks);
        this.players.put(player, this);
        if (playerSongSingleton.containsKey(player) && !this.players.get(player).equals(this)) {
            return;
        }
        player.playSound(player.getLocation(), this.name, SoundCategory.MUSIC, 1.0f, 1.0f);
        playerSongSingleton.put(player, this);
    }

    private void startLoopingTask(final Player player, int durationTicks) {
        final CustomMusic customMusic = this;
        if (this.name2 == null) {
            this.songTask = new BukkitRunnable(){

                public void run() {
                    if (CustomMusic.this.contentType == ContentType.BOSS && !CustomMusic.this.customBossEntity.exists() || CustomMusic.this.contentType == ContentType.BOSS && player.getLocation().distanceSquared(CustomMusic.this.customBossEntity.getLivingEntity().getLocation()) > Math.pow(CustomMusic.this.customBossEntity.getFollowDistance() * 1.5, 2.0) || CustomMusic.this.contentType == ContentType.DUNGEON && !player.getWorld().equals(CustomMusic.this.world)) {
                        this.cancel();
                        CustomMusic.this.players.remove(player);
                        playerSongSingleton.remove(player);
                        return;
                    }
                    if (playerSongSingleton.containsKey(player) && !CustomMusic.this.players.get(player).equals(customMusic)) {
                        return;
                    }
                    if (!playerSongSingleton.containsKey(player)) {
                        playerSongSingleton.put(player, customMusic);
                    }
                    player.playSound(player.getLocation(), CustomMusic.this.name, SoundCategory.MUSIC, 1.0f, 1.0f);
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, (long)durationTicks);
        } else {
            player.playSound(player.getLocation(), this.name, SoundCategory.MUSIC, 1.0f, 1.0f);
            this.songTask = new BukkitRunnable(){

                public void run() {
                    if (CustomMusic.this.contentType == ContentType.BOSS && !CustomMusic.this.customBossEntity.exists() || CustomMusic.this.contentType == ContentType.BOSS && player.getLocation().distanceSquared(CustomMusic.this.customBossEntity.getLivingEntity().getLocation()) > Math.pow(CustomMusic.this.customBossEntity.getFollowDistance() * 1.5, 2.0) || CustomMusic.this.contentType == ContentType.DUNGEON && !player.getWorld().equals(CustomMusic.this.world)) {
                        this.cancel();
                        CustomMusic.this.players.remove(player);
                        playerSongSingleton.remove(player);
                        return;
                    }
                    player.playSound(player.getLocation(), CustomMusic.this.name2, SoundCategory.MUSIC, 1.0f, 1.0f);
                }
            }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, (long)durationTicks, (long)this.durationTicks2);
        }
        this.players.put(player, this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getDurationTicks() {
        return this.durationTicks;
    }

    @Generated
    public String getName2() {
        return this.name2;
    }

    @Generated
    public int getDurationTicks2() {
        return this.durationTicks2;
    }

    private static enum ContentType {
        BOSS,
        DUNGEON;

    }

    public static class CustomMusicEvents
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onTeleport(final PlayerTeleportEvent event) {
            EliteMobsWorld eliteMobsWorld = EliteMobsWorld.getEliteMobsWorld(event.getDestination().getWorld().getUID());
            if (eliteMobsWorld == null || eliteMobsWorld.getContentPackagesConfigFields().getSong() == null) {
                return;
            }
            final CustomMusic customMusic = dungeonMusic.get(event.getDestination().getWorld());
            if (customMusic == null) {
                Logger.warn("aFailed to get custom music for " + event.getDestination().getWorld().getName());
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    customMusic.play(event.getPlayer());
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 20L);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onLogin(final PlayerJoinEvent event) {
            EliteMobsWorld eliteMobsWorld = EliteMobsWorld.getEliteMobsWorld(event.getPlayer().getWorld().getUID());
            if (eliteMobsWorld == null || eliteMobsWorld.getContentPackagesConfigFields().getSong() == null) {
                return;
            }
            final CustomMusic customMusic = dungeonMusic.get(event.getPlayer().getWorld());
            if (customMusic == null) {
                Logger.warn("Failed to get custom music for " + event.getPlayer().getWorld().getName());
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    customMusic.play(event.getPlayer());
                }
            }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 20L);
        }
    }
}

