/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.database;

import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.Logger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;

public class GenerateDatabase {
    private GenerateDatabase() {
    }

    public static void generate() throws Exception {
        Statement statement = PlayerData.getConnection().createStatement();
        String sql = "CREATE TABLE IF NOT EXISTS " + PlayerData.getPLAYER_DATA_TABLE_NAME() + " (PlayerUUID VARCHAR(36) PRIMARY KEY NOT NULL, DisplayName TEXT, Currency DOUBLE, GuildPrestigeLevel INT, GuildMaxLevel INT, GuildActiveLevel INT, QuestStatus BLOB, Score INT, Kills INT, HighestLevelKilled INT, Deaths INT, QuestsCompleted INT, PlayerQuestCooldowns BLOB, BackTeleportLocation TEXT, UseBookMenus TINYINT(1), DismissEMStatusScreenMessage TINYINT(1));";
        statement.executeUpdate(sql);
        statement.close();
        GenerateDatabase.addEntryIfEmpty("DisplayName", ColumnValues.TEXT);
        GenerateDatabase.addEntryIfEmpty("Currency", ColumnValues.REAL);
        GenerateDatabase.addEntryIfEmpty("GuildPrestigeLevel", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("GuildMaxLevel", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("GuildActiveLevel", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("QuestStatus", ColumnValues.BLOB);
        GenerateDatabase.addEntryIfEmpty("Score", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("Kills", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("HighestLevelKilled", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("Deaths", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("QuestsCompleted", ColumnValues.INT);
        GenerateDatabase.addEntryIfEmpty("PlayerQuestCooldowns", ColumnValues.BLOB);
        GenerateDatabase.addEntryIfEmpty("BackTeleportLocation", ColumnValues.TEXT);
        GenerateDatabase.addEntryIfEmpty("UseBookMenus", ColumnValues.BOOLEAN);
        GenerateDatabase.addEntryIfEmpty("DismissEMStatusScreenMessage", ColumnValues.BOOLEAN);
    }

    private static void addEntryIfEmpty(String columnName, ColumnValues columnValues) {
        try {
            DatabaseMetaData metaData = PlayerData.getConnection().getMetaData();
            ResultSet resultSet = metaData.getColumns(null, null, PlayerData.getPLAYER_DATA_TABLE_NAME(), columnName);
            if (!resultSet.next()) {
                Logger.info("Adding new database column " + columnName);
                GenerateDatabase.addColumn(columnName, columnValues);
            }
            resultSet.close();
        }
        catch (Exception ex) {
            Logger.warn("Could not process column " + columnName);
            ex.printStackTrace();
        }
    }

    private static void addColumn(String columnName, ColumnValues type) {
        try {
            Statement statement = PlayerData.getConnection().createStatement();
            String sql = "ALTER TABLE " + PlayerData.getPLAYER_DATA_TABLE_NAME() + " ADD " + columnName + " " + type.toString();
            statement.executeUpdate(sql);
            statement.close();
        }
        catch (Exception ex) {
            Logger.warn("Failed to insert new column " + columnName);
            ex.printStackTrace();
        }
    }

    private static enum ColumnValues {
        BLOB,
        INT,
        TEXT,
        REAL,
        BOOLEAN;

    }
}

