/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.playerdata.database;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.playerdata.database.PlayerData;
import com.magmaguy.magmacore.util.Logger;
import java.io.File;
import java.sql.Statement;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class PortOldData {
    public PortOldData() {
        File playerCache = new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + "/data/playerCache.yml");
        File playerGuildRank = new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + "/data/playerGuildRank.yml");
        File playerMaxGuildRank = new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + "/data/playerMaxGuildRank.yml");
        File playerMoneyData = new File(MetadataHandler.PLUGIN.getDataFolder().getPath() + "/data/playerMoneyData.yml");
        if (!(playerCache.isFile() || playerGuildRank.isFile() || playerMaxGuildRank.isFile() || playerMoneyData.isFile())) {
            return;
        }
        YamlConfiguration playerCacheConfig = null;
        YamlConfiguration playerGuildRankConfig = null;
        YamlConfiguration playerMaxGuildRankConfig = null;
        YamlConfiguration playerMoneyDataConfig = null;
        HashSet<UUID> uuids = new HashSet<UUID>();
        if (playerCache.exists()) {
            playerCacheConfig = YamlConfiguration.loadConfiguration((File)playerCache);
            for (String string : playerCacheConfig.getKeys(false)) {
                uuids.add(UUID.fromString(string));
            }
        }
        if (playerGuildRank.exists()) {
            playerGuildRankConfig = YamlConfiguration.loadConfiguration((File)playerGuildRank);
            for (String string : playerGuildRankConfig.getKeys(false)) {
                uuids.add(UUID.fromString(string));
            }
        }
        if (playerMaxGuildRank.exists()) {
            playerMaxGuildRankConfig = YamlConfiguration.loadConfiguration((File)playerMaxGuildRank);
            for (String string : playerMaxGuildRankConfig.getKeys(false)) {
                uuids.add(UUID.fromString(string));
            }
        }
        if (playerMoneyData.exists()) {
            playerMoneyDataConfig = YamlConfiguration.loadConfiguration((File)playerMoneyData);
            for (String string : playerMoneyDataConfig.getKeys(false)) {
                uuids.add(UUID.fromString(string));
            }
        }
        if (uuids.isEmpty()) {
            this.deleteConfigs(playerCache, playerGuildRank, playerMaxGuildRank, playerMoneyData);
            return;
        }
        boolean errored = false;
        for (UUID uuid : uuids) {
            boolean wasOldMaxRank = false;
            String displayName = null;
            if (playerCacheConfig != null && playerCacheConfig.contains(uuid.toString())) {
                displayName = playerCacheConfig.getString(uuid.toString());
            }
            if (displayName == null) {
                displayName = "PlaceholderName";
            }
            Integer playerActiveGuildRank = null;
            if (playerGuildRankConfig != null && playerGuildRankConfig.contains(uuid.toString())) {
                playerActiveGuildRank = playerGuildRankConfig.getInt(uuid.toString());
            }
            if (playerActiveGuildRank == null) {
                playerActiveGuildRank = 1;
            }
            Integer playerMaxGuildRankValue = null;
            if (playerMaxGuildRankConfig != null && playerMaxGuildRankConfig.contains(uuid.toString())) {
                playerMaxGuildRankValue = playerMaxGuildRankConfig.getInt(uuid.toString());
            }
            if (playerMaxGuildRankValue == null) {
                playerMaxGuildRankValue = 1;
            }
            if (playerMaxGuildRankValue == 11) {
                playerActiveGuildRank = 10;
                playerMaxGuildRankValue = 10;
                wasOldMaxRank = true;
            }
            Double currency = null;
            if (playerMoneyDataConfig != null && playerMoneyDataConfig.contains(uuid.toString())) {
                currency = playerMoneyDataConfig.getDouble(uuid.toString());
            }
            if (currency == null) {
                currency = 0.0;
            }
            if (wasOldMaxRank) {
                currency = currency + 30000.0;
            }
            try {
                Statement statement = null;
                statement = PlayerData.getConnection().createStatement();
                String sql = "INSERT INTO " + PlayerData.getPLAYER_DATA_TABLE_NAME() + " (PlayerUUID, DisplayName, Currency, GuildPrestigeLevel, GuildMaxLevel, GuildActiveLevel) VALUES ('" + uuid.toString() + "', '" + displayName + "', " + currency + ", 0, " + playerMaxGuildRankValue + ", " + playerActiveGuildRank + ");";
                statement.executeUpdate(sql);
                statement.close();
                PlayerData.getConnection().commit();
                PlayerData.getConnection().close();
            }
            catch (Exception e) {
                Logger.warn("Warning: Failed to write values from old config files to new database system. Tell the dev!");
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
                errored = true;
            }
        }
        if (!errored) {
            this.deleteConfigs(playerCache, playerGuildRank, playerMaxGuildRank, playerMoneyData);
        }
    }

    private void deleteConfigs(File playerCache, File playerGuildRank, File playerMaxGuildRank, File playerMoneyData) {
        this.deleteConfig(playerCache);
        this.deleteConfig(playerGuildRank);
        this.deleteConfig(playerMaxGuildRank);
        this.deleteConfig(playerMoneyData);
    }

    private void deleteConfig(File file) {
        try {
            if (file.exists() && file.isFile()) {
                file.delete();
                Logger.warn("Deleted data file " + file.getName() + " - was no longer in use, moved to SQLite");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

