/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.config.powers.PowersConfigFields;
import com.magmaguy.elitemobs.explosionregen.Explosion;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.CombatEnterScanPower;
import com.magmaguy.elitemobs.utils.EnderDragonPhaseSimplifier;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EnderDragonTornado
extends CombatEnterScanPower {
    private Location tornadoEye = null;
    private Vector tornadoSpeed = null;

    public EnderDragonTornado() {
        super(PowersConfig.getPower("ender_dragon_tornado.yml"));
    }

    @Override
    protected void finishActivation(final EliteEntity eliteEntity) {
        this.bukkitTask = new BukkitRunnable(){

            public void run() {
                EnderDragon.Phase phase;
                if (EnderDragonTornado.this.doExit(eliteEntity) || EnderDragonTornado.this.isInCooldown(eliteEntity)) {
                    return;
                }
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && !EnderDragonPhaseSimplifier.isLanded(phase = ((EnderDragon)eliteEntity.getLivingEntity()).getPhase())) {
                    return;
                }
                EnderDragonTornado.this.doPower(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 10L);
    }

    private void doPower(final EliteEntity eliteEntity) {
        this.doCooldown(eliteEntity);
        this.tornadoEye = eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(6, -6, 0)).toVector().rotateAroundY(ThreadLocalRandom.current().nextDouble(0.0, Math.PI * 2)).toLocation(eliteEntity.getLivingEntity().getWorld());
        this.tornadoSpeed = this.tornadoEye.clone().subtract(eliteEntity.getLivingEntity().getLocation()).toVector().setY(0).normalize().multiply(0.2);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON)) {
                    ((EnderDragon)eliteEntity.getLivingEntity()).setPhase(EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET);
                }
                if (EnderDragonTornado.this.doExit(eliteEntity) || eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && !EnderDragonPhaseSimplifier.isLanded(((EnderDragon)eliteEntity.getLivingEntity()).getPhase())) {
                    this.cancel();
                    return;
                }
                EnderDragonTornado.this.tornadoEye.add(EnderDragonTornado.this.tornadoSpeed);
                if (this.counter % 2 == 0) {
                    EnderDragonTornado.this.doTornadoParticles();
                    EnderDragonTornado.this.doTerrainDestruction(eliteEntity);
                    EnderDragonTornado.this.doEntityDisplacement(eliteEntity.getLivingEntity());
                }
                if (this.counter > 120) {
                    this.cancel();
                }
                ++this.counter;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doTornadoParticles() {
        for (int i = 0; i < 21; ++i) {
            for (int x = 0; x < (i ^ 3); ++x) {
                Location randomParticleLocation = this.tornadoEye.clone().add(new Vector(i / 2, i, 0).rotateAroundY(ThreadLocalRandom.current().nextDouble(Math.PI * 2)));
                randomParticleLocation.setDirection(randomParticleLocation.toVector().rotateAroundY(1.5707963267948966));
                if (ThreadLocalRandom.current().nextDouble() < 0.7) {
                    this.tornadoEye.getWorld().spawnParticle(Particle.LARGE_SMOKE, randomParticleLocation, 1, 0.0, 0.0, 0.0, 0.05);
                    continue;
                }
                this.tornadoEye.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, randomParticleLocation, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private void doTerrainDestruction(EliteEntity eliteEntity) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (int i = 0; i < 5; ++i) {
            Location location = this.tornadoEye.clone().add(new Vector(ThreadLocalRandom.current().nextInt(-5, 5), 0, ThreadLocalRandom.current().nextInt(-5, 5)));
            Block block = location.getWorld().getHighestBlockAt(location);
            if (block.getType().getBlastResistance() > 7.0f || block.getLocation().getY() == -1.0) continue;
            blockList.add(block);
        }
        Explosion.generateFakeExplosion(blockList, (Entity)eliteEntity.getLivingEntity(), (PowersConfigFields)this.getPowersConfigFields(), this.tornadoEye.clone());
    }

    private void doEntityDisplacement(LivingEntity sourceEntity) {
        for (Entity entity : this.tornadoEye.getWorld().getNearbyEntities(this.tornadoEye, 7.0, 21.0, 7.0)) {
            if (!(entity instanceof LivingEntity) || entity.equals(sourceEntity)) continue;
            Vector vector = entity.getLocation().clone().subtract(this.tornadoEye).toVector().rotateAroundY(1.5707963267948966).toLocation(entity.getWorld()).subtract(entity.getLocation().clone().subtract(this.tornadoEye).toVector()).toVector().normalize().multiply(0.5);
            vector.setY(0.5);
            entity.setVelocity(entity.getVelocity().add(vector));
        }
    }

    @Override
    protected void finishDeactivation(EliteEntity eliteEntity) {
    }
}

