/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.ProjectileDamage;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.magmacore.util.ItemStackGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GoldShotgun
extends BossPower
implements Listener {
    public GoldShotgun() {
        super(PowersConfig.getPower("gold_shotgun.yml"));
    }

    @EventHandler
    public void onHit(EliteMobDamagedByPlayerEvent event) {
        GoldShotgun goldShotgun = (GoldShotgun)event.getEliteMobEntity().getPower(this);
        if (goldShotgun == null) {
            return;
        }
        if (!GoldShotgun.eventIsValid(event, (ElitePower)goldShotgun)) {
            return;
        }
        goldShotgun.doCooldownTicks(event.getEliteMobEntity());
        goldShotgun.doGoldShotgun(event.getEliteMobEntity(), event.getPlayer());
    }

    private void doGoldShotgun(final EliteEntity eliteEntity, Player player) {
        eliteEntity.getLivingEntity().setAI(false);
        final Vector shotVector = player.getLocation().add(new Vector(0, 1, 0)).toVector().subtract(eliteEntity.getLivingEntity().getLocation().toVector()).normalize().multiply(0.5);
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (this.counter % 10 == 0) {
                    GoldShotgun.this.doSmokeEffect(eliteEntity, shotVector);
                }
                ++this.counter;
                if (this.counter < 60) {
                    return;
                }
                this.cancel();
                eliteEntity.getLivingEntity().setAI(true);
                List<Item> nuggetList = GoldShotgun.this.generateVisualItems(eliteEntity, shotVector);
                if (nuggetList == null) {
                    return;
                }
                ProjectileDamage.doGoldNuggetDamage(nuggetList, eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void doSmokeEffect(EliteEntity eliteEntity, Vector shotVector) {
        for (int i = 0; i < 200; ++i) {
            Vector visualShotVector = this.getShotVector(shotVector);
            eliteEntity.getLivingEntity().getWorld().spawnParticle(Particle.SMOKE, eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0.0, 0.5, 0.0)), 0, visualShotVector.getX(), visualShotVector.getY(), visualShotVector.getZ(), 0.75);
        }
    }

    private List<Item> generateVisualItems(EliteEntity eliteEntity, Vector shotVector) {
        ArrayList<Item> nuggetList = new ArrayList<Item>();
        for (int i = 0; i < 200; ++i) {
            Item visualProjectile = eliteEntity.getLivingEntity().getWorld().dropItem(eliteEntity.getLivingEntity().getLocation(), ItemStackGenerator.generateItemStack(Material.GOLD_NUGGET, "visual projectile", List.of("" + ThreadLocalRandom.current().nextDouble())));
            ProjectileDamage.configureVisualProjectile(visualProjectile);
            visualProjectile.setVelocity(this.getShotVector(shotVector));
            visualProjectile.setGravity(false);
            nuggetList.add(visualProjectile);
        }
        return nuggetList;
    }

    private Vector getShotVector(Vector originalShotVector) {
        return originalShotVector.clone().add(new Vector(ThreadLocalRandom.current().nextDouble(-0.1, 0.1), ThreadLocalRandom.current().nextDouble(-0.1, 0.1), ThreadLocalRandom.current().nextDouble(-0.1, 0.1)).normalize().multiply(0.1));
    }
}

