/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.collateralminecraftchanges.LightningSpawnBypass;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class LightningBolts
extends BossPower
implements Listener {
    public LightningBolts() {
        super(PowersConfig.getPower("lightning_bolts.yml"));
    }

    private static void setLightiningPaths(final EliteEntity eliteEntity) {
        if (eliteEntity.getLivingEntity() == null) {
            return;
        }
        eliteEntity.getLivingEntity().setAI(false);
        for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(20.0, 20.0, 20.0)) {
            if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
            Location playerLocationClone = entity.getLocation().clone();
            Location powerLocation = eliteEntity.getLivingEntity().getLocation().clone();
            Vector powerDirection = playerLocationClone.clone().subtract(powerLocation).toVector().normalize();
            int counter = 0;
            while (playerLocationClone.distance(powerLocation) > 0.55) {
                powerLocation.add(powerDirection);
                LightningBolts.lightningTask(powerLocation.clone(), ++counter);
            }
        }
        new BukkitRunnable(){

            public void run() {
                if (eliteEntity != null && eliteEntity.getLivingEntity() != null) {
                    eliteEntity.getLivingEntity().setAI(true);
                }
            }
        }.runTaskLater((Plugin)MetadataHandler.PLUGIN, 80L);
    }

    public static void lightningTask(final Location location, int counter) {
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                if (this.counter > 40) {
                    LightningSpawnBypass.bypass();
                    location.getWorld().strikeLightning(location);
                    this.cancel();
                    return;
                }
                location.getWorld().spawnParticle(Particle.CRIT, location, 10, 0.5, 1.5, 0.5, 0.3);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, (long)counter * 5L, 1L);
    }

    @EventHandler
    public void onDamagedEvent(EliteMobDamagedByPlayerEvent event) {
        LightningBolts lightningBolts = (LightningBolts)event.getEliteMobEntity().getPower(this);
        if (lightningBolts == null) {
            return;
        }
        if (lightningBolts.isInCooldown(event.getEliteMobEntity())) {
            return;
        }
        lightningBolts.doCooldownTicks(event.getEliteMobEntity());
        lightningBolts.setFiring(true);
        LightningBolts.setLightiningPaths(event.getEliteMobEntity());
    }
}

