/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.BossPower;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MeteorShower
extends BossPower
implements Listener {
    public MeteorShower() {
        super(PowersConfig.getPower("meteor_shower.yml"));
    }

    public static void doMeteorShower(final EliteEntity eliteEntity) {
        eliteEntity.getLivingEntity().setAI(false);
        new BukkitRunnable(){
            final Location initialLocation;
            int counter;
            {
                this.initialLocation = eliteEntity.getLivingEntity().getLocation().clone();
                this.counter = 0;
            }

            public void run() {
                if (!eliteEntity.isValid()) {
                    this.cancel();
                    return;
                }
                if (this.counter > 200) {
                    this.cancel();
                    eliteEntity.getLivingEntity().setAI(true);
                    eliteEntity.getLivingEntity().teleport(this.initialLocation);
                    return;
                }
                ++this.counter;
                MeteorShower.doCloudEffect(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)));
                if (this.counter > 40) {
                    MeteorShower.doFireballs(eliteEntity.getLivingEntity().getLocation().clone().add(new Vector(0, 10, 0)), eliteEntity);
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    public static void doCloudEffect(Location location) {
        for (int i = 0; i < 1; ++i) {
            int randX = ThreadLocalRandom.current().nextInt(30) - 15;
            int randY = ThreadLocalRandom.current().nextInt(2);
            int randZ = ThreadLocalRandom.current().nextInt(30) - 15;
            Location newLocation = location.clone().add(new Vector(randX, randY, randZ));
            location.getWorld().spawnParticle(Particle.EXPLOSION, newLocation, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void doFireballs(Location location, EliteEntity eliteEntity) {
        for (int i = 0; i < 1; ++i) {
            int randX = ThreadLocalRandom.current().nextInt(30) - 15;
            int randY = ThreadLocalRandom.current().nextInt(2);
            int randZ = ThreadLocalRandom.current().nextInt(30) - 15;
            Location newLocation = location.clone().add(new Vector(randX, randY, randZ));
            newLocation = newLocation.setDirection(new Vector(ThreadLocalRandom.current().nextDouble() - 0.5, -0.5, ThreadLocalRandom.current().nextDouble() - 0.5));
            Fireball fireball = (Fireball)location.getWorld().spawnEntity(newLocation, EntityType.FIREBALL);
            fireball.setShooter((ProjectileSource)eliteEntity.getLivingEntity());
            fireball.setDirection(fireball.getDirection().multiply(0.5));
        }
    }

    @EventHandler
    public void onDamage(EliteMobDamagedByPlayerEvent event) {
        MeteorShower meteorShower = (MeteorShower)event.getEliteMobEntity().getPower(this);
        if (meteorShower == null) {
            return;
        }
        if (!MeteorShower.eventIsValid(event, (ElitePower)meteorShower)) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.25) {
            return;
        }
        meteorShower.doGlobalCooldown(400, event.getEliteMobEntity());
        MeteorShower.doMeteorShower(event.getEliteMobEntity());
    }
}

