/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobDamagedByPlayerEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfig;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import com.magmaguy.elitemobs.powerstances.GenericRotationMatrixMath;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkeletonPillar
extends MajorPower
implements Listener {
    private Location soundLocation;

    public SkeletonPillar() {
        super(PowersConfig.getPower("skeleton_pillar.yml"));
    }

    @EventHandler
    public void onHit(final EliteMobDamagedByPlayerEvent event) {
        SkeletonPillar skeletonPillar = (SkeletonPillar)event.getEliteMobEntity().getPower(this);
        if (skeletonPillar == null) {
            return;
        }
        if (skeletonPillar.isInGlobalCooldown()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > 0.2) {
            return;
        }
        skeletonPillar.doGlobalCooldown(540);
        event.getEliteMobEntity().getLivingEntity().setAI(false);
        this.playPillarSong(event.getEntity().getLocation());
        final Location location1 = event.getEliteMobEntity().getLivingEntity().getLocation().clone().add(this.locationMover(event.getEliteMobEntity().getLivingEntity().getLocation().clone(), 20, 7));
        final Location location2 = event.getEliteMobEntity().getLivingEntity().getLocation().clone().add(this.locationMover(event.getEliteMobEntity().getLivingEntity().getLocation().clone(), 20, -7));
        new BukkitRunnable(){
            int timer = 1;

            public void run() {
                if (this.timer > 140 || !event.getEliteMobEntity().isValid()) {
                    if (event.getEliteMobEntity().getLivingEntity() != null) {
                        event.getEliteMobEntity().getLivingEntity().setAI(true);
                    }
                    this.cancel();
                } else if (this.timer > 20 && this.timer < 140) {
                    SkeletonPillar.this.pillarEffect(event.getEliteMobEntity().getLivingEntity().getLocation().clone(), this.timer, 7);
                    SkeletonPillar.this.pillarEffect(event.getEliteMobEntity().getLivingEntity().getLocation().clone(), this.timer, -7);
                } else {
                    SkeletonPillar.this.pillarWarningEffect(location1);
                    SkeletonPillar.this.pillarWarningEffect(location2);
                }
                ++this.timer;
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    private void pillarEffect(Location location, int timer, int offset) {
        location.add(this.locationMover(location, timer, offset));
        location.getWorld().spawnParticle(Particle.EXPLOSION, location, 15, 0.1, 5.0, 0.1, 0.05);
        this.pillarDamage(location);
    }

    private void pillarWarningEffect(Location location) {
        location.getWorld().spawnParticle(Particle.LARGE_SMOKE, location, 5, 0.1, 5.0, 0.1, 0.05);
    }

    private void pillarDamage(Location location) {
        for (Entity entity : location.getWorld().getNearbyEntities(location, 2.0, 5.0, 2.0)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof Pig || entity instanceof Cow || entity instanceof Chicken || entity instanceof Wolf || entity instanceof Llama || entity instanceof Ocelot || entity instanceof Horse || entity instanceof Sheep || entity instanceof Rabbit || entity instanceof Parrot || entity instanceof Villager || !livingEntity.isValid()) continue;
            livingEntity.damage(1.0);
        }
    }

    private Location locationMover(Location location, int timer, int offset) {
        int numberOfPointsPerRotation = 60;
        Location newLocation = GenericRotationMatrixMath.applyRotation(0.0, 1.0, 0.0, numberOfPointsPerRotation, 0.0, 0.0, offset, timer).toLocation(location.getWorld());
        return newLocation;
    }

    private void playPillarSong(Location location) {
        this.soundLocation = location;
        new BukkitRunnable(){
            int counter = 0;

            public void run() {
                ++this.counter;
                switch (this.counter) {
                    case 1: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.d());
                        break;
                    }
                    case 2: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.d());
                        break;
                    }
                    case 4: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.eHigher());
                        break;
                    }
                    case 7: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aHigher());
                        break;
                    }
                    case 10: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aSharpHigher());
                        break;
                    }
                    case 12: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 14: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 16: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 17: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.d());
                        break;
                    }
                    case 18: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 19: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 21: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.c());
                        break;
                    }
                    case 22: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.c());
                        break;
                    }
                    case 24: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.eHigher());
                        break;
                    }
                    case 27: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aHigher());
                        break;
                    }
                    case 30: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aSharpHigher());
                        break;
                    }
                    case 32: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 34: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 36: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 37: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.d());
                        break;
                    }
                    case 38: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 39: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 41: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.b());
                        break;
                    }
                    case 42: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.b());
                        break;
                    }
                    case 44: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.eHigher());
                        break;
                    }
                    case 47: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aHigher());
                        break;
                    }
                    case 50: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aSharpHigher());
                        break;
                    }
                    case 52: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 54: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 56: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 57: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.d());
                        break;
                    }
                    case 58: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 59: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 61: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aSharp());
                        break;
                    }
                    case 62: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aSharp());
                        break;
                    }
                    case 64: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.eHigher());
                        break;
                    }
                    case 67: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aHigher());
                        break;
                    }
                    case 70: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.aSharpHigher());
                        break;
                    }
                    case 72: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 74: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 76: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 77: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.d());
                        break;
                    }
                    case 78: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.f());
                        break;
                    }
                    case 79: {
                        SkeletonPillar.this.playSound(SkeletonPillar.this.gHigher());
                        break;
                    }
                    case 80: {
                        this.cancel();
                        break;
                    }
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 1L, 2L);
    }

    private void playSound(float pitch) {
        this.soundLocation.getWorld().playSound(this.soundLocation, Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE, 2.0f, pitch);
    }

    private float d() {
        return 0.793701f;
    }

    private float eHigher() {
        return 1.781797f;
    }

    private float aHigher() {
        return 1.189207f;
    }

    private float aSharpHigher() {
        return 1.259921f;
    }

    private float gHigher() {
        return 1.122462f;
    }

    private float f() {
        return 0.943874f;
    }

    private float c() {
        return 0.707107f;
    }

    private float b() {
        return 0.66742f;
    }

    private float aSharp() {
        return 0.629961f;
    }
}

