/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.meta;

import com.magmaguy.elitemobs.MetadataHandler;
import com.magmaguy.elitemobs.api.EliteMobEnterCombatEvent;
import com.magmaguy.elitemobs.api.EliteMobExitCombatEvent;
import com.magmaguy.elitemobs.config.powers.PowersConfigFields;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import com.magmaguy.elitemobs.utils.EnderDragonPhaseSimplifier;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class Bombardment
extends MajorPower
implements Listener {
    public static ArrayList<String> bombardments = new ArrayList();
    public int firingTimer = 0;
    private boolean isActive = false;
    private boolean firing = false;
    private BukkitTask task = null;

    public Bombardment(PowersConfigFields powersConfigFields) {
        super(powersConfigFields);
        bombardments.add(powersConfigFields.getFilename());
    }

    public void activate(final EliteEntity eliteEntity) {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.task = new BukkitRunnable(){
            int counter = 0;

            public void run() {
                EnderDragon.Phase phase;
                ++this.counter;
                if (Bombardment.this.stopCondition(eliteEntity)) {
                    return;
                }
                if (Bombardment.this.firing || Bombardment.this.isInCooldown(eliteEntity)) {
                    return;
                }
                if (ThreadLocalRandom.current().nextDouble() > 0.1) {
                    return;
                }
                if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON) && ((phase = ((EnderDragon)eliteEntity.getLivingEntity()).getPhase()).equals((Object)EnderDragon.Phase.DYING) || phase.equals((Object)EnderDragon.Phase.HOVER) || phase.equals((Object)EnderDragon.Phase.ROAR_BEFORE_ATTACK) || phase.equals((Object)EnderDragon.Phase.FLY_TO_PORTAL) || phase.equals((Object)EnderDragon.Phase.SEARCH_FOR_BREATH_ATTACK_TARGET))) {
                    return;
                }
                for (Entity entity : eliteEntity.getLivingEntity().getNearbyEntities(10.0, 100.0, 10.0)) {
                    if (!entity.getType().equals((Object)EntityType.PLAYER)) continue;
                    Bombardment.this.firing = true;
                    Bombardment.this.fire(eliteEntity);
                    return;
                }
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 5L);
    }

    public void deactivate() {
        this.firing = false;
        this.isActive = false;
        if (this.task != null) {
            this.task.cancel();
        }
    }

    private boolean stopCondition(EliteEntity eliteEntity) {
        if (eliteEntity == null || eliteEntity.getLivingEntity() == null || !eliteEntity.isValid() || !eliteEntity.isInCombat()) {
            this.deactivate();
            return true;
        }
        if (eliteEntity.getLivingEntity().getType().equals((Object)EntityType.ENDER_DRAGON)) {
            return !EnderDragonPhaseSimplifier.isFlying(((EnderDragon)eliteEntity.getLivingEntity()).getPhase(), false);
        }
        return false;
    }

    private void fire(final EliteEntity eliteEntity) {
        this.doCooldown(eliteEntity);
        this.isActive = true;
        this.firingTimer = 0;
        new BukkitRunnable(){

            public void run() {
                ++Bombardment.this.firingTimer;
                if (Bombardment.this.stopCondition(eliteEntity) || Bombardment.this.firingTimer > 100) {
                    this.cancel();
                    Bombardment.this.firing = false;
                    return;
                }
                Bombardment.this.taskBehavior(eliteEntity);
            }
        }.runTaskTimer((Plugin)MetadataHandler.PLUGIN, 0L, 1L);
    }

    public abstract void taskBehavior(EliteEntity var1);

    public static class BombardmentEvents
    implements Listener {
        @EventHandler
        public void onCombatEnter(EliteMobEnterCombatEvent event) {
            for (String bombardmentPower : bombardments) {
                Bombardment bombardment = (Bombardment)event.getEliteMobEntity().getPower(bombardmentPower);
                if (bombardment == null) continue;
                bombardment.activate(event.getEliteMobEntity());
            }
        }

        @EventHandler
        public void onCombatLeave(EliteMobExitCombatEvent event) {
            for (String bombardmentPower : bombardments) {
                Bombardment bombardment = (Bombardment)event.getEliteMobEntity().getPower(bombardmentPower);
                if (bombardment == null) continue;
                bombardment.deactivate();
            }
        }
    }
}

