/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powers.scripts;

import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.playerdata.ElitePlayerInventory;
import com.magmaguy.elitemobs.powers.scripts.EliteScript;
import com.magmaguy.elitemobs.powers.scripts.ScriptActionData;
import com.magmaguy.elitemobs.powers.scripts.ScriptTargets;
import com.magmaguy.elitemobs.powers.scripts.caching.ScriptConditionsBlueprint;
import com.magmaguy.elitemobs.powers.scripts.enums.ConditionType;
import com.magmaguy.elitemobs.powers.scripts.enums.TargetType;
import com.magmaguy.magmacore.util.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ScriptConditions {
    private final ScriptConditionsBlueprint conditionsBlueprint;
    private final EliteScript eliteScript;
    private final ScriptTargets scriptTargets;

    public ScriptConditions(ScriptConditionsBlueprint scriptConditionsBlueprint, EliteScript eliteScript, boolean actionCondition) {
        this.conditionsBlueprint = scriptConditionsBlueprint;
        this.eliteScript = eliteScript;
        this.scriptTargets = this.conditionsBlueprint.getScriptTargets() != null ? new ScriptTargets(this.conditionsBlueprint.getScriptTargets(), eliteScript) : null;
        if (this.conditionsBlueprint.getConditionType() == null) {
            if (actionCondition) {
                this.conditionsBlueprint.setConditionType(ConditionType.FILTERING);
            } else {
                this.conditionsBlueprint.setConditionType(ConditionType.BLOCKING);
            }
        }
    }

    private boolean eval(boolean actual, Boolean expected, Boolean runIf) {
        boolean matches;
        if (expected == null) {
            return true;
        }
        boolean bl = matches = actual == expected;
        return runIf == null ? matches : matches == runIf;
    }

    private boolean isAliveCheck(LivingEntity livingEntity) {
        Boolean expected = this.conditionsBlueprint.getIsAlive();
        if (expected == null) {
            return true;
        }
        if (livingEntity == null) {
            return false;
        }
        boolean actual = livingEntity.isValid();
        return this.eval(actual, expected, this.conditionsBlueprint.getRunIfIsAliveIs());
    }

    private boolean hasTagsCheck(LivingEntity target) {
        List<String> tags = this.conditionsBlueprint.getHasTags();
        if (tags == null) {
            return true;
        }
        boolean actual = this.tagsUninverted(target, tags);
        return this.eval(actual, Boolean.TRUE, this.conditionsBlueprint.getRunIfHasTagIs());
    }

    private boolean doesNotHaveTags(LivingEntity target) {
        List<String> tags = this.conditionsBlueprint.getDoesNotHaveTags();
        if (tags == null) {
            return true;
        }
        boolean actual = this.tagsUninverted(target, tags);
        return this.eval(actual, Boolean.FALSE, this.conditionsBlueprint.getRunIfDoesNotHaveTagIs());
    }

    private boolean tagsUninverted(LivingEntity target, List<String> blueprintTags) {
        ArrayList<String> entityTags = null;
        try {
            if (target instanceof Player) {
                Player player = (Player)target;
                ElitePlayerInventory inv = ElitePlayerInventory.getPlayer(player);
                if (inv != null) {
                    entityTags = new ArrayList<String>(inv.getTags());
                }
            } else {
                EliteEntity mob = EntityTracker.getEliteMobEntity((Entity)target);
                if (mob != null) {
                    entityTags = new ArrayList<String>(mob.getTags());
                }
            }
        }
        catch (Exception e) {
            Logger.warn("Failed to retrieve tags for entity '" + target.getName() + "': " + e.getMessage());
            return false;
        }
        if (entityTags == null) {
            return false;
        }
        return entityTags.containsAll(blueprintTags);
    }

    private boolean targetCountLowerThan(int targetCount) {
        Integer threshold = this.conditionsBlueprint.getTargetCountLowerThan();
        if (threshold == null) {
            return true;
        }
        boolean actual = targetCount < threshold;
        return this.eval(actual, Boolean.TRUE, this.conditionsBlueprint.getRunIfTargetCountLowerThanIs());
    }

    private boolean targetCountGreaterThan(int targetCount) {
        Integer threshold = this.conditionsBlueprint.getTargetCountGreaterThan();
        if (threshold == null) {
            return true;
        }
        boolean actual = targetCount > threshold;
        return this.eval(actual, Boolean.TRUE, this.conditionsBlueprint.getRunIfTargetCountGreaterThanIs());
    }

    private boolean checkRandomizer() {
        Double chance = this.conditionsBlueprint.getRandomChance();
        if (chance == null) {
            return true;
        }
        boolean actual = ThreadLocalRandom.current().nextDouble() < chance;
        return this.eval(actual, Boolean.TRUE, this.conditionsBlueprint.getRunIfRandomChanceIs());
    }

    private boolean isAirCheck(Location targetLocation) {
        Boolean expected = this.conditionsBlueprint.getLocationIsAir();
        if (expected == null) {
            return true;
        }
        try {
            boolean actual = targetLocation.getBlock().getType().isAir();
            return this.eval(actual, expected, this.conditionsBlueprint.getRunIfLocationIsAirIs());
        }
        catch (Exception e) {
            Logger.warn("Failed to check if location is air at '" + targetLocation + "': " + e.getMessage());
            return false;
        }
    }

    private boolean isOnFloor(Location targetLocation) {
        Boolean expected = this.conditionsBlueprint.getIsOnFloor();
        if (expected == null) {
            return true;
        }
        try {
            Block current = targetLocation.getBlock();
            Block below = targetLocation.clone().subtract(0.0, 1.0, 0.0).getBlock();
            boolean actual = !current.getType().isSolid() && below.getType().isSolid();
            return this.eval(actual, expected, this.conditionsBlueprint.getRunIfIsOnFloorIs());
        }
        catch (Exception e) {
            Logger.warn("Failed to check if location is on floor at '" + targetLocation + "': " + e.getMessage());
            return false;
        }
    }

    private boolean isStandingOn(Location targetLocation) {
        Material mat = this.conditionsBlueprint.getIsStandingOnMaterial();
        if (mat == null) {
            return true;
        }
        try {
            boolean actual = targetLocation.clone().subtract(0.0, 1.0, 0.0).getBlock().getType() == mat;
            return this.eval(actual, Boolean.TRUE, this.conditionsBlueprint.getRunIfIsStandingOnMaterialIs());
        }
        catch (Exception e) {
            Logger.warn("Failed to check if location is standing on material at '" + targetLocation + "': " + e.getMessage());
            return false;
        }
    }

    public boolean meetsPreActionConditions(EliteEntity eliteEntity, LivingEntity directTarget) {
        if (this.scriptTargets == null) {
            return true;
        }
        ScriptActionData data = new ScriptActionData(eliteEntity, directTarget, this.scriptTargets, null);
        Collection<LivingEntity> entities = this.scriptTargets.getTargetEntities(data);
        int count = entities.size();
        if (!this.targetCountLowerThan(count) || !this.targetCountGreaterThan(count)) {
            return false;
        }
        for (LivingEntity e : entities) {
            if (this.checkConditions(e)) continue;
            return false;
        }
        for (Location loc : this.scriptTargets.getTargetLocations(data)) {
            if (this.checkConditions(loc)) continue;
            return false;
        }
        return this.checkRandomizer();
    }

    public boolean meetsActionConditions(ScriptActionData data) {
        if (this.scriptTargets == null) {
            return true;
        }
        if (data == null) {
            Logger.warn("ScriptActionData is null in meetsActionConditions.");
            return false;
        }
        if (this.scriptTargets.getTargetBlueprint().getTargetType().equals((Object)TargetType.SELF) && !this.isAliveCheck(data.getEliteEntity().getLivingEntity())) {
            return false;
        }
        if (!this.conditionsBlueprint.getConditionType().equals((Object)ConditionType.BLOCKING)) {
            return true;
        }
        Collection<LivingEntity> entities = this.scriptTargets.getTargetEntities(data);
        int count = entities.size();
        if (!this.targetCountLowerThan(count) || !this.targetCountGreaterThan(count)) {
            return false;
        }
        for (LivingEntity e : entities) {
            if (this.checkConditions(e)) continue;
            return false;
        }
        if (this.scriptTargets.getTargetLocations(data) != null) {
            for (Location loc : this.scriptTargets.getTargetLocations(data)) {
                if (this.checkConditions(loc)) continue;
                return false;
            }
        }
        return this.checkRandomizer();
    }

    private boolean checkConditions(LivingEntity livingEntity) {
        if (this.scriptTargets == null) {
            return true;
        }
        if (livingEntity == null) {
            return false;
        }
        return this.isAliveCheck(livingEntity) && this.hasTagsCheck(livingEntity) && this.checkConditions(livingEntity.getLocation()) && this.doesNotHaveTags(livingEntity);
    }

    private boolean checkConditions(Location location) {
        if (this.scriptTargets == null) {
            return true;
        }
        if (location == null) {
            return true;
        }
        return this.isAirCheck(location) && this.isOnFloor(location) && this.isStandingOn(location);
    }

    protected Collection<Location> validateLocations(ScriptActionData data, @NotNull Collection<Location> original) {
        if (this.scriptTargets == null) {
            return original;
        }
        if (data == null) {
            Logger.warn("ScriptActionData is null in validateLocations.");
            return original;
        }
        Collection<Location> targets = this.scriptTargets.getTargetLocations(data);
        if (this.scriptTargets.getTargetBlueprint().getTargetType().equals((Object)TargetType.ACTION_TARGET)) {
            original.removeIf(loc -> !this.checkConditions((Location)loc));
            return original;
        }
        if (targets == null) {
            return Collections.emptyList();
        }
        for (Location loc2 : targets) {
            if (this.checkConditions(loc2)) continue;
            return Collections.emptyList();
        }
        return original;
    }

    protected Collection<LivingEntity> validateEntities(ScriptActionData data, @NotNull Collection<LivingEntity> original) {
        if (this.scriptTargets == null) {
            return original;
        }
        if (data == null) {
            Logger.warn("ScriptActionData is null in validateEntities.");
            return original;
        }
        if (this.scriptTargets.getTargetBlueprint().getTargetType().equals((Object)TargetType.ACTION_TARGET)) {
            original.removeIf(ent -> !this.checkConditions((LivingEntity)ent));
        } else {
            for (LivingEntity e : this.scriptTargets.getTargetEntities(data)) {
                if (this.checkConditions(e)) continue;
                return new ArrayList<LivingEntity>();
            }
        }
        return original;
    }
}

