/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.powerstances;

import com.magmaguy.elitemobs.config.MobCombatSettingsConfig;
import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.powers.meta.ElitePower;
import com.magmaguy.elitemobs.powers.meta.MajorPower;
import com.magmaguy.elitemobs.powerstances.MajorPowerStanceMath;
import com.magmaguy.elitemobs.powerstances.VisualItemProcessor;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class MajorPowerPowerStance
implements Listener {
    public static int trackAmount = 2;
    public static int individualEffectsPerTrack = 2;
    private EliteEntity eliteEntity;

    public MajorPowerPowerStance(EliteEntity eliteEntity) {
        if (!MobCombatSettingsConfig.isEnableVisualEffectsForNaturalMobs()) {
            return;
        }
        if (MobCombatSettingsConfig.isDisableVisualEffectsForSpawnerMobs() && !eliteEntity.isNaturalEntity()) {
            return;
        }
        this.eliteEntity = eliteEntity;
        if (eliteEntity.isMajorVisualEffect()) {
            return;
        }
        eliteEntity.setMajorVisualEffect(true);
        if (eliteEntity.getMajorPowerCount() < 1) {
            return;
        }
        if (MobCombatSettingsConfig.isObfuscateMobPowers() && eliteEntity.isVisualEffectObfuscated()) {
            Object[][] multiDimensionalTrailTracker = new Object[trackAmount][individualEffectsPerTrack];
            for (int i = 0; i < multiDimensionalTrailTracker.length; ++i) {
                ArrayList<Object> localObjects = new ArrayList<Object>();
                for (int a = 0; a < multiDimensionalTrailTracker.length; ++a) {
                    localObjects.addAll(this.addObfuscatedEffects());
                }
                for (int j = 0; j < multiDimensionalTrailTracker[0].length; ++j) {
                    if (localObjects.get(j) == null) continue;
                    multiDimensionalTrailTracker[i][j] = localObjects.get(j);
                }
            }
            VisualItemProcessor visualItemProcessor = new VisualItemProcessor(multiDimensionalTrailTracker, MajorPowerStanceMath.cachedVectors, eliteEntity.isMajorVisualEffect(), 30, eliteEntity);
            return;
        }
        Object[][] multiDimensionalTrailTracker = new Object[trackAmount][eliteEntity.getMajorPowerCount() * individualEffectsPerTrack];
        for (int i = 0; i < multiDimensionalTrailTracker.length; ++i) {
            ArrayList<Object> localObjects = new ArrayList<Object>();
            for (int a = 0; a < multiDimensionalTrailTracker.length; ++a) {
                localObjects.addAll(this.addAllEffects());
            }
            for (int j = 0; j < multiDimensionalTrailTracker[0].length; ++j) {
                if (localObjects.get(j) == null) continue;
                multiDimensionalTrailTracker[i][j] = localObjects.get(j);
            }
        }
        VisualItemProcessor visualItemProcessor = new VisualItemProcessor(multiDimensionalTrailTracker, MajorPowerStanceMath.cachedVectors, eliteEntity.isMajorVisualEffect(), 30, eliteEntity);
    }

    private ArrayList<Object> addObfuscatedEffects() {
        return new ArrayList<Particle>(List.of(Particle.END_ROD));
    }

    private ArrayList<Object> addAllEffects() {
        ArrayList<Object> effects = new ArrayList<Object>();
        for (ElitePower elitePower : this.eliteEntity.getElitePowers()) {
            if (!(elitePower instanceof MajorPower) || this.eliteEntity.getPower(elitePower).getTrail() == null) continue;
            effects.add(this.effectParser(this.eliteEntity.getPower(elitePower).getTrail()));
        }
        return effects;
    }

    private Object effectParser(String powerString) {
        try {
            Material material = Material.valueOf((String)powerString);
            return this.addEffect(material);
        }
        catch (Exception material) {
            try {
                Particle particle = Particle.valueOf((String)powerString);
                return this.addEffect(particle);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private Object addEffect(Material material) {
        Item item = this.eliteEntity.getLivingEntity().getWorld().dropItem(this.eliteEntity.getLivingEntity().getLocation(), new ItemStack(material));
        item.setPickupDelay(Integer.MAX_VALUE);
        item.setGravity(false);
        item.setInvulnerable(true);
        EntityTracker.registerVisualEffects((Entity)item);
        return item;
    }

    private Object addEffect(Particle particle) {
        return particle;
    }
}

