/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.quests.objectives;

import com.magmaguy.elitemobs.api.QuestObjectivesCompletedEvent;
import com.magmaguy.elitemobs.config.QuestsConfig;
import com.magmaguy.elitemobs.config.npcs.NPCsConfig;
import com.magmaguy.elitemobs.config.npcs.NPCsConfigFields;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.objectives.CustomObjectivesParser;
import com.magmaguy.elitemobs.quests.objectives.DynamicKillObjective;
import com.magmaguy.elitemobs.quests.objectives.Objective;
import com.magmaguy.elitemobs.quests.rewards.QuestReward;
import com.magmaguy.elitemobs.utils.EventCaller;
import com.magmaguy.elitemobs.utils.SimpleScoreboard;
import com.magmaguy.magmacore.util.ChatColorConverter;
import com.magmaguy.magmacore.util.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class QuestObjectives
implements Serializable {
    private final UUID uuid = UUID.randomUUID();
    protected QuestReward questReward;
    private List<Objective> objectives;
    private Quest quest;
    private boolean over = false;
    private boolean turnedIn = false;
    private boolean forceOver = false;

    public QuestObjectives(int questLevel) {
        this.generateRandomObjective(questLevel);
    }

    public QuestObjectives(QuestReward customQuestReward) {
        this.questReward = customQuestReward;
    }

    private void generateRandomObjective(int questLevel) {
        int killAmount = ThreadLocalRandom.current().nextInt(1 + questLevel, 1 + questLevel * 10);
        EntityType entityType = QuestsConfig.getQuestEntityTypes().get(ThreadLocalRandom.current().nextInt(QuestsConfig.getQuestEntityTypes().size()));
        DynamicKillObjective killObjective = new DynamicKillObjective(killAmount, entityType, questLevel);
        this.objectives = Collections.singletonList(killObjective);
    }

    public void setQuest(Quest quest) {
        this.quest = quest;
        if (quest instanceof CustomQuest) {
            this.objectives = CustomObjectivesParser.processCustomObjectives((CustomQuest)quest);
        }
    }

    public boolean isOver() {
        if (this.forceOver) {
            return true;
        }
        boolean checkOver = true;
        for (Objective objective : this.objectives) {
            if (objective == null) {
                Logger.warn("Found a null objective for quest " + this.quest.getQuestName());
                continue;
            }
            if (objective.isObjectiveCompleted()) continue;
            checkOver = false;
            break;
        }
        return checkOver;
    }

    public void updateQuestStatus(UUID playerUUID) {
        if (this.turnedIn) {
            return;
        }
        if (this.over) {
            return;
        }
        if (!this.isOver()) {
            return;
        }
        this.over = true;
        QuestObjectivesCompletedEvent questObjectivesCompletedEvent = new QuestObjectivesCompletedEvent(Bukkit.getPlayer((UUID)playerUUID), this.quest);
        new EventCaller(questObjectivesCompletedEvent);
    }

    public void displayTemporaryObjectivesScoreboard(Player player) {
        if (!QuestsConfig.isUseQuestScoreboards()) {
            return;
        }
        SimpleScoreboard.temporaryScoreboard(player, ChatColorConverter.convert(this.getQuest().getQuestName()), this.getScoreboardObjectiveText(), 400);
    }

    public void displayLazyObjectivesScoreboard(Player player) {
        if (!QuestsConfig.isUseQuestScoreboards()) {
            return;
        }
        SimpleScoreboard.lazyScoreboard(player, ChatColorConverter.convert(this.getQuest().getQuestName()), this.getScoreboardObjectiveText());
    }

    private List<String> getScoreboardObjectiveText() {
        ArrayList<String> strings = new ArrayList<String>();
        if (!this.isOver()) {
            for (Objective objective : this.objectives) {
                strings.add(QuestsConfig.getQuestScoreboardProgressionLine(objective));
            }
        } else {
            if (this.quest.getQuestTaker() == null) {
                return strings;
            }
            NPCsConfigFields npCsConfigFields = NPCsConfig.getNpcEntities().get(this.quest.getQuestTaker());
            if (npCsConfigFields == null) {
                return strings;
            }
            strings.add(QuestsConfig.getQuestTurnInObjective().replace("$npcName", npCsConfigFields.getName()));
        }
        return strings;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public QuestReward getQuestReward() {
        return this.questReward;
    }

    @Generated
    public void setQuestReward(QuestReward questReward) {
        this.questReward = questReward;
    }

    @Generated
    public List<Objective> getObjectives() {
        return this.objectives;
    }

    @Generated
    public void setObjectives(List<Objective> objectives) {
        this.objectives = objectives;
    }

    @Generated
    public Quest getQuest() {
        return this.quest;
    }

    @Generated
    public boolean isTurnedIn() {
        return this.turnedIn;
    }

    @Generated
    public void setTurnedIn(boolean turnedIn) {
        this.turnedIn = turnedIn;
    }

    @Generated
    public void setForceOver(boolean forceOver) {
        this.forceOver = forceOver;
    }
}

