/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.google.gson.JsonObject;
import com.magmaguy.elitemobs.npcs.NPCEntity;
import com.magmaguy.elitemobs.quests.CustomQuest;
import com.magmaguy.elitemobs.quests.Quest;
import com.magmaguy.elitemobs.quests.menus.QuestMenu;
import com.magmaguy.magmacore.dialog.DialogManager;
import java.util.List;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DialogMaker {
    private static final int questDialogWidth = 300;

    private DialogMaker() {
    }

    private static String processText(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\u00a70", "\u00a7f").replace("&0", "&f");
    }

    public static void sendDialogMessage(Player player, String Title, String message) {
        JsonObject dialogJson = ((DialogManager.NoticeDialogBuilder)((DialogManager.NoticeDialogBuilder)new DialogManager.NoticeDialogBuilder().title(DialogMaker.processText(Title))).addBody(DialogManager.PlainMessageBody.of(DialogMaker.processText(message)))).build();
        player.performCommand("dialog show @s " + dialogJson.toString());
    }

    public static void sendQuestMessage(List<? extends Quest> quests, Player player, NPCEntity npcEntity) {
        if (quests.isEmpty()) {
            return;
        }
        DialogMaker.showQuestDialog(quests, 0, player, npcEntity);
    }

    private static void showQuestDialog(List<? extends Quest> quests, int questIndex, Player player, NPCEntity npcEntity) {
        DialogManager.MultiActionDialogBuilder builder = DialogMaker.buildQuestDialogBuilder(quests, questIndex, player, npcEntity);
        JsonObject dialogJson = builder.build();
        player.performCommand("dialog show @s " + dialogJson.toString());
    }

    private static DialogManager.MultiActionDialogBuilder buildQuestDialogBuilder(List<? extends Quest> quests, int questIndex, Player player, NPCEntity npcEntity) {
        Quest quest = quests.get(questIndex);
        QuestMenu.QuestText questText = new QuestMenu.QuestText(quest, npcEntity, player);
        DialogManager.MultiActionDialogBuilder builder = new DialogManager.MultiActionDialogBuilder();
        DialogMaker.setDialogTitles(builder, questText, questIndex, quests.size());
        DialogMaker.addQuestBodySections(builder, quest, questText);
        DialogMaker.addActionButtons(builder, quest, questText);
        DialogMaker.addNavigationButtons(builder, quests, questIndex, player, npcEntity);
        DialogMaker.configureDialogBehavior(builder);
        return builder;
    }

    private static void setDialogTitles(DialogManager.MultiActionDialogBuilder builder, QuestMenu.QuestText questText, int questIndex, int totalQuests) {
        String title = DialogMaker.processText(questText.getHeader().getText());
        if (title != null && !title.isEmpty()) {
            builder.title(title);
        }
        if (totalQuests > 1) {
            builder.externalTitle("Quest " + (questIndex + 1) + " of " + totalQuests);
        }
    }

    private static void addQuestBodySections(DialogManager.MultiActionDialogBuilder builder, Quest quest, QuestMenu.QuestText questText) {
        DialogMaker.addBodySection(builder, questText.getBody());
        DialogMaker.addBodySectionWithHeader(builder, questText.getFixedSummary(), questText.getSummary(), quest, false);
        DialogMaker.addBodySectionWithHeader(builder, questText.getFixedRewards(), questText.getRewards(), quest, true);
    }

    private static void addBodySection(DialogManager.MultiActionDialogBuilder builder, List<TextComponent> components) {
        if (components == null || components.isEmpty()) {
            return;
        }
        StringBuilder text = new StringBuilder();
        for (TextComponent component : components) {
            if (component.getText() == null) continue;
            text.append(DialogMaker.processText(component.getText())).append("\n");
        }
        if (!text.isEmpty()) {
            builder.addBody(DialogManager.PlainMessageBody.of(text.toString().trim()));
        }
    }

    private static void addBodySectionWithHeader(DialogManager.MultiActionDialogBuilder builder, TextComponent header, List<TextComponent> items, Quest quest, boolean showItemsIfAvailable) {
        boolean hasPreviewItems;
        if (header != null && header.getText() != null) {
            builder.addBody(DialogManager.PlainMessageBody.of(DialogMaker.processText(header.getText())).width(300));
        }
        boolean bl = hasPreviewItems = showItemsIfAvailable && quest != null && quest.getQuestObjectives().getQuestReward().previewRewards() != null && !quest.getQuestObjectives().getQuestReward().previewRewards().isEmpty();
        if (hasPreviewItems) {
            List<ItemStack> previewRewards = quest.getQuestObjectives().getQuestReward().previewRewards();
            for (int i = 0; i < previewRewards.size() && items != null && i < items.size(); ++i) {
                ItemStack itemStack = previewRewards.get(i);
                if (itemStack == null) continue;
                String itemId = itemStack.getType().getKey().toString();
                String description = "";
                if (i < items.size() && items.get(i).getText() != null) {
                    description = DialogMaker.processText(items.get(i).getText());
                }
                DialogManager.ItemBody itemBody = DialogManager.ItemBody.of(itemId, itemStack.getAmount()).showTooltip(true).showDecoration(true);
                JsonObject components = DialogManager.serializeItemComponents(itemStack);
                if (components != null && !components.entrySet().isEmpty()) {
                    itemBody.components(components);
                }
                if (!description.isEmpty()) {
                    itemBody.description(description);
                }
                builder.addBody(itemBody);
            }
        } else if (items != null && !items.isEmpty()) {
            StringBuilder text = new StringBuilder();
            for (TextComponent item : items) {
                if (item.getText() == null) continue;
                text.append("  ").append(DialogMaker.processText(item.getText())).append("\n");
            }
            if (!text.isEmpty()) {
                builder.addBody(DialogManager.PlainMessageBody.of(text.toString().trim()).width(300));
            }
        }
    }

    private static void addActionButtons(DialogManager.MultiActionDialogBuilder builder, Quest quest, QuestMenu.QuestText questText) {
        if (quest instanceof CustomQuest) {
            builder.columns(2);
        }
        DialogMaker.addButtonFromComponent(builder, questText.getAccept());
        if (quest instanceof CustomQuest) {
            DialogMaker.addButtonFromComponent(builder, questText.getTrack());
        }
    }

    private static void addButtonFromComponent(DialogManager.MultiActionDialogBuilder builder, TextComponent component) {
        String command;
        if (component == null || component.getText() == null || component.getText().isEmpty()) {
            return;
        }
        Object text = DialogMaker.processText(component.getText());
        if (((String)text).contains("[Abandon]")) {
            text = ChatColor.BOLD + ChatColor.RED + "[Abandon]";
        }
        if ((command = DialogMaker.extractCommandFromComponent(component)) != null && !command.isEmpty()) {
            builder.addAction(DialogManager.ActionButton.of((String)text, (DialogManager.Action)new DialogManager.RunCommandAction(command)).width(100));
        }
    }

    private static void addNavigationButtons(DialogManager.MultiActionDialogBuilder builder, List<? extends Quest> quests, int questIndex, Player player, NPCEntity npcEntity) {
        if (quests.size() <= 1) {
            return;
        }
        if (questIndex > 0 && questIndex < quests.size() - 1) {
            builder.columns(2);
        }
        if (questIndex > 0) {
            int prevIndex = questIndex - 1;
            builder.addAction(DialogManager.ActionButton.of("\u2190 Previous Quest", (DialogManager.Action)new DialogManager.ShowDialogAction(DialogManager.DialogReference.inline(DialogMaker.buildQuestDialogBuilder(quests, prevIndex, player, npcEntity)))).width(300));
        }
        if (questIndex < quests.size() - 1) {
            int nextIndex = questIndex + 1;
            builder.addAction(DialogManager.ActionButton.of("Next Quest \u2192", (DialogManager.Action)new DialogManager.ShowDialogAction(DialogManager.DialogReference.inline(DialogMaker.buildQuestDialogBuilder(quests, nextIndex, player, npcEntity)))).width(300));
        }
    }

    private static void configureDialogBehavior(DialogManager.MultiActionDialogBuilder builder) {
    }

    private static String extractCommandFromComponent(TextComponent component) {
        if (component == null) {
            return null;
        }
        try {
            if (component.getClickEvent() != null && component.getClickEvent().getAction() == ClickEvent.Action.RUN_COMMAND) {
                return component.getClickEvent().getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

