/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils;

import com.magmaguy.elitemobs.MetadataHandler;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PersistentVanillaData {
    private PersistentVanillaData() {
    }

    public static void write(Entity entity, String key, String value) {
        entity.getPersistentDataContainer().set(PersistentVanillaData.getKey(key), PersistentDataType.STRING, (Object)value);
    }

    public static void write(ItemStack itemStack, String key, double value) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.getPersistentDataContainer().set(PersistentVanillaData.getKey(key), PersistentDataType.DOUBLE, (Object)value);
        itemStack.setItemMeta(itemMeta);
    }

    public static boolean hasString(Entity entity, String key) {
        return entity.getPersistentDataContainer().has(PersistentVanillaData.getKey(key), PersistentDataType.STRING);
    }

    public static String getString(Entity entity, String key) {
        return (String)entity.getPersistentDataContainer().get(PersistentVanillaData.getKey(key), PersistentDataType.STRING);
    }

    public static double getDouble(ItemStack itemStack, String key) {
        if (itemStack == null || itemStack.getItemMeta() == null) {
            return -1.0;
        }
        if (!itemStack.getItemMeta().getPersistentDataContainer().has(PersistentVanillaData.getKey(key), PersistentDataType.DOUBLE)) {
            return -1.0;
        }
        Double d = (Double)itemStack.getItemMeta().getPersistentDataContainer().get(PersistentVanillaData.getKey(key), PersistentDataType.DOUBLE);
        return d == null ? -1.0 : d;
    }

    private static NamespacedKey getKey(String key) {
        return new NamespacedKey((Plugin)MetadataHandler.PLUGIN, key);
    }
}

