/*
 * Decompiled with CFR 0.152.
 */
package com.magmaguy.elitemobs.utils.shapes;

import com.magmaguy.elitemobs.utils.shapes.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class Cylinder
extends Shape {
    private final Vector center;
    private final double radius;
    private final double height;
    private final List<Vector> edgeVectors = null;
    private double borderRadius = 1.0;
    private Location centerLocation = null;
    private List<Vector> locationVectors = null;

    public Cylinder(Location centerLocation, double radius, double height, double borderRadius) {
        this.centerLocation = centerLocation.clone();
        this.center = centerLocation.toVector();
        this.radius = radius;
        this.height = height;
        this.borderRadius = borderRadius;
    }

    public Cylinder(Vector center, double radius, double height) {
        this.center = center;
        this.radius = radius;
        this.height = height;
    }

    public boolean contains(Vector position) {
        double dZ;
        double dX = position.getX() - this.center.getX();
        return dX * dX + (dZ = position.getZ() - this.center.getZ()) * dZ < this.radius * this.radius && position.getY() < this.center.getY() + this.height && position.getY() >= this.center.getY();
    }

    @Override
    public boolean borderContains(Location position) {
        Cylinder innerCylinder = new Cylinder(this.centerLocation, this.borderRadius, this.height, this.borderRadius);
        return this.contains(position) && !innerCylinder.contains(position);
    }

    @Override
    public boolean contains(Location position) {
        return this.contains(position.toVector());
    }

    @Override
    public boolean contains(LivingEntity livingEntity) {
        BoundingBox boundingBox = livingEntity.getBoundingBox();
        if (this.centerLocation.getY() > boundingBox.getMinY() || this.centerLocation.getY() + this.height < boundingBox.getMaxY()) {
            return false;
        }
        double circleDistanceX = Math.abs(this.centerLocation.getX() - boundingBox.getCenterX());
        double circleDistanceZ = Math.abs(this.centerLocation.getZ() - boundingBox.getCenterZ());
        if (circleDistanceX > boundingBox.getWidthX() / 2.0 + this.radius) {
            return false;
        }
        if (circleDistanceZ > boundingBox.getWidthZ() / 2.0 + this.radius) {
            return false;
        }
        if (circleDistanceX <= boundingBox.getWidthX() / 2.0) {
            return true;
        }
        if (circleDistanceZ <= boundingBox.getWidthZ() / 2.0) {
            return true;
        }
        double cornerDistanceSquared = Math.pow((circleDistanceX - boundingBox.getWidthX()) / 2.0, 2.0) + Math.pow((circleDistanceZ - boundingBox.getWidthZ()) / 2.0, 2.0);
        return cornerDistanceSquared <= this.radius * this.radius;
    }

    @Override
    public void visualize(Particle particle) {
        this.getLocations().forEach(newLocation -> newLocation.getWorld().spawnParticle(particle, newLocation, 1, 0.0, 0.0, 0.0, 0.0));
    }

    @Override
    public Location getCenter() {
        return this.centerLocation;
    }

    @Override
    public List<Location> getEdgeLocations() {
        if (this.edgeVectors != null) {
            return this.convert(this.edgeVectors);
        }
        ArrayList<Location> edgeLocations = new ArrayList<Location>();
        this.getLocations().forEach(iteratedLocation -> {
            if (this.borderContains((Location)iteratedLocation)) {
                edgeLocations.add((Location)iteratedLocation);
            }
        });
        return edgeLocations;
    }

    private List<Vector> getLocationVectors() {
        if (this.locationVectors != null) {
            return this.locationVectors;
        }
        this.locationVectors = new ArrayList<Vector>();
        for (int x = (int)(-this.radius); x < (int)this.radius; ++x) {
            for (int z = (int)(-this.radius); z < (int)this.radius; ++z) {
                int y = 0;
                while ((double)y < this.height) {
                    Vector newVector = new Vector(x, y, z);
                    Location newLocation = this.centerLocation.clone().add(newVector);
                    if (this.contains(newLocation)) {
                        this.locationVectors.add(newVector);
                    }
                    ++y;
                }
            }
        }
        return this.locationVectors;
    }

    @Override
    public List<Location> getLocations() {
        if (this.locationVectors != null) {
            return this.convert(this.locationVectors);
        }
        return this.convert(this.getLocationVectors());
    }

    private List<Location> convert(List<Vector> vectors) {
        return vectors.stream().map(edge -> this.centerLocation.clone().add(edge)).collect(Collectors.toList());
    }
}

