/*
 * Decompiled with CFR 0.152.
 */
package dev.kgriffon.databaseutils;

import dev.kgriffon.databaseutils.DatabaseLinkException;
import dev.kgriffon.databaseutils.DatabaseUtils;
import dev.kgriffon.databaseutils.Type;
import dev.kgriffon.databaseutils.database.Database;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;

public abstract class DatabaseQueries {
    private Database db = null;

    public void link(Database db) {
        if (this.db != null) {
            DatabaseUtils.LOGGER.warn("A new database was linked after one had already been linked.");
        }
        this.db = db;
    }

    public Connection getConnection() throws DatabaseLinkException, SQLException {
        this.checkLink();
        return this.db.getConnection();
    }

    public ExecutorService getExecutor() {
        return this.db.getExecutor();
    }

    public Type getType() throws DatabaseLinkException {
        this.checkLink();
        return this.db.getType();
    }

    public boolean is(Type type) throws DatabaseLinkException {
        this.checkLink();
        return this.db.getType().equals((Object)type);
    }

    public abstract void init();

    private void checkLink() throws DatabaseLinkException {
        if (this.db == null) {
            throw new DatabaseLinkException();
        }
    }
}

