/*
 * Decompiled with CFR 0.152.
 */
package dev.kgriffon.databaseutils.database;

import dev.kgriffon.databaseutils.Type;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;

public abstract class Database {
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Type type;
    private final String uri;
    private final String user;
    private final String password;

    protected Database(Type type, String uri, @Nullable String user, @Nullable String password) {
        this.type = type;
        this.uri = uri;
        this.user = user;
        this.password = password;
    }

    public Connection getConnection() throws SQLException {
        if (this.user == null || this.password == null) {
            return DriverManager.getConnection(this.uri);
        }
        return DriverManager.getConnection(this.uri, this.user, this.password);
    }

    public void disconnect() {
        this.executor.shutdown();
    }

    public Type getType() {
        return this.type;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }
}

