/*
 * Decompiled with CFR 0.152.
 */
package hive.common.world.entities.ai;

import hive.common.world.Physics;
import hive.common.world.entities.ai.IntegerAABB;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class DroidNodeEvaluator
extends WalkNodeEvaluator {
    private static final IntegerAABB.Mutable BOUNDS = new IntegerAABB.Mutable();
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private static final Node[] CACHE = new Node[Direction.Plane.HORIZONTAL.length()];
    private final Object2BooleanMap<IntegerAABB> jumpCollisions = new Object2BooleanOpenHashMap();
    private final double speedFactor;
    private final double fluidJumpHeight;
    private final boolean assumeSprinting;
    private final int jumpWidth;
    private final int fluidJumpWidth;
    private double jumpXZSpeed;
    private double jumpYSpeed;
    private double gravity;
    private double jumpHeight;
    private double maxStep;

    public DroidNodeEvaluator(double speedFactor, boolean assumeSprinting, int jumpWidth, int fluidJumpWidth, double fluidJumpHeight) {
        this.speedFactor = speedFactor;
        this.assumeSprinting = assumeSprinting;
        this.jumpWidth = jumpWidth;
        this.fluidJumpWidth = fluidJumpWidth;
        this.fluidJumpHeight = fluidJumpHeight;
    }

    public static int getMinCacheSize(int jumpWidth, int fluidJumpWidth) {
        int jumpNodes = (jumpWidth * 2 + 1) * (jumpWidth * 2 + 1);
        int fluidNodes = (fluidJumpWidth * 2 + 1) * (fluidJumpWidth * 2 + 1);
        return 9 + Math.max(jumpNodes, fluidNodes);
    }

    public void prepare(PathNavigationRegion region, Mob mob) {
        super.prepare(region, mob);
        this.jumpXZSpeed = mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedFactor;
        this.jumpYSpeed = mob.getAttributeValue(Attributes.JUMP_STRENGTH) + (double)mob.getJumpBoostPower();
        this.gravity = -mob.getAttributeValue(Attributes.GRAVITY);
        this.jumpHeight = Physics.getHeight(this.gravity, this.jumpYSpeed);
        this.maxStep = mob.maxUpStep();
    }

    protected double getJumpXZSpeed(boolean canSprint) {
        if (canSprint && (this.assumeSprinting || this.mob.isSprinting())) {
            return this.jumpXZSpeed + 0.2;
        }
        return this.jumpXZSpeed;
    }

    public void done() {
        super.done();
        this.jumpCollisions.clear();
    }

    public Node getStart() {
        return this.getStartNode(this.mob.blockPosition());
    }

    @Nullable
    protected Node getJumpNode(Node start, int x, int z, double floor, boolean canSprint) {
        double y = floor + this.getMobJumpHeight();
        Node node = this.tryFindFirstGroundNode(x, z, y - (double)this.mob.getMaxFallDistance(), y, this.maxStep, false);
        if (this.isNeighborValid(node, start) && this.canJump(start, node, floor, canSprint)) {
            return node;
        }
        return null;
    }

    @Nullable
    protected Node getCloseJumpNode(Node start, int x, int z, double floor, boolean canSprint) {
        double maxY = floor + this.getMobJumpHeight();
        double minY = Math.max(floor + this.maxStep, maxY - (double)this.mob.getMaxFallDistance());
        Node node = this.tryFindFirstGroundNode(x, z, minY, maxY, this.maxStep, false);
        if (this.isNeighborValid(node, start) && this.canJump(start, node, floor, canSprint)) {
            return node;
        }
        return null;
    }

    @Nullable
    protected Node getWalkNode(Node start, int x, int z, double floor) {
        Node node = this.tryFindFirstGroundNode(x, z, floor - (double)this.mob.getMaxFallDistance(), floor, this.maxStep, true);
        if (this.isNeighborValid(node, start)) {
            return node;
        }
        return null;
    }

    protected boolean isNeighborValid(@Nullable Node target, Node start) {
        return target != null && !target.closed && target.costMalus >= 0.0f;
    }

    @Nullable
    protected Node getUpNode(Node start, double floor) {
        double maxY = Math.min(floor + this.getMobJumpHeight(), (double)(start.y + this.entityHeight));
        Node node = this.tryFindFirstGroundNode(start.x, start.z, floor, maxY, this.maxStep, true);
        if (this.isNeighborValid(node, start)) {
            return node;
        }
        return null;
    }

    @Nullable
    protected Node getDownNode(Node start, double floor) {
        Node node = this.tryFindFirstGroundNode(start.x, start.z, this.mob.level().getMinY(), floor, 0.0, true);
        if (this.isNeighborValid(node, start)) {
            return node;
        }
        return null;
    }

    protected double getFloorLevel(BlockPos pos) {
        CollisionGetter world = this.currentContext.level();
        if (world.getFluidState(pos).is(FluidTags.WATER)) {
            return pos.getY();
        }
        return DroidNodeEvaluator.getFloorLevel((BlockGetter)world, (BlockPos)pos);
    }

    @Nullable
    protected Node tryFindFirstGroundNode(int x, int z, double minY, double maxY, double step, boolean stopOnFirst) {
        int min = Math.max(this.mob.level().getMinY(), Mth.floor((double)minY));
        for (int i = Math.min(this.mob.level().getMaxY(), Mth.ceil((double)(maxY + step))); i >= min; --i) {
            double floor = this.getFloorLevel((BlockPos)MUTABLE.set(x, i, z));
            if (floor >= maxY + step) continue;
            if (floor < minY) break;
            PathType path = this.getCachedPathType(x, i, z);
            float malus = this.mob.getPathfindingMalus(path);
            if (path == PathType.OPEN) continue;
            if (malus >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, path, malus);
            }
            if (!stopOnFirst || !(floor < maxY)) continue;
            return this.getBlockedNode(x, i, z);
        }
        return null;
    }

    protected double getMobJumpHeight() {
        return this.jumpHeight;
    }

    protected boolean hasJumpCollisions(IntegerAABB bounds, @Nullable IntegerAABB exclude) {
        boolean set;
        if (bounds.isEmpty()) {
            return false;
        }
        boolean bl = set = exclude == null || !bounds.intersects(exclude);
        if (this.jumpCollisions.containsKey((Object)bounds)) {
            if (!this.jumpCollisions.getBoolean((Object)bounds)) {
                return false;
            }
            if (set) {
                return true;
            }
        }
        for (int x = bounds.minX; x < bounds.maxX; ++x) {
            for (int y = bounds.minY; y < bounds.maxY; ++y) {
                for (int z = bounds.minZ; z < bounds.maxZ; ++z) {
                    if (exclude != null && exclude.intersects(x, y, z)) continue;
                    MUTABLE.set(x, y, z);
                    if (this.currentContext.level().getBlockState((BlockPos)MUTABLE).getCollisionShape((BlockGetter)this.currentContext.level(), (BlockPos)MUTABLE).isEmpty()) continue;
                    this.jumpCollisions.put((Object)bounds.immutable(), true);
                    return true;
                }
            }
        }
        if (set) {
            this.jumpCollisions.put((Object)bounds.immutable(), false);
        }
        return false;
    }

    @Nullable
    protected Node getFluidNode(Node start, int x, int y, int z) {
        PathType path = this.getCachedPathType(x, y, z);
        Node node = this.getNodeAndUpdateCostToMax(x, y, z, path, this.mob.getPathfindingMalus(path));
        if (this.isNeighborValid(node, start)) {
            return node;
        }
        return null;
    }

    protected int addFluidNodes(Node[] arr, Node start, int i, double fluidHeight) {
        Node up;
        for (int x = start.x - this.fluidJumpWidth; x <= start.x + this.fluidJumpWidth; ++x) {
            for (int z = start.z - this.fluidJumpWidth; z <= start.z + this.fluidJumpWidth; ++z) {
                Node node;
                if (x == start.x && z == start.z || !this.isNeighborValid(node = this.tryFindFirstGroundNode(x, z, fluidHeight - (double)this.mob.getMaxFallDistance() + this.fluidJumpHeight, fluidHeight + this.fluidJumpHeight, this.maxStep, false), start) || !this.canJump(start, node, fluidHeight, false)) continue;
                arr[i++] = node;
            }
        }
        if (start.y + 1 <= this.currentContext.level().getMaxY() && (up = this.getFluidNode(start, start.x, start.y + 1, start.z)) != null) {
            arr[i++] = up;
        }
        return i;
    }

    protected int addJumps(Node[] arr, Node start, double floor, int i, boolean canSprint) {
        for (int x = -this.jumpWidth; x <= this.jumpWidth; ++x) {
            for (int z = -this.jumpWidth; z <= this.jumpWidth; ++z) {
                Node node;
                if (x == 0 && z == 0 || (node = Math.abs(x) == 1 || Math.abs(z) == 1 ? this.getCloseJumpNode(start, start.x + x, start.z + z, floor, canSprint) : this.getJumpNode(start, start.x + x, start.z + z, floor, canSprint)) == null) continue;
                arr[i++] = node;
            }
        }
        return i;
    }

    protected boolean canJump(Node start, Node to, double floor, boolean canSprint) {
        double distH = start.distanceToXZ(to) - 1.0f;
        double toFloor = this.getFloorLevel((BlockPos)MUTABLE.set(to.x, to.y, to.z));
        double diff = toFloor - floor;
        return Physics.getLandingTime(this.gravity, diff, this.jumpYSpeed).map(time -> time * this.getJumpXZSpeed(canSprint) > distH && this.canJumpCollision(start, to, floor, (double)time)).orElse(false);
    }

    protected boolean canJumpCollision(Node start, Node to, double floor, double time) {
        double dX = to.x - start.x;
        double dZ = to.z - start.z;
        IntegerAABB bounds = new IntegerAABB(start.x, start.y, start.z, start.x + this.entityWidth, start.y + this.entityHeight, start.z + this.entityDepth);
        double len = Math.sqrt(dX * dX + dZ * dZ);
        int steps = Mth.ceil((double)(len / (double)Math.min(this.entityDepth, this.entityWidth)));
        dX /= (double)steps;
        dZ /= (double)steps;
        double dT = time / (double)steps;
        for (int i = 0; i < steps; ++i) {
            int minX = Mth.floor((double)((double)start.x + dX * (double)i));
            int maxX = Mth.ceil((double)((double)start.x + dX * (double)i)) + this.entityWidth;
            if (dX < 0.0) {
                minX = Math.min(start.x + 1, minX);
                maxX = Math.min(start.x + 2, maxX);
            } else if (dX > 0.0) {
                minX = Math.max(start.x - 1, minX);
                maxX = Math.max(start.x, maxX);
            }
            int minZ = Mth.floor((double)((double)start.z + dZ * (double)i));
            int maxZ = Mth.ceil((double)((double)start.z + dZ * (double)i)) + this.entityDepth;
            if (dZ < 0.0) {
                minZ = Math.min(start.z + 1, minZ);
                maxZ = Math.min(start.z + 2, maxZ);
            } else if (dZ > 0.0) {
                minZ = Math.max(start.z - 1, minZ);
                maxZ = Math.max(start.z, maxZ);
            }
            double t1 = dT * (double)i;
            double t2 = dT * (double)(i + 1);
            int minY = Mth.floor((double)(floor + Physics.getMinHeight(this.gravity, this.jumpYSpeed, t1, t2)));
            int maxY = Mth.ceil((double)(floor + Physics.getMaxHeight(this.gravity, this.jumpYSpeed, t1, t2))) + this.entityHeight;
            BOUNDS.set(minX, minY, minZ, maxX, maxY, maxZ);
            if (!this.hasJumpCollisions(BOUNDS, bounds)) continue;
            return false;
        }
        return true;
    }

    protected boolean canJumpIn(PathType type) {
        return type != PathType.STICKY_HONEY;
    }

    protected boolean canJumpOn(PathType type) {
        return type == PathType.BLOCKED || type == PathType.FENCE || type == PathType.LEAVES;
    }

    protected int addHorizontal(Node[] arr, Node start, double floor, int i) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Node node = this.getWalkNode(start, start.x + direction.getStepX(), start.z + direction.getStepZ(), floor);
            if (node != null) {
                arr[i++] = node;
            }
            DroidNodeEvaluator.CACHE[direction.get2DDataValue()] = node;
        }
        for (Direction dir1 : Direction.Plane.HORIZONTAL) {
            Node node;
            Direction dir2 = dir1.getClockWise();
            if (!this.isDiagonalValid(start, CACHE[dir1.get2DDataValue()], CACHE[dir2.get2DDataValue()]) || !this.isDiagonalValid(node = this.getWalkNode(start, start.x + dir1.getStepX() + dir2.getStepX(), start.z + dir1.getStepZ() + dir2.getStepZ(), floor))) continue;
            arr[i++] = node;
        }
        return i;
    }

    public PathType getPathType(PathfindingContext context, int x, int y, int z) {
        PathType path = context.getPathTypeFromState(x, y, z);
        if (path == PathType.OPEN && y >= context.level().getMinY() + 1) {
            return switch (context.getPathTypeFromState(x, y - 1, z)) {
                case PathType.OPEN, PathType.WATER, PathType.LAVA, PathType.WALKABLE -> PathType.OPEN;
                case PathType.DAMAGE_FIRE -> PathType.DAMAGE_FIRE;
                case PathType.DAMAGE_OTHER -> PathType.DAMAGE_OTHER;
                case PathType.STICKY_HONEY -> PathType.STICKY_HONEY;
                case PathType.POWDER_SNOW -> PathType.DANGER_POWDER_SNOW;
                case PathType.DAMAGE_CAUTIOUS -> PathType.DAMAGE_CAUTIOUS;
                case PathType.TRAPDOOR -> PathType.DANGER_TRAPDOOR;
                default -> DroidNodeEvaluator.checkNeighbourBlocks((PathfindingContext)context, (int)x, (int)y, (int)z, (PathType)PathType.WALKABLE);
            };
        }
        if (path == PathType.STICKY_HONEY) {
            return PathType.BLOCKED;
        }
        return path;
    }

    public int getNeighbors(Node[] arr, Node start) {
        BlockPos pos = new BlockPos(start.x, start.y, start.z);
        int i = 0;
        double floor = this.getFloorLevel(pos);
        PathType type = this.getCachedPathType(start.x, start.y, start.z);
        PathType downType = this.getCachedPathType(start.x, start.y - 1, start.z);
        FluidState fluid = this.currentContext.level().getFluidState(pos);
        double fluidHeight = fluid.getHeight((BlockGetter)this.currentContext.level(), pos);
        boolean canJump = this.canJumpIn(type) && this.canJumpOn(downType) && fluidHeight <= this.mob.getFluidJumpThreshold();
        Node down = this.getDownNode(start, floor);
        if (down != null) {
            arr[i++] = down;
        }
        i = this.addHorizontal(arr, start, floor, i);
        if (canJump) {
            if (this.getMobJumpHeight() >= 1.0) {
                Node up = this.getUpNode(start, floor);
                if (up != null) {
                    arr[i++] = up;
                }
                boolean canSprint = fluid.getFluidType().isAir();
                i = this.addJumps(arr, start, floor, i, canSprint);
            }
        } else if (!fluid.getFluidType().isAir()) {
            i = this.addFluidNodes(arr, start, i, (double)start.y + fluidHeight);
        }
        return i;
    }
}

