/*
 * Decompiled with CFR 0.152.
 */
package hive.common.world.entities.ai;

import hive.common.world.entities.DroidEntity;
import hive.common.world.entities.ai.DroidMoveControl;
import hive.common.world.entities.ai.DroidNodeEvaluator;
import hive.common.world.entities.ai.DroidPathfinder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DroidPathNavigation
extends GroundPathNavigation {
    public static final int JUMP_WIDTH = 5;
    public static final int FLUID_JUMP_WIDTH = 1;
    private static final double FLUID_JUMP_HEIGHT = 0.1111111111111111;
    private static final BlockPos.MutableBlockPos MUTABLE = new BlockPos.MutableBlockPos();
    private final DroidEntity mob;

    public DroidPathNavigation(DroidEntity entity, Level world) {
        super((Mob)entity, world);
        this.mob = entity;
        this.setCanFloat(true);
    }

    private boolean isJump(BlockGetter world, double step, @Nullable Node prev, Node next) {
        if (prev == null) {
            return false;
        }
        if (Math.abs(prev.x - next.x) >= 2 || Math.abs(prev.z - next.z) >= 2) {
            return true;
        }
        double prevHeight = WalkNodeEvaluator.getFloorLevel((BlockGetter)world, (BlockPos)MUTABLE.set(prev.x, prev.y, prev.z));
        double nextHeight = WalkNodeEvaluator.getFloorLevel((BlockGetter)world, (BlockPos)MUTABLE.set(next.x, next.y, next.z));
        return nextHeight - prevHeight > step;
    }

    protected PathFinder createPathFinder(int max) {
        this.nodeEvaluator = new DroidNodeEvaluator(1.0, true, 5, 1, 0.1111111111111111);
        return new DroidPathfinder(this.nodeEvaluator, max, 1.0, true);
    }

    protected double getGroundY(Vec3 pos) {
        BlockState below;
        BlockPos block = BlockPos.containing((Position)pos);
        BlockState state = this.level.getBlockState(block);
        FluidState fluid = state.getFluidState();
        if (!fluid.isEmpty()) {
            FluidState above = this.level.getBlockState(block.above()).getFluidState();
            float height = fluid.getHeight((BlockGetter)this.level, block);
            if (above.getType().isSame(fluid.getType())) {
                return pos.y() + 0.5;
            }
            if ((double)height > this.mob.getFluidJumpThreshold()) {
                return pos.y() + (double)height;
            }
        }
        if (!(below = this.level.getBlockState(block.below())).isAir() && below.getFluidState().isEmpty()) {
            return WalkNodeEvaluator.getFloorLevel((BlockGetter)this.level, (BlockPos)block);
        }
        return pos.y();
    }

    public void tick() {
        super.tick();
        if (!this.isDone()) {
            DroidMoveControl control;
            MoveControl moveControl = this.mob.getMoveControl();
            if (moveControl instanceof DroidMoveControl && (control = (DroidMoveControl)moveControl).isStuck()) {
                this.stop();
                control.setStuck(false);
            } else {
                MoveControl moveControl2;
                Node prev = this.path.getPreviousNode();
                Node node = this.path.getNextNode();
                if (this.isJump((BlockGetter)this.mob.level(), this.mob.maxUpStep(), prev, node) && (moveControl2 = this.mob.getMoveControl()) instanceof DroidMoveControl) {
                    DroidMoveControl control2 = (DroidMoveControl)moveControl2;
                    Vec3 target = this.path.getNextEntityPos((Entity)this.mob);
                    control2.jumpTowards(target.x(), this.getGroundY(target), target.z(), this.speedModifier);
                }
            }
        }
    }

    protected boolean shouldTargetNextNodeInDirection(Vec3 start) {
        return super.shouldTargetNextNodeInDirection(start) && !DroidPathfinder.isJump(this.path.getNextNode(), this.path.getNode(this.path.getNextNodeIndex() + 1));
    }
}

