/*
 * Decompiled with CFR 0.152.
 */
package hive.common.world.entities.ai;

public class IntegerAABB {
    protected int minX;
    protected int minY;
    protected int minZ;
    protected int maxX;
    protected int maxY;
    protected int maxZ;

    public IntegerAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public IntegerAABB immutable() {
        return this;
    }

    protected void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public boolean isEmpty() {
        return this.maxX <= this.minX || this.maxY <= this.minY || this.maxZ <= this.minZ;
    }

    public boolean intersects(IntegerAABB bounds) {
        return bounds.maxX > this.minX && bounds.maxY > this.minY && bounds.maxZ > this.minZ && this.maxX > bounds.minX && this.maxY > bounds.minY && this.maxZ > bounds.minZ;
    }

    public boolean intersects(int x, int y, int z) {
        return this.minX <= x && this.maxX > x && this.minY <= y && this.maxY > y && this.minZ <= z && this.maxZ > z;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof IntegerAABB)) return false;
        IntegerAABB bounds = (IntegerAABB)obj;
        if (bounds.minX != this.minX) return false;
        if (bounds.maxX != this.maxX) return false;
        if (bounds.minY != this.minY) return false;
        if (bounds.maxY != this.maxY) return false;
        if (bounds.minZ != this.minZ) return false;
        if (bounds.maxZ != this.maxZ) return false;
        return true;
    }

    public int hashCode() {
        return this.minX * this.maxX + this.minY * this.maxY + this.minZ * this.maxZ;
    }

    public static class Mutable
    extends IntegerAABB {
        public Mutable() {
            super(0, 0, 0, 0, 0, 0);
        }

        @Override
        public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            super.set(minX, minY, minZ, maxX, maxY, maxZ);
        }

        @Override
        public IntegerAABB immutable() {
            return new IntegerAABB(this.getMinX(), this.getMinY(), this.getMinZ(), this.getMaxX(), this.getMaxY(), this.getMaxZ());
        }
    }
}

