/*
 * Decompiled with CFR 0.152.
 */
package hive.client.render;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.phys.Vec3;

public final class ClientHelper {
    private static final double DISTANCE = 0.1;

    private ClientHelper() {
    }

    public static void renderPath(List<BlockPos> path) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && !path.isEmpty()) {
            for (BlockPos pos : path) {
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
            for (int i = 1; i < path.size(); ++i) {
                BlockPos from = path.get(i - 1);
                BlockPos to = path.get(i);
                double total = Math.sqrt(from.distSqr((Vec3i)to));
                Vec3 dir = Vec3.atLowerCornerOf((Vec3i)to.subtract((Vec3i)from)).normalize().scale(0.1);
                Vec3 current = Vec3.atCenterOf((Vec3i)from);
                for (double j = 0.0; j < total; j += 0.1) {
                    world.addParticle((ParticleOptions)ParticleTypes.SMOKE, current.x(), current.y(), current.z(), 0.0, 0.0, 0.0);
                    current = current.add(dir);
                }
            }
        }
    }
}

