/*
 * Decompiled with CFR 0.152.
 */
package hive.common.world.entities;

import hive.common.ItemTags;
import hive.common.ServerConfigs;
import hive.common.world.entities.ai.DroidMoveControl;
import hive.common.world.entities.ai.DroidPathNavigation;
import hive.common.world.packets.DebugPathEffectPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class DroidEntity
extends Monster {
    public static final float FLY_MULTIPLIER = 0.2f;
    public static final double JUMP_BOOST = 0.2;
    public static final List<EquipmentSlot> EQUIPMENT_POPULATION_ORDER = List.of(EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.OFFHAND);

    public DroidEntity(EntityType<? extends DroidEntity> type, Level world) {
        super(type, world);
        this.moveControl = new DroidMoveControl(this);
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return DroidEntity.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason spawn, @Nullable SpawnGroupData data) {
        RandomSource random = world.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(world, random, difficulty);
        return super.finalizeSpawn(world, difficulty, spawn, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        double chance = this.level().getDifficulty() == Difficulty.HARD ? (Double)ServerConfigs.INSTANCE.droidHardGearRate.get() : (Double)ServerConfigs.INSTANCE.droidGearRate.get();
        for (EquipmentSlot slot : EQUIPMENT_POPULATION_ORDER) {
            if (!(random.nextDouble() < chance)) break;
            BuiltInRegistries.ITEM.getOrThrow(ItemTags.DROID_EQUIPMENT.get(slot)).getRandomElement(random).ifPresent(item -> this.setItemSlot(slot, new ItemStack(item)));
        }
    }

    protected float getFlyingSpeed() {
        return this.getSpeed() * 0.2f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new OpenDoorGoal((Mob)this, false));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)this.getTargetPlayerGoal((Mob)this));
    }

    protected TargetGoal getTargetPlayerGoal(Mob mob) {
        NearestAttackableTargetGoal goal = new NearestAttackableTargetGoal(mob, Player.class, false);
        goal.targetConditions = goal.targetConditions.ignoreLineOfSight();
        return goal;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return source.type().effects().sound();
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.PLAYER_SMALL_FALL, SoundEvents.PLAYER_BIG_FALL);
    }

    protected void customServerAiStep(ServerLevel world) {
        Path path;
        DroidMoveControl control;
        boolean sprint;
        super.customServerAiStep(world);
        MoveControl moveControl = this.getMoveControl();
        if (moveControl instanceof DroidMoveControl && (sprint = (control = (DroidMoveControl)moveControl).shouldSprint()) != this.isSprinting()) {
            this.setSprinting(sprint);
        }
        if (((Boolean)ServerConfigs.INSTANCE.pathDebug.get()).booleanValue() && world.getGameTime() % 20L == 0L && (path = this.getNavigation().getPath()) != null) {
            ArrayList<BlockPos> all = new ArrayList<BlockPos>();
            for (int i = 0; i < path.getNodeCount(); ++i) {
                Node node = path.getNode(i);
                all.add(new BlockPos(node.x, node.y, node.z));
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new DebugPathEffectPacket(all), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected DroidPathNavigation createNavigation(Level world) {
        DroidPathNavigation navigation = new DroidPathNavigation(this, world);
        navigation.setCanOpenDoors(true);
        return navigation;
    }

    public DroidPathNavigation getNavigation() {
        return (DroidPathNavigation)super.getNavigation();
    }

    public boolean isInSwimmableFluid() {
        return this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType));
    }
}

