/*
 * Decompiled with CFR 0.152.
 */
package hive.common.world.entities.ai;

import hive.common.world.Physics;
import hive.common.world.entities.DroidEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public class DroidMoveControl
extends MoveControl {
    private static final double ERROR = 1.0E-7;
    private static final double JUMP_ERROR = 0.1;
    private static final int JUMP_CAP = 5;
    private final DroidEntity mob;
    private DroidOperation operation = DroidOperation.WAIT;
    private int jumpDelay;
    private boolean stuck;

    public DroidMoveControl(DroidEntity mob) {
        super((Mob)mob);
        this.mob = mob;
    }

    public void tick() {
        double tZ;
        double tX;
        Optional<Double> t;
        double max = this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
        if (this.operation == DroidOperation.WAIT) {
            this.setDeltaMovement(0.0, 0.0, max);
            return;
        }
        double dX = this.wantedX - this.mob.getX();
        double dY = this.wantedY - this.mob.getY();
        double dZ = this.wantedZ - this.mob.getZ();
        float rot = this.rotlerp(this.mob.getYRot(), (float)(Mth.atan2((double)dZ, (double)dX) * 180.0 / 3.1415927410125732) - 90.0f, 90.0f);
        double dist = Math.sqrt(dX * dX + dZ * dZ + dY * dY);
        if (dist < 1.0E-7) {
            this.setOperation(DroidOperation.WAIT);
        }
        if (this.operation == DroidOperation.START_JUMP) {
            if (this.mob.onGround()) {
                if (this.isInFluid()) {
                    this.setOperation(DroidOperation.IN_FLUID);
                } else {
                    t = this.getJumpLandingTime();
                    if (t.isEmpty()) {
                        this.setOperation(DroidOperation.WAIT);
                        this.setStuck(true);
                    } else {
                        double tX2 = dX / t.get();
                        double tZ2 = dZ / t.get();
                        this.mob.setYRot(rot);
                        this.setDeltaMovement(tX2, tZ2, max);
                        if (++this.jumpDelay > 5 || this.canJump(tX2, tZ2)) {
                            this.mob.getJumpControl().jump();
                        }
                    }
                }
            } else {
                this.setOperation(DroidOperation.IN_AIR);
            }
        }
        if (this.operation == DroidOperation.IN_AIR) {
            if (this.isInFluid()) {
                this.setOperation(DroidOperation.IN_FLUID);
            } else if (this.mob.onGround()) {
                this.setOperation(DroidOperation.WAIT);
            } else {
                t = this.getLandingTime();
                if (t.isEmpty()) {
                    this.setOperation(DroidOperation.WAIT);
                    this.setStuck(true);
                } else {
                    this.mob.setYRot(rot);
                    this.setDeltaMovement(dX / t.get(), dZ / t.get(), max);
                }
            }
        }
        double len = Math.sqrt(dX * dX + dZ * dZ);
        double speed = Math.min(len, max);
        if (this.operation == DroidOperation.IN_FLUID) {
            if (!this.isInFluid()) {
                if (this.mob.onGround()) {
                    this.setOperation(DroidOperation.MOVE_TO);
                } else {
                    this.setOperation(DroidOperation.IN_AIR);
                }
            } else {
                double slow;
                if (dY > this.mob.getFluidJumpThreshold() && this.mob.level().getRandom().nextFloat() < 0.8f) {
                    this.mob.getJumpControl().jump();
                }
                if (this.mob.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    slow = 0.96;
                } else {
                    slow = this.mob.isSprinting() ? 0.9 : (double)this.mob.getWaterSlowDown();
                    double eff = this.mob.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                    if (!this.mob.onGround()) {
                        eff *= 0.5;
                    }
                    if (eff > 0.0) {
                        slow += (0.54600006 - slow) * eff;
                    }
                }
                tX = dX * speed / len / slow;
                tZ = dZ * speed / len / slow;
                this.mob.setYRot(rot);
                this.setDeltaMovement(tX, tZ, max);
            }
        }
        if (this.operation == DroidOperation.MOVE_TO) {
            if (this.isInFluid()) {
                this.setOperation(DroidOperation.IN_FLUID);
            } else if (!this.mob.onGround()) {
                this.setOperation(DroidOperation.IN_AIR);
            } else {
                BlockPos below = this.mob.getBlockPosBelowThatAffectsMyMovement();
                float friction = this.mob.level().getBlockState(below).getFriction((LevelReader)this.mob.level(), below, (Entity)this.mob);
                tX = dX * speed / len / (double)friction;
                tZ = dZ * speed / len / (double)friction;
                this.mob.setYRot(rot);
                this.setDeltaMovement(tX, tZ, max);
            }
        }
    }

    private void setDeltaMovement(double cX, double cZ, double speed) {
        this.mob.setSpeed((float)speed);
        double rot = (double)this.mob.getYRot() * Math.PI / 180.0;
        double dX = -Math.sin(rot);
        double dZ = Math.cos(rot);
        Vec3 delta = this.mob.getDeltaMovement();
        double changeDX = (cX - delta.x()) / speed;
        double changeDZ = (cZ - delta.z()) / speed;
        double zza = changeDX * dX + changeDZ * dZ;
        double sX = changeDX - zza * dX;
        double sZ = changeDZ - zza * dZ;
        double xxa = Math.sqrt(sX * sX + sZ * sZ);
        double side = -changeDX * sZ + changeDZ * sX;
        if (side < 0.0) {
            xxa *= -1.0;
        }
        if (!this.mob.onGround()) {
            zza /= (double)0.2f;
            xxa /= (double)0.2f;
        }
        if (Math.abs(zza) < 1.0E-7 || !Double.isFinite(zza)) {
            this.mob.setZza(0.0f);
        } else {
            this.mob.setZza((float)Mth.clamp((double)zza, (double)-1.0, (double)1.0));
        }
        if (Math.abs(xxa) < 1.0E-7 || !Double.isFinite(xxa)) {
            this.mob.setXxa(0.0f);
        } else {
            this.mob.setXxa((float)Mth.clamp((double)xxa, (double)-1.0, (double)1.0));
        }
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void setStuck(boolean stuck) {
        this.stuck = stuck;
    }

    public boolean shouldSprint() {
        return this.operation != DroidOperation.WAIT && !this.mob.isInSwimmableFluid() && (!this.mob.isInWater() || this.mob.isUnderWater());
    }

    protected void setOperation(DroidOperation operation) {
        this.operation = operation;
    }

    protected boolean isInFluid() {
        return this.mob.isInSwimmableFluid() && (!this.canJumpFluid() || this.mob.isUnderWater());
    }

    protected boolean canJump(double tX, double tZ) {
        Vec3 speed = this.mob.getDeltaMovement();
        double xSpeed = speed.x();
        double zSpeed = speed.z();
        if (this.mob.isSprinting()) {
            double rot = (double)this.mob.getYRot() * Math.PI / 180.0;
            xSpeed -= Math.sin(rot) * 0.2;
            zSpeed += Math.cos(rot) * 0.2;
        }
        return Math.abs(tX - xSpeed) < 0.1 && Math.abs(tZ - zSpeed) < 0.1;
    }

    public void jumpTowards(double x, double y, double z, double speed) {
        if (this.operation == DroidOperation.WAIT || this.operation == DroidOperation.MOVE_TO) {
            this.jumpDelay = 0;
            this.setWantedPosition(x, y, z, speed);
            this.setOperation(DroidOperation.START_JUMP);
        }
    }

    private Optional<Double> getLandingTime() {
        return Physics.getLandingTime(-this.mob.getEffectiveGravity(), this.wantedY - this.mob.getY(), this.mob.getDeltaMovement().y());
    }

    private Optional<Double> getJumpLandingTime() {
        return Physics.getLandingTime(-this.mob.getEffectiveGravity(), this.wantedY - this.mob.getY(), this.mob.getAttributeValue(Attributes.JUMP_STRENGTH) + (double)this.mob.getJumpBoostPower());
    }

    protected boolean canJumpFluid() {
        return (double)this.mob.level().getFluidState(this.mob.blockPosition()).getHeight((BlockGetter)this.mob.level(), this.mob.blockPosition()) <= this.mob.getFluidJumpThreshold();
    }

    public boolean hasWanted() {
        return this.operation != DroidOperation.WAIT;
    }

    public void setWantedPosition(double x, double y, double z, double speed) {
        super.setWantedPosition(x, y, z, speed);
        if (this.operation == DroidOperation.WAIT) {
            this.setOperation(DroidOperation.MOVE_TO);
        }
    }

    protected static enum DroidOperation {
        WAIT,
        MOVE_TO,
        IN_AIR,
        START_JUMP,
        IN_FLUID;

    }
}

