/*
 * Decompiled with CFR 0.152.
 */
package hive.common.world.entities.ai;

import hive.common.world.Physics;
import hive.common.world.entities.ai.DroidNodeEvaluator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import org.jetbrains.annotations.Nullable;

public class DroidPathfinder
extends PathFinder {
    private static final int SIZE = DroidNodeEvaluator.getMinCacheSize(5, 1);
    private final boolean assumeSprinting;
    private final double speedFactor;
    private double ySpeed;
    private double xzSpeed;
    private double gravity;

    public DroidPathfinder(NodeEvaluator eval, int max, double speedFactor, boolean assumeSprinting) {
        super(eval, max);
        this.speedFactor = speedFactor;
        this.assumeSprinting = assumeSprinting;
        this.neighbors = new Node[SIZE];
    }

    public static boolean isJump(@Nullable Node prev, Node next) {
        return prev != null && (next.y > prev.y || Math.abs(prev.x - next.x) >= 2 || Math.abs(prev.z - next.z) >= 2);
    }

    @Nullable
    public Path findPath(PathNavigationRegion region, Mob mob, Set<BlockPos> targets, float maxDist, int reachedDist, float nodeFactor) {
        this.ySpeed = mob.getAttributeValue(Attributes.JUMP_STRENGTH) + (double)mob.getJumpBoostPower();
        this.gravity = -mob.getAttributeValue(Attributes.GRAVITY);
        this.xzSpeed = mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedFactor;
        if (this.assumeSprinting || mob.isSprinting()) {
            this.xzSpeed += 0.2;
        }
        return super.findPath(region, mob, targets, maxDist, reachedDist, nodeFactor);
    }

    protected float distance(Node n1, Node n2) {
        float dist = n1.distanceToXZ(n2);
        if (DroidPathfinder.isJump(n1, n2)) {
            return Physics.getLandingTime(this.gravity, n2.y - n1.y, this.ySpeed).map(t -> Float.valueOf((float)(t * this.xzSpeed))).orElseGet(() -> Float.valueOf(n1.distanceTo(n2))).floatValue();
        }
        if (n2.y < n1.y) {
            return Physics.getLandingTime(this.gravity, n2.y - n1.y, 0.0).map(t -> Float.valueOf((float)(t * this.xzSpeed))).orElseGet(() -> Float.valueOf(n1.distanceTo(n2))).floatValue();
        }
        return dist;
    }
}

