/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.gui;

import java.util.function.Predicate;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;

public class FiltersState
implements Predicate<PaintingData> {
    private final Predicate<PaintingData> canStay;
    private String search = "";
    private String nameSearch = "";
    private boolean nonEmptyNameOnly = false;
    private String artistSearch = "";
    private boolean nonEmptyArtistOnly = false;
    private boolean canStayOnly = false;
    private int minWidth = 1;
    private int maxWidth = 32;
    private int minHeight = 1;
    private int maxHeight = 32;

    public FiltersState(Predicate<PaintingData> predicate) {
        this.canStay = predicate;
    }

    @Override
    public boolean test(PaintingData paintingData) {
        if (this.canStayOnly && !this.canStay.test(paintingData)) {
            return false;
        }
        if (this.minWidth > paintingData.width() || this.maxWidth < paintingData.width() || this.minHeight > paintingData.height() || this.maxHeight < paintingData.height()) {
            return false;
        }
        if (this.nonEmptyNameOnly && paintingData.name().isBlank()) {
            return false;
        }
        if (this.nonEmptyArtistOnly && paintingData.artist().isBlank()) {
            return false;
        }
        String string = this.search.toLowerCase().replace(" ", "");
        String string2 = paintingData.name().toLowerCase().replace(" ", "");
        String string3 = paintingData.artist().toLowerCase().replace(" ", "");
        if (!(string.isEmpty() || string2.contains(string) || string3.contains(string))) {
            return false;
        }
        String string4 = this.nameSearch.toLowerCase().replace(" ", "");
        if (!string4.isEmpty() && !string2.contains(string4)) {
            return false;
        }
        String string5 = this.artistSearch.toLowerCase().replace(" ", "");
        return string5.isEmpty() || string3.contains(string5);
    }

    public boolean hasFilters() {
        return !this.search.isEmpty() || !this.nameSearch.isEmpty() || this.nonEmptyNameOnly || !this.artistSearch.isEmpty() || this.nonEmptyArtistOnly || this.canStayOnly || this.minWidth > 1 || this.maxWidth < 32 || this.minHeight > 1 || this.maxHeight < 32;
    }

    public String getSearch() {
        return this.search;
    }

    public String getNameSearch() {
        return this.nameSearch;
    }

    public boolean getNonEmptyNameOnly() {
        return this.nonEmptyNameOnly;
    }

    public String getArtistSearch() {
        return this.artistSearch;
    }

    public boolean getNonEmptyArtistOnly() {
        return this.nonEmptyArtistOnly;
    }

    public boolean getCanStayOnly() {
        return this.canStayOnly;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void reset() {
        this.search = "";
        this.nameSearch = "";
        this.nonEmptyNameOnly = false;
        this.artistSearch = "";
        this.nonEmptyArtistOnly = false;
        this.canStayOnly = false;
        this.minWidth = 1;
        this.maxWidth = 32;
        this.minHeight = 1;
        this.maxHeight = 32;
    }

    public void setSearch(String string) {
        this.search = string;
    }

    public void setNameSearch(String string) {
        this.nameSearch = string;
    }

    public void setNonEmptyNameOnly(boolean bl) {
        this.nonEmptyNameOnly = bl;
    }

    public void setArtistSearch(String string) {
        this.artistSearch = string;
    }

    public void setNonEmptyArtistOnly(boolean bl) {
        this.nonEmptyArtistOnly = bl;
    }

    public void setCanStayOnly(boolean bl) {
        this.canStayOnly = bl;
    }

    public void setMinWidth(int n) {
        this.minWidth = n;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = n;
    }

    public void setMinHeight(int n) {
        this.minHeight = n;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public void setExactWidth(int n) {
        this.minWidth = n;
        this.maxWidth = n;
    }

    public void setExactHeight(int n) {
        this.minHeight = n;
        this.maxHeight = n;
    }
}

