/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.gui.screen.PacksLoadedListener;
import me.roundaround.custompaintings.client.network.ClientNetworking;
import me.roundaround.custompaintings.client.registry.CacheManager;
import me.roundaround.custompaintings.client.registry.CacheRead;
import me.roundaround.custompaintings.client.registry.ImageChunkBuilder;
import me.roundaround.custompaintings.client.registry.ItemManager;
import me.roundaround.custompaintings.client.texture.BasicTextureSprite;
import me.roundaround.custompaintings.client.texture.LoadingSprite;
import me.roundaround.custompaintings.client.texture.VanillaIconSprite;
import me.roundaround.custompaintings.client.toast.CustomSystemToasts;
import me.roundaround.custompaintings.client.toast.DownloadProgressToast;
import me.roundaround.custompaintings.config.CustomPaintingsConfig;
import me.roundaround.custompaintings.config.CustomPaintingsPerWorldConfig;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.mixin.SpriteLoaderAccessor;
import me.roundaround.custompaintings.registry.CustomPaintingRegistry;
import me.roundaround.custompaintings.resource.PackIcons;
import me.roundaround.custompaintings.resource.ResourceUtil;
import me.roundaround.custompaintings.resource.file.FileUid;
import me.roundaround.custompaintings.resource.file.Image;
import me.roundaround.custompaintings.resource.file.Metadata;
import me.roundaround.custompaintings.resource.legacy.LegacyPackConverter;
import me.roundaround.custompaintings.roundalib.event.MinecraftClientEvents;
import me.roundaround.custompaintings.util.CustomId;
import me.roundaround.custompaintings.util.StringUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10725;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;

public class ClientPaintingRegistry
extends CustomPaintingRegistry {
    public static final class_2960 CUSTOM_PAINTING_TEXTURE_ID = class_2960.method_60655((String)"custompaintings", (String)"textures/atlas/paintings.png");
    private static final class_2960 PAINTING_BACK_ID = class_2960.method_60656((String)"back");
    private static final class_2960 BACK_TEXTURE_ID = class_2960.method_60656((String)"textures/painting/back.png");
    private static final class_2960 EARTH_TEXTURE_ID = class_2960.method_60656((String)"textures/painting/earth.png");
    private static ClientPaintingRegistry instance = null;
    private final class_310 client;
    private final ItemManager itemManager;
    private final class_1059 atlas;
    private final HashSet<CustomId> spriteIds = new HashSet();
    private final HashMap<CustomId, Image> cachedImages = new HashMap();
    private final HashSet<CustomId> neededImages = new HashSet();
    private final HashMap<CustomId, ImageChunkBuilder> imageBuilders = new HashMap();
    private final LinkedHashMap<CustomId, CompletableFuture<PaintingData>> pendingDataRequests = new LinkedHashMap();
    private final HashMap<CustomId, Boolean> finishedMigrations = new HashMap();
    private boolean atlasInitialized = false;
    private boolean packsReceived = false;
    private boolean cacheDirty = false;
    private long waitingForImagesTimer;
    private int imagesExpected;
    private int bytesExpected;
    private int imagesReceived;
    private int bytesReceived;

    private ClientPaintingRegistry(class_310 class_3103) {
        this.client = class_3103;
        this.itemManager = ItemManager.getInstance();
        this.atlas = new class_1059(CUSTOM_PAINTING_TEXTURE_ID);
        this.client.method_1531().method_4616(this.atlas.method_24106(), (class_1044)this.atlas);
        MinecraftClientEvents.CLOSE.register(class_3102 -> {
            if (class_3102 == this.client) {
                this.close();
            }
        });
    }

    public static ClientPaintingRegistry getInstance() {
        if (instance == null) {
            instance = new ClientPaintingRegistry(class_310.method_1551());
        }
        return instance;
    }

    @Override
    protected class_5455 getRegistryManager() {
        return this.client.field_1687 == null ? null : this.client.field_1687.method_30349();
    }

    @Override
    public void setPacks(HashMap<String, PackData> hashMap) {
        class_437 class_4372;
        super.setPacks(hashMap);
        CustomPaintingsMod.LOGGER.info("{} painting metadata entries loaded", (Object)this.paintings.size());
        this.packsReceived = true;
        this.pendingDataRequests.forEach((customId, completableFuture) -> completableFuture.complete(this.get((CustomId)customId)));
        this.pendingDataRequests.clear();
        this.clearUnknownMigrations();
        if (this.client != null && (class_4372 = this.client.field_1755) instanceof PacksLoadedListener) {
            PacksLoadedListener packsLoadedListener = (PacksLoadedListener)class_4372;
            packsLoadedListener.onPacksLoaded();
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.packsReceived = false;
        this.cacheDirty = false;
        this.atlas.method_4601();
        this.spriteIds.clear();
        this.neededImages.clear();
        this.cachedImages.clear();
        this.imageBuilders.clear();
        this.pendingDataRequests.forEach((customId, completableFuture) -> completableFuture.cancel(true));
        this.pendingDataRequests.clear();
        this.finishedMigrations.clear();
        this.imagesExpected = 0;
        this.bytesExpected = 0;
        this.imagesReceived = 0;
        this.bytesReceived = 0;
    }

    public class_2960 getAtlasId() {
        return this.atlas.method_24106();
    }

    public class_1058 getMissingSprite() {
        try {
            return this.atlas.method_4608(class_1047.method_4539());
        }
        catch (IllegalStateException illegalStateException) {
            if (!this.atlasInitialized) {
                this.buildSpriteAtlas();
                return this.getMissingSprite();
            }
            throw new RuntimeException(illegalStateException);
        }
    }

    public class_1058 getBackSprite() {
        return this.atlas.method_4608(PAINTING_BACK_ID);
    }

    public class_1058 getSprite(CustomId customId) {
        if (!this.spriteIds.contains(customId)) {
            return this.getMissingSprite();
        }
        return this.atlas.method_4608(customId.toIdentifier());
    }

    public class_1058 getSprite(PaintingData paintingData) {
        if (paintingData.isEmpty()) {
            return this.getBackSprite();
        }
        if (paintingData.vanilla()) {
            class_638 class_6383 = this.client.field_1687;
            if (class_6383 == null) {
                return this.getMissingSprite();
            }
            return this.client.method_72703().method_73025(class_10725.field_56388).method_4608(paintingData.id().toIdentifier());
        }
        return this.getSprite(paintingData.id());
    }

    public Map<CustomId, Boolean> getFinishedMigrations() {
        return Map.copyOf(this.finishedMigrations);
    }

    public void markMigrationFinished(CustomId customId, boolean bl) {
        this.finishedMigrations.put(customId, bl);
    }

    public void setFinishedMigrations(Map<CustomId, Boolean> map) {
        this.finishedMigrations.clear();
        this.finishedMigrations.putAll(map);
    }

    public void clearUnknownMigrations() {
        this.finishedMigrations.keySet().removeIf(customId -> !this.migrations.containsKey(customId));
    }

    public void processSummary(List<PackData> list, UUID uUID, String string, Map<CustomId, Boolean> map) {
        boolean bl = this.packsMap.isEmpty();
        if (bl) {
            this.checkAndPromptForLegacyPacks();
        }
        this.setPacks(list);
        this.setFinishedMigrations(map);
        this.initCacheAndSpriteAtlas(bl, uUID, string);
    }

    private void setPacks(List<PackData> list) {
        HashMap<String, PackData> hashMap = new HashMap<String, PackData>(list.size());
        list.forEach(packData -> hashMap.put(packData.id(), (PackData)packData));
        this.setPacks(hashMap);
    }

    private void checkAndPromptForLegacyPacks() {
        if (!this.client.method_1542() || ((Boolean)CustomPaintingsConfig.getInstance().silenceAllConvertPrompts.getValue()).booleanValue() || ((Boolean)CustomPaintingsPerWorldConfig.getInstance().silenceConvertPrompt.getValue()).booleanValue()) {
            return;
        }
        LegacyPackConverter.getInstance().checkForLegacyPacks(this.client).orTimeout(30L, TimeUnit.SECONDS).thenAcceptAsync(collection -> {
            if (this.client.field_1724 == null) {
                return;
            }
            HashSet hashSet = this.packsMap.values().stream().map(PackData::sourceLegacyPack).filter(optional -> optional.isPresent() && !((String)optional.get()).isBlank()).map(Optional::get).collect(Collectors.toCollection(HashSet::new));
            HashSet hashSet2 = collection.stream().map(Metadata::fileUid).map(FileUid::stringValue).collect(Collectors.toCollection(HashSet::new));
            hashSet2.removeAll(hashSet);
            if (!hashSet2.isEmpty()) {
                CustomSystemToasts.addLegacyPacksFound(this.client, hashSet2.size());
            }
        }, (Executor)this.client);
    }

    private void initCacheAndSpriteAtlas(boolean bl, UUID uUID, String string) {
        if (string.equals("$$")) {
            this.clear();
            this.buildSpriteAtlas();
            return;
        }
        if (this.isHashCorrectAndAllImagesPresent(string, this.images::containsKey)) {
            CustomPaintingsMod.LOGGER.info("All image info still valid, skipping re-fetching images");
            this.buildSpriteAtlas();
            return;
        }
        this.images.clear();
        this.cachedImages.clear();
        this.cacheDirty = false;
        this.combinedImageHash = string;
        if (!this.usingCache()) {
            CustomPaintingsMod.LOGGER.info("Not using cache, requesting all images from server");
            ClientNetworking.sendHashesPacket(new HashMap<CustomId, String>(0));
            this.buildSpriteAtlas();
            return;
        }
        if (bl) {
            CacheRead cacheRead = this.readCache(uUID);
            this.postCacheRead(cacheRead);
            return;
        }
        CompletableFuture.supplyAsync(() -> this.readCache(uUID), (Executor)class_156.method_27958()).thenAcceptAsync(this::postCacheRead, (Executor)this.client);
    }

    private CacheRead readCache(UUID uUID) {
        if (!this.usingCache()) {
            return null;
        }
        return CacheManager.getInstance().loadFromFile(uUID, ResourceUtil.getAllImageIds(this.packsMap.keySet(), this.paintings.keySet()));
    }

    private void postCacheRead(CacheRead cacheRead) {
        if (cacheRead == null) {
            CustomPaintingsMod.LOGGER.info("Cache was empty; requesting all images from server");
            this.cacheDirty = true;
            ClientNetworking.sendHashesPacket(Map.of());
        } else if (this.isHashCorrectAndAllImagesPresent(cacheRead.combinedHash(), cacheRead.images()::containsKey)) {
            CustomPaintingsMod.LOGGER.info("All images successfully pulled from cache; skipping server image download");
            this.images.clear();
            this.images.putAll(cacheRead.images());
        } else {
            CustomPaintingsMod.LOGGER.info("Requesting images from server");
            this.cacheDirty = true;
            this.cachedImages.putAll(cacheRead.images());
            ClientNetworking.sendHashesPacket(this.cachedImages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Image)entry.getValue()).hash())));
        }
        this.buildSpriteAtlas();
    }

    private boolean isHashCorrectAndAllImagesPresent(String string, Predicate<CustomId> predicate) {
        if (!Objects.equals(string, this.combinedImageHash)) {
            return false;
        }
        HashSet<CustomId> hashSet = ResourceUtil.getAllImageIds(this.packsMap.keySet(), this.paintings.keySet());
        return hashSet.stream().allMatch(predicate);
    }

    public void trackExpectedPackets(List<CustomId> list, int n, int n2) {
        if (list.isEmpty() || n2 == 0) {
            CustomPaintingsMod.LOGGER.info("Combined image hash is invalid, but all the individual images are fine. Rebuilding cache.");
            this.cacheDirty = true;
            this.cacheNewImages();
            this.buildSpriteAtlas();
            return;
        }
        CustomPaintingsMod.LOGGER.info("Expecting {} painting image(s) from server", (Object)list.size());
        this.waitingForImagesTimer = class_156.method_658();
        this.neededImages.clear();
        this.neededImages.addAll(list);
        this.imagesExpected = n;
        this.bytesExpected = n2;
        if (this.client.field_1724 != null && !this.client.method_1542()) {
            DownloadProgressToast.add(this.client.method_1566(), this.imagesExpected, this.bytesExpected);
        }
        this.copyInCachedImageData(Set.copyOf(list));
        this.buildSpriteAtlas();
    }

    public void setPaintingImage(CustomId customId, Image image) {
        ++this.imagesReceived;
        this.bytesReceived += image.getSize();
        DownloadProgressToast downloadProgressToast = DownloadProgressToast.get(this.client.method_1566());
        if (downloadProgressToast != null) {
            downloadProgressToast.setReceived(this.imagesReceived, this.bytesReceived);
        }
        this.setFull(customId, image);
    }

    public void setPaintingHeader(CustomId customId, int n, int n2, int n3) {
        this.setPart(customId, imageChunkBuilder -> imageChunkBuilder.set(n, n2, n3));
    }

    public void setPaintingChunk(CustomId customId, int n, byte[] byArray) {
        this.bytesReceived += byArray.length;
        DownloadProgressToast downloadProgressToast = DownloadProgressToast.get(this.client.method_1566());
        if (downloadProgressToast != null) {
            downloadProgressToast.setReceived(this.imagesReceived, this.bytesReceived);
        }
        this.setPart(customId, imageChunkBuilder -> imageChunkBuilder.set(n, byArray));
    }

    public CompletableFuture<PaintingData> safeGet(CustomId customId) {
        if (this.packsReceived) {
            return CompletableFuture.completedFuture(this.get(customId));
        }
        CompletableFuture<PaintingData> completableFuture = new CompletableFuture<PaintingData>();
        this.pendingDataRequests.put(customId, completableFuture);
        return completableFuture;
    }

    private void close() {
        this.clear();
    }

    private void setPart(CustomId customId2, Function<ImageChunkBuilder, Boolean> function) {
        ImageChunkBuilder imageChunkBuilder = this.imageBuilders.computeIfAbsent(customId2, customId -> new ImageChunkBuilder());
        if (function.apply(imageChunkBuilder).booleanValue()) {
            ++this.imagesReceived;
            DownloadProgressToast downloadProgressToast = DownloadProgressToast.get(this.client.method_1566());
            if (downloadProgressToast != null) {
                downloadProgressToast.setReceived(this.imagesReceived, this.bytesReceived);
            }
            this.setFull(customId2, imageChunkBuilder.generate());
            this.imageBuilders.remove(customId2);
        }
    }

    private void setFull(CustomId customId, Image image) {
        this.images.put(customId, image);
        this.cacheDirty = true;
        this.neededImages.remove(customId);
        if (!this.neededImages.isEmpty()) {
            return;
        }
        CustomPaintingsMod.LOGGER.info("All painting images received from server. Refreshing sprite atlas...");
        this.buildSpriteAtlas();
        this.cacheNewImages();
        CustomPaintingsMod.LOGGER.info("Painting images downloaded and sprite atlas refreshed in {}", (Object)StringUtil.formatDuration(class_156.method_658() - this.waitingForImagesTimer));
        this.imagesExpected = 0;
        this.bytesExpected = 0;
        this.imagesReceived = 0;
        this.bytesReceived = 0;
    }

    private void buildSpriteAtlas() {
        this.images.keySet().removeIf(customId -> !this.isValidImageId((CustomId)customId));
        ArrayList<class_7764> arrayList = new ArrayList<class_7764>();
        arrayList.add(class_1047.method_45805());
        arrayList.add(BasicTextureSprite.fetch(this.client, PAINTING_BACK_ID, BACK_TEXTURE_ID));
        arrayList.add(VanillaIconSprite.create(this.client, PackIcons.MINECRAFT_ICON_ID.toIdentifier(), "vanilla"));
        arrayList.add(BasicTextureSprite.fetch(this.client, PackIcons.MINECRAFT_HIDDEN_ICON_ID.toIdentifier(), EARTH_TEXTURE_ID));
        this.paintings.values().forEach(paintingData -> this.getSpriteContents((PaintingData)paintingData).ifPresent(arrayList::add));
        this.packsMap.keySet().forEach(string -> this.getSpriteContents((String)string).ifPresent(arrayList::add));
        this.atlas.method_45848(((SpriteLoaderAccessor)class_7766.method_45837((class_1059)this.atlas)).invokeStitch(arrayList, 0, (Executor)class_156.method_18349()));
        this.spriteIds.clear();
        this.spriteIds.addAll(arrayList.stream().map(class_7764::method_45816).map(CustomId::from).toList());
        long l = class_156.method_658();
        this.itemManager.build(this.paintings.values(), this.images::get);
        CustomPaintingsMod.LOGGER.info("Item manager build took {}", (Object)StringUtil.formatDuration(class_156.method_658() - l));
        this.atlasInitialized = true;
        class_437 class_4372 = this.client.field_1755;
        if (class_4372 instanceof PacksLoadedListener) {
            PacksLoadedListener packsLoadedListener = (PacksLoadedListener)class_4372;
            packsLoadedListener.onPackTexturesInitialized();
        }
    }

    private void copyInCachedImageData(Set<CustomId> set) {
        HashSet<CustomId> hashSet = new HashSet<CustomId>();
        hashSet.addAll(this.packsMap.keySet().stream().map(PackIcons::customId).toList());
        hashSet.addAll(this.paintings.keySet());
        hashSet.forEach(customId -> {
            if (set.contains(customId)) {
                this.cachedImages.remove(customId);
                return;
            }
            Image image = this.cachedImages.get(customId);
            if (image == null) {
                return;
            }
            this.images.put(customId, image);
        });
    }

    private void cacheNewImages() {
        if (!(this.usingCache() && this.neededImages.isEmpty() && this.cacheDirty)) {
            return;
        }
        HashMap hashMap = new HashMap(this.images);
        String string = this.combinedImageHash;
        CompletableFuture.supplyAsync(() -> {
            try {
                CacheManager.getInstance().saveToFile(hashMap, string);
                return true;
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn((Object)iOException);
                CustomPaintingsMod.LOGGER.warn("Failed to write images and metadata to cache.");
                return false;
            }
        }, (Executor)class_156.method_27958()).thenAcceptAsync(bl -> {
            if (bl.booleanValue()) {
                this.cacheDirty = false;
            }
        }, (Executor)this.client);
    }

    private boolean isValidImageId(CustomId customId) {
        return this.paintings.containsKey(customId) || customId.pack().equals("__icon") && this.packsMap.containsKey(customId.resource());
    }

    private Optional<class_7764> getSpriteContents(PaintingData paintingData) {
        return this.getSpriteContents(paintingData.id(), (Image)this.images.get(paintingData.id()), paintingData.getScaledWidth(), paintingData.getScaledHeight());
    }

    private Optional<class_7764> getSpriteContents(String string) {
        CustomId customId = PackIcons.customId(string);
        return this.getSpriteContents(customId, (Image)this.images.get(customId), 16, 16);
    }

    private Optional<class_7764> getSpriteContents(CustomId customId, Image image, int n, int n2) {
        if (image == null || image.isEmpty()) {
            if (this.neededImages.contains(customId)) {
                return Optional.of(LoadingSprite.generate(customId.toIdentifier(), n, n2));
            }
            return Optional.empty();
        }
        class_1011 class_10112 = image.toNativeImage();
        return Optional.of(new class_7764(customId.toIdentifier(), new class_7771(image.width(), image.height()), class_10112));
    }

    private boolean usingCache() {
        return (Boolean)CustomPaintingsConfig.getInstance().cacheImages.getValue() != false && !this.client.method_1542();
    }
}

