/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.client.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.client.render.model.ItemModelBaker;
import me.roundaround.custompaintings.client.texture.BasicTextureSprite;
import me.roundaround.custompaintings.config.CustomPaintingsConfig;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.mixin.BakedModelManagerAccessor;
import me.roundaround.custompaintings.mixin.SpriteLoaderAccessor;
import me.roundaround.custompaintings.resource.file.Image;
import me.roundaround.custompaintings.roundalib.event.MinecraftClientEvents;
import me.roundaround.custompaintings.roundalib.util.PathAccessor;
import me.roundaround.custompaintings.util.CustomId;
import net.minecraft.class_10096;
import net.minecraft.class_10097;
import net.minecraft.class_1011;
import net.minecraft.class_10410;
import net.minecraft.class_10434;
import net.minecraft.class_10439;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_10526;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10813;
import net.minecraft.class_10819;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4730;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_9826;
import org.jetbrains.annotations.Nullable;

public final class ItemManager {
    public static final class_2960 PAINTING_ITEM_TEXTURE_ID = class_2960.method_60655((String)"custompaintings", (String)"textures/atlas/items.png");
    private static final Image HOOK_IMAGE = ItemManager.generateItemHookImage();
    private static final class_2960 VANILLA_TEXTURE = class_2960.method_60656((String)"textures/item/painting.png");
    private static final class_2960 VANILLA_ID = class_2960.method_60655((String)"custompaintings", (String)"item/painting");
    private static ItemManager instance = null;
    private final class_310 client;
    private final class_1059 atlas;
    private final HashSet<CustomId> spriteIds = new HashSet();
    private final HashMap<CustomId, Image> generated = new HashMap();
    private final HashSet<CustomId> usesVanilla = new HashSet();
    private final ArrayList<PaintingData> paintings = new ArrayList();
    private final SpriteGetter spriteGetter = new SpriteGetter();
    private boolean atlasInitialized = false;
    private Function<CustomId, Image> baseImageSupplier = ItemManager::emptyBaseImageSupplier;
    private AtomicReference<CompletableFuture<Void>> buildFuture = new AtomicReference();

    private ItemManager(class_310 class_3103) {
        this.client = class_3103;
        this.atlas = new class_1059(PAINTING_ITEM_TEXTURE_ID);
        this.client.method_1531().method_4616(this.atlas.method_24106(), (class_1044)this.atlas);
        MinecraftClientEvents.CLOSE.register(class_3102 -> {
            if (class_3102 == this.client) {
                this.close();
            }
        });
    }

    public class_2960 getAtlasId() {
        return this.atlas.method_24106();
    }

    public class_1058 getMissingSprite() {
        try {
            return this.atlas.method_4608(class_1047.method_4539());
        }
        catch (IllegalStateException illegalStateException) {
            if (!this.atlasInitialized) {
                this.build();
                return this.getMissingSprite();
            }
            throw new RuntimeException(illegalStateException);
        }
    }

    public class_1058 getVanillaSprite() {
        try {
            return this.atlas.method_4608(VANILLA_ID);
        }
        catch (IllegalStateException illegalStateException) {
            if (!this.atlasInitialized) {
                this.build();
                return this.getVanillaSprite();
            }
            throw new RuntimeException(illegalStateException);
        }
    }

    public class_1058 getSprite(PaintingData paintingData) {
        return this.getSprite(paintingData.id());
    }

    public class_1058 getSprite(CustomId customId) {
        return this.getItemSprite(ItemManager.getItemId(customId));
    }

    public class_1058 getSprite(class_2960 class_29602) {
        return this.getItemSprite(CustomId.from(class_29602));
    }

    public void build(Collection<PaintingData> collection, Function<CustomId, Image> function) {
        this.paintings.clear();
        this.paintings.addAll(collection);
        this.baseImageSupplier = function;
        this.build();
    }

    public void rebuild() {
        this.build();
    }

    public void close() {
        CompletableFuture completableFuture = this.buildFuture.getAndSet(null);
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        this.atlas.method_4601();
        this.spriteIds.clear();
        this.generated.clear();
        this.paintings.clear();
        this.atlasInitialized = false;
        this.baseImageSupplier = ItemManager::emptyBaseImageSupplier;
    }

    private class_1058 getItemSprite(CustomId customId) {
        if (this.usesVanilla.contains(customId)) {
            return this.getVanillaSprite();
        }
        if (!this.spriteIds.contains(customId)) {
            CustomPaintingsMod.LOGGER.warn("Sprite not found for {}", (Object)customId);
            return this.getMissingSprite();
        }
        return this.atlas.method_4608(customId.toIdentifier());
    }

    private void build() {
        ArrayList<class_7764> arrayList = new ArrayList<class_7764>();
        arrayList.add(class_1047.method_45805());
        arrayList.add(BasicTextureSprite.fetch(this.client, VANILLA_ID, VANILLA_TEXTURE));
        HashSet hashSet = new HashSet();
        ArrayList arrayList2 = new ArrayList();
        CacheData cacheData = this.loadCacheData();
        long l = class_156.method_659();
        long l2 = l - ItemManager.getTtlMs();
        this.paintings.forEach(paintingData -> {
            CustomId customId = paintingData.id();
            CustomId customId2 = CustomId.from(ItemManager.getItemModelId(customId));
            Image image = this.generated.get(customId2);
            if (image != null) {
                this.getSpriteContents((PaintingData)paintingData, image).ifPresent(arrayList::add);
                return;
            }
            Image image2 = this.baseImageSupplier.apply(customId);
            if (ItemManager.isEmpty(image2)) {
                this.usesVanilla.add(customId2);
                return;
            }
            LoadResult loadResult = this.loadOrScheduleGeneration(cacheData, l2, (PaintingData)paintingData, image2);
            if (loadResult.sprite != null) {
                arrayList.add(loadResult.sprite);
            } else {
                this.usesVanilla.add(customId2);
            }
            if (loadResult.generateFuture != null) {
                arrayList2.add(loadResult.generateFuture);
            }
        });
        for (String string : hashSet) {
            CacheFile cacheFile = cacheData.hashes().get(string);
            if (cacheFile == null || cacheFile.isExpired(l2)) continue;
            cacheFile.setLastAccess(l);
        }
        this.saveCacheData(cacheData);
        this.atlas.method_45848(((SpriteLoaderAccessor)class_7766.method_45837((class_1059)this.atlas)).invokeStitch(arrayList, 0, (Executor)class_156.method_18349()));
        this.spriteIds.clear();
        this.spriteIds.addAll(arrayList.stream().map(class_7764::method_45816).map(CustomId::from).toList());
        this.bakeModels();
        this.atlasInitialized = true;
        if (arrayList2.isEmpty()) {
            return;
        }
        this.buildFuture.updateAndGet(completableFuture -> {
            if (completableFuture != null) {
                completableFuture.cancel(false);
            }
            return CompletableFuture.allOf((CompletableFuture[])arrayList2.toArray(CompletableFuture[]::new)).thenRunAsync(() -> this.onGenerationCompleted(arrayList2.stream().map(CompletableFuture::join).toList()), (Executor)this.client);
        });
    }

    private LoadResult loadOrScheduleGeneration(CacheData cacheData, long l, PaintingData paintingData, Image image) {
        Supplier<LoadResult> supplier = () -> new LoadResult(null, false, CompletableFuture.supplyAsync(() -> this.generateImage(paintingData, image), (Executor)class_156.method_18349()));
        if (!((Boolean)CustomPaintingsConfig.getInstance().cacheImages.getPendingValue()).booleanValue()) {
            return supplier.get();
        }
        String string = image.hash();
        CacheFile cacheFile = cacheData.hashes().get(string);
        if (cacheFile == null || cacheFile.isExpired(l)) {
            return supplier.get();
        }
        Image image2 = ItemManager.loadImage(ItemManager.getCacheDir(), cacheFile.hash());
        if (ItemManager.isEmpty(image2)) {
            return supplier.get();
        }
        return new LoadResult(this.getSpriteContents(paintingData, image2).orElse(null), true, null);
    }

    private void bakeModels() {
        HashMap<class_2960, class_1100> hashMap = new HashMap<class_2960, class_1100>();
        hashMap.put(class_2960.method_60656((String)"item/generated"), ItemManager.getGeneratedItemModel());
        HashMap<class_2960, class_10434> hashMap2 = new HashMap<class_2960, class_10434>();
        this.paintings.forEach(paintingData -> {
            class_2960 class_29602 = ItemManager.getItemModelId(paintingData.id());
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("parent", "minecraft:item/generated");
            JsonObject jsonObject2 = new JsonObject();
            jsonObject2.addProperty("layer0", class_29602.toString());
            jsonObject.add("textures", (JsonElement)jsonObject2);
            class_793 class_7932 = class_793.method_3437((Reader)new StringReader(jsonObject.toString()));
            hashMap.put(class_29602, (class_1100)class_7932);
            hashMap2.put(class_29602, new class_10434(class_10410.method_65481((class_2960)class_29602), class_10434.class_10543.field_55549));
        });
        class_10097 class_100972 = new class_10097(hashMap, class_10096.method_62629());
        class_100972.method_68024(class_801.field_55273, (class_1100)new class_801());
        hashMap2.forEach((class_29602, class_104342) -> class_100972.method_65744((class_10526)class_104342.comp_3385()));
        class_10819 class_108192 = class_100972.method_68022();
        Map map = class_100972.method_68028();
        ItemModelBaker itemModelBaker = new ItemModelBaker(hashMap2, map, class_108192);
        Map<class_2960, class_10439> map2 = itemModelBaker.bake(this.spriteGetter);
        BakedModelManagerAccessor bakedModelManagerAccessor = (BakedModelManagerAccessor)this.client.method_1554();
        HashMap<class_2960, class_10439> hashMap3 = new HashMap<class_2960, class_10439>(bakedModelManagerAccessor.getBakedItemModels());
        hashMap3.putAll(map2);
        bakedModelManagerAccessor.setBakedItemModels(hashMap3);
    }

    private void onGenerationCompleted(List<GeneratedImage> list) {
        CacheData cacheData = this.loadCacheData();
        long l = class_156.method_659();
        Path path = ItemManager.getCacheDir();
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to create cache directory", (Throwable)iOException);
            list.forEach(generatedImage -> {
                String string = generatedImage.baseHash();
                Image image = generatedImage.image();
                if (string == null || ItemManager.isEmpty(image)) {
                    return;
                }
                this.generated.put(generatedImage.paintingId(), generatedImage.image());
            });
            this.build();
            this.generated.clear();
            return;
        }
        list.forEach(generatedImage -> {
            String string = generatedImage.baseHash();
            Image image = generatedImage.image();
            if (string == null || ItemManager.isEmpty(image)) {
                return;
            }
            CustomId customId = ItemManager.getItemId(generatedImage.paintingId());
            String string2 = image.hash();
            this.generated.put(customId, image);
            cacheData.hashes().put(string, new CacheFile(string2, l));
            try {
                ImageIO.write((RenderedImage)image.toBufferedImage(), "png", path.resolve(string2 + ".png").toFile());
            }
            catch (IOException iOException) {
                CustomPaintingsMod.LOGGER.warn("Failed to save item image to cache: {}", (Object)string2, (Object)iOException);
            }
            this.usesVanilla.remove(customId);
        });
        this.saveCacheData(cacheData);
        this.build();
    }

    private GeneratedImage generateImage(PaintingData paintingData, Image image) {
        if (ItemManager.isEmpty(image)) {
            return new GeneratedImage(paintingData.id(), null, Image.empty());
        }
        int n = 9;
        int n2 = 13;
        int n3 = 8;
        int n4 = 12;
        int n5 = paintingData.width();
        int n6 = paintingData.height();
        float f = Math.min((float)n2 / (float)n5, (float)n4 / (float)n6);
        final int n7 = Math.max(n, class_3532.method_15375((float)((float)n5 * f)));
        final int n8 = Math.max(n3, class_3532.method_15375((float)((float)n6 * f)));
        final int n9 = class_3532.method_15386((float)((float)(16 - n7) / 2.0f));
        final int n10 = 2 + class_3532.method_15386((float)((float)(13 - n8) / 2.0f));
        Image image2 = image.apply(Image.Operation.scale(n7, n8, Image.Resampler.combine(0.2f, Image.Resampler.BILINEAR, Image.Resampler.NEAREST_NEIGHBOR_FRAME_PRESERVING)), Image.Operation.resize(16, 16), Image.Operation.translate(n9, n10), Image.Operation.embed(HOOK_IMAGE, 6, n10 - 3), new Image.Operation(){

            @Override
            public class_2561 getName() {
                return class_2561.method_30163((String)"Shadow");
            }

            @Override
            public Image.Hashless apply(Image.Hashless hashless) {
                Image.Color[] colorArray;
                int n = n9;
                int n2 = n + n7 - 1;
                ArrayList<Image.Color> arrayList = new ArrayList<Image.Color>();
                int n3 = n8 - 1 + n10;
                for (int i = n; i <= n2; ++i) {
                    colorArray = hashless.getPixel(i, n3);
                    if (!(colorArray.getAlphaFloat() > 0.5f)) continue;
                    arrayList.add(colorArray.removeAlpha());
                }
                Image.Color color = Image.Color.average(arrayList).darken(0.15f);
                colorArray = hashless.copyPixels();
                for (int i = n; i <= n2; ++i) {
                    colorArray[Image.getIndex((int)hashless.height(), (int)i, (int)(n3 + 1))] = color;
                }
                return new Image.Hashless(colorArray, hashless.width(), hashless.height());
            }
        });
        return new GeneratedImage(paintingData.id(), image.hash(), image2);
    }

    private Optional<class_7764> getSpriteContents(PaintingData paintingData, Image image) {
        return this.getSpriteContents(ItemManager.getItemId(paintingData.id()), image);
    }

    private Optional<class_7764> getSpriteContents(CustomId customId, Image image) {
        if (ItemManager.isEmpty(image)) {
            return Optional.empty();
        }
        class_1011 class_10112 = image.toNativeImage();
        return Optional.of(new class_7764(customId.toIdentifier(), new class_7771(image.width(), image.height()), class_10112));
    }

    private CacheData loadCacheData() {
        class_2487 class_24872;
        Path path = ItemManager.getDataFile(ItemManager.getCacheDir());
        if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            return CacheData.empty();
        }
        try {
            class_24872 = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to load cache data");
            return CacheData.empty();
        }
        return CacheData.fromNbt(class_24872);
    }

    private void saveCacheData(CacheData cacheData) {
        try {
            Path path = ItemManager.getCacheDir();
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            Path path2 = ItemManager.getDataFile(path);
            class_2507.method_30614((class_2487)cacheData.toNbt(), (Path)path2);
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to save item image cache data", (Throwable)iOException);
        }
    }

    public static ItemManager getInstance() {
        if (instance == null) {
            instance = new ItemManager(class_310.method_1551());
        }
        return instance;
    }

    public static class_2960 getItemModelId(CustomId customId) {
        return class_2960.method_60655((String)"custompaintings", (String)("item/" + customId.pack() + "/" + customId.resource()));
    }

    public static void runBackgroundClean() {
        CompletableFuture.runAsync(() -> {
            try {
                Path path = ItemManager.getDataFile(ItemManager.getCacheDir());
                if (Files.notExists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
                    return;
                }
                class_2487 class_24872 = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                CacheData cacheData = CacheData.fromNbt(class_24872);
                ItemManager.trimExpired(cacheData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, (Executor)class_156.method_27958());
    }

    private static CustomId getItemId(CustomId customId) {
        return CustomId.from(ItemManager.getItemModelId(customId));
    }

    private static Image generateItemHookImage() {
        Image.Color[] colorArray = new Image.Color[15];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = Image.Color.transparent();
        }
        colorArray[Image.getIndex((int)3, (int)2, (int)0)] = new Image.Color(99, 99, 99, 255);
        colorArray[Image.getIndex((int)3, (int)1, (int)1)] = new Image.Color(99, 99, 99, 255);
        colorArray[Image.getIndex((int)3, (int)2, (int)1)] = new Image.Color(53, 53, 53, 255);
        colorArray[Image.getIndex((int)3, (int)3, (int)1)] = new Image.Color(53, 53, 53, 255);
        colorArray[Image.getIndex((int)3, (int)0, (int)2)] = new Image.Color(53, 53, 53, 255);
        colorArray[Image.getIndex((int)3, (int)1, (int)2)] = new Image.Color(53, 53, 53, 255);
        colorArray[Image.getIndex((int)3, (int)3, (int)2)] = new Image.Color(38, 38, 38, 255);
        colorArray[Image.getIndex((int)3, (int)4, (int)2)] = new Image.Color(53, 53, 53, 255);
        return Image.fromPixels(colorArray, 5, 3);
    }

    private static class_1100 getGeneratedItemModel() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("parent", "builtin/generated");
        jsonObject.addProperty("gui_light", "front");
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("ground", (JsonElement)ItemManager.genDisplayJsonObject(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.5f, 0.5f, 0.5f));
        jsonObject2.add("head", (JsonElement)ItemManager.genDisplayJsonObject(0.0f, 180.0f, 0.0f, 0.0f, 13.0f, 7.0f, 1.0f, 1.0f, 1.0f));
        jsonObject2.add("thirdperson_righthand", (JsonElement)ItemManager.genDisplayJsonObject(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.55f, 0.55f, 0.55f));
        jsonObject2.add("firstperson_righthand", (JsonElement)ItemManager.genDisplayJsonObject(0.0f, -90.0f, 25.0f, 1.13f, 3.2f, 1.13f, 0.68f, 0.68f, 0.68f));
        jsonObject2.add("fixed", (JsonElement)ItemManager.genDisplayJsonObject(0.0f, 180.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f));
        jsonObject.add("display", (JsonElement)jsonObject2);
        return class_793.method_3437((Reader)new StringReader(jsonObject.toString()));
    }

    private static JsonObject genDisplayJsonObject(float ... fArray) {
        if (fArray.length != 9) {
            throw new IllegalArgumentException("Values must contain 9 values");
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Number)Float.valueOf(fArray[0]));
        jsonArray.add((Number)Float.valueOf(fArray[1]));
        jsonArray.add((Number)Float.valueOf(fArray[2]));
        JsonArray jsonArray2 = new JsonArray();
        jsonArray2.add((Number)Float.valueOf(fArray[3]));
        jsonArray2.add((Number)Float.valueOf(fArray[4]));
        jsonArray2.add((Number)Float.valueOf(fArray[5]));
        JsonArray jsonArray3 = new JsonArray();
        jsonArray3.add((Number)Float.valueOf(fArray[6]));
        jsonArray3.add((Number)Float.valueOf(fArray[7]));
        jsonArray3.add((Number)Float.valueOf(fArray[8]));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("rotation", (JsonElement)jsonArray);
        jsonObject.add("translation", (JsonElement)jsonArray2);
        jsonObject.add("scale", (JsonElement)jsonArray3);
        return jsonObject;
    }

    private static Path getCacheDir() {
        return PathAccessor.getInstance().getGameDir().resolve("data").resolve("custompaintings").resolve("cache").resolve("items");
    }

    private static Path getDataFile(Path path) {
        return path.resolve("data.dat");
    }

    private static void deleteImage(Path path, String string) throws IOException {
        Path path2 = path.resolve(string + ".png");
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isRegularFile(path2, new LinkOption[0])) {
            return;
        }
        Files.delete(path2);
    }

    private static Image loadImage(Path path, String string) {
        Path path2 = path.resolve(string + ".png");
        if (Files.notExists(path2, new LinkOption[0]) || !Files.isRegularFile(path2, new LinkOption[0])) {
            return Image.empty();
        }
        try {
            return Image.read(Files.newInputStream(path2, new OpenOption[0]));
        }
        catch (IOException iOException) {
            return Image.empty();
        }
    }

    private static long getTtlMs() {
        return 86400000L * (long)((Integer)CustomPaintingsConfig.getInstance().cacheTtl.getValue()).intValue();
    }

    private static void trimExpired(CacheData cacheData) {
        Path path = ItemManager.getCacheDir();
        long l = class_156.method_659();
        long l2 = ItemManager.getTtlMs();
        long l3 = l - l2;
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Path path2 = ItemManager.getDataFile(path);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            directoryStream.forEach(path3 -> {
                if (path3.equals(path2)) {
                    return;
                }
                String string = path3.getFileName().toString();
                if (!string.toLowerCase().endsWith(".png")) {
                    return;
                }
                String string2 = string.substring(0, string.length() - 4);
                CacheFile cacheFile = cacheData.hashes().get(string2);
                if (cacheFile == null || cacheFile.lastAccess() < l3) {
                    try {
                        ItemManager.deleteImage(path, string2);
                        cacheData.hashes().remove(string2);
                    }
                    catch (IOException iOException) {
                        CustomPaintingsMod.LOGGER.warn(String.format("Failed to delete stale cached item image %s.png", string2), (Throwable)iOException);
                    }
                    return;
                }
            });
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to access item image cache directory for cleaning", (Throwable)iOException);
            return;
        }
        try {
            class_2507.method_30614((class_2487)cacheData.toNbt(), (Path)path2);
        }
        catch (IOException iOException) {
            CustomPaintingsMod.LOGGER.warn("Failed to write trimmed item iamge cache data file", (Throwable)iOException);
        }
    }

    private static boolean isEmpty(Image image) {
        return image == null || image.isEmpty();
    }

    private static Image emptyBaseImageSupplier(CustomId customId) {
        return Image.empty();
    }

    private class SpriteGetter
    implements class_9826 {
        private SpriteGetter() {
        }

        public class_1058 method_65739(class_4730 class_47302, class_10813 class_108132) {
            return ItemManager.this.getSprite(class_47302.method_24147());
        }

        public class_1058 method_65740(String string, class_10813 class_108132) {
            return ItemManager.this.getMissingSprite();
        }
    }

    private record CacheData(int version, HashMap<String, CacheFile> hashes) {
        public static final String NBT_VERSION = "Version";
        public static final String NBT_HASHES = "Hashes";
        public static final Codec<CacheData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf(NBT_VERSION).forGetter(CacheData::version), (App)Codec.unboundedMap((Codec)Codec.STRING, CacheFile.CODEC).xmap(HashMap::new, Function.identity()).fieldOf(NBT_HASHES).forGetter(CacheData::hashes)).apply((Applicative)instance, CacheData::new));

        public static CacheData empty() {
            return new CacheData(1, new HashMap<String, CacheFile>());
        }

        public static CacheData fromNbt(class_2487 class_24872) {
            try {
                return (CacheData)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)class_24872).getPartialOrThrow();
            }
            catch (Exception exception) {
                return CacheData.empty();
            }
        }

        public class_2487 toNbt() {
            return (class_2487)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow();
        }
    }

    private static final class CacheFile {
        public static final String NBT_HASH = "Hash";
        public static final String NBT_LAST_ACCESS = "LastAccess";
        public static final Codec<CacheFile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(NBT_HASH).forGetter(CacheFile::hash), (App)Codec.LONG.fieldOf(NBT_LAST_ACCESS).forGetter(CacheFile::lastAccess)).apply((Applicative)instance, CacheFile::new));
        private final String hash;
        private long lastAccess;

        private CacheFile(String string, long l) {
            this.hash = string;
            this.lastAccess = l;
        }

        public String hash() {
            return this.hash;
        }

        public long lastAccess() {
            return this.lastAccess;
        }

        public void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public boolean isExpired(long l) {
            return this.lastAccess <= l;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            CacheFile cacheFile = (CacheFile)object;
            return Objects.equals(this.hash, cacheFile.hash) && this.lastAccess == cacheFile.lastAccess;
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.lastAccess);
        }
    }

    private record LoadResult(@Nullable class_7764 sprite, boolean loadedFromCache, @Nullable CompletableFuture<GeneratedImage> generateFuture) {
    }

    private record GeneratedImage(CustomId paintingId, String baseHash, Image image) {
    }
}

