/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.roundaround.custompaintings.entity.decoration.painting.MigrationData;
import me.roundaround.custompaintings.entity.decoration.painting.PackData;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.resource.file.Image;
import me.roundaround.custompaintings.util.CustomId;
import net.minecraft.class_1535;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7406;
import net.minecraft.class_7924;

public abstract class CustomPaintingRegistry {
    protected final LinkedHashMap<String, PackData> packsMap = new LinkedHashMap();
    protected final ArrayList<PackData> packsList = new ArrayList();
    protected final HashMap<CustomId, PaintingData> paintings = new HashMap();
    protected final HashMap<CustomId, MigrationData> migrations = new HashMap();
    protected final HashMap<CustomId, Image> images = new HashMap();
    protected String combinedImageHash = "$$";

    protected abstract class_5455 getRegistryManager();

    public boolean contains(CustomId customId) {
        PaintingData paintingData = this.get(customId);
        return paintingData != null && !paintingData.isEmpty();
    }

    public PaintingData get(CustomId customId) {
        if (customId == null) {
            return PaintingData.EMPTY;
        }
        if (customId.pack().equals("minecraft")) {
            class_1535 class_15352 = this.getVanillaVariant(customId);
            if (class_15352 == null) {
                return PaintingData.EMPTY;
            }
            return new PaintingData(class_15352);
        }
        return this.paintings.get(customId);
    }

    public MigrationData getMigration(CustomId customId) {
        if (customId == null) {
            return null;
        }
        return this.migrations.get(customId);
    }

    public Map<String, PackData> getPacks() {
        return Map.copyOf(this.packsMap);
    }

    public List<PackData> getAllPacks() {
        return List.copyOf(this.packsList);
    }

    public List<PackData> getActivePacks() {
        return this.packsList.stream().filter(packData -> !packData.disabled()).toList();
    }

    public List<PackData> getInactivePacks() {
        return this.packsList.stream().filter(PackData::disabled).toList();
    }

    public Map<CustomId, MigrationData> getMigrations() {
        return Map.copyOf(this.migrations);
    }

    public void clear() {
        this.packsMap.clear();
        this.packsList.clear();
        this.paintings.clear();
        this.migrations.clear();
        this.images.clear();
        this.combinedImageHash = "$$";
    }

    public void setPacks(HashMap<String, PackData> hashMap) {
        this.packsMap.clear();
        this.packsList.clear();
        this.paintings.clear();
        this.migrations.clear();
        this.packsMap.putAll(hashMap);
        this.packsMap.forEach((string, packData) -> {
            this.packsList.add((PackData)packData);
            if (packData.disabled()) {
                return;
            }
            packData.paintings().forEach(paintingData -> this.paintings.put(paintingData.id(), (PaintingData)paintingData));
            packData.migrations().forEach(migrationData -> this.migrations.put(migrationData.id(), (MigrationData)migrationData));
        });
    }

    public List<PaintingData> getAllVanilla() {
        class_5455 class_54552 = this.getRegistryManager();
        if (class_54552 == null) {
            return List.of();
        }
        return class_54552.method_30530(class_7924.field_41209).method_42017().filter(class_68832 -> class_68832.method_40220(class_7406.field_38929)).map(class_6880.class_6883::comp_349).map(PaintingData::new).toList();
    }

    public List<PaintingData> getAllVanillaUnplaceable() {
        class_5455 class_54552 = this.getRegistryManager();
        if (class_54552 == null) {
            return List.of();
        }
        return class_54552.method_30530(class_7924.field_41209).method_42017().filter(class_68832 -> !class_68832.method_40220(class_7406.field_38929)).map(class_6880.class_6883::comp_349).map(PaintingData::new).toList();
    }

    protected class_1535 getVanillaVariant(CustomId customId) {
        class_5455 class_54552 = this.getRegistryManager();
        if (class_54552 == null) {
            return null;
        }
        return (class_1535)class_54552.method_30530(class_7924.field_41209).method_63535(customId.toIdentifier());
    }
}

