/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.resource.file;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.roundaround.custompaintings.CustomPaintingsMod;
import me.roundaround.custompaintings.resource.ResourceUtil;
import me.roundaround.custompaintings.resource.file.FileUid;
import me.roundaround.custompaintings.resource.file.Image;
import me.roundaround.custompaintings.resource.file.Metadata;
import me.roundaround.custompaintings.resource.file.Pack;
import me.roundaround.custompaintings.resource.file.Painting;
import me.roundaround.custompaintings.resource.file.accessor.DirectoryAccessor;
import me.roundaround.custompaintings.resource.file.accessor.FileAccessor;
import me.roundaround.custompaintings.resource.file.accessor.ZipAccessor;
import me.roundaround.custompaintings.resource.file.json.CustomPaintingsJson;
import me.roundaround.custompaintings.resource.file.json.LegacyCustomPaintingsJson;
import me.roundaround.custompaintings.resource.file.json.PackMcmeta;
import me.roundaround.custompaintings.util.CustomId;

public final class PackReader {
    private static final String CUSTOMPAINTINGS_JSON = "custompaintings.json";
    private static final String CUSTOM_PAINTINGS_JSON = "custom_paintings.json";
    private static final String PACK_MCMETA = "pack.mcmeta";
    private static final String PACK_PNG = "pack.png";
    private static final String ICON_PNG = "icon.png";
    private static final String LOG_NO_META = "Skipping potential pack \"%s\" with no %s file";
    private static final String LOG_META_PARSE_FAIL = "Skipping potential pack \"%s\" after failing to parse %s";
    private static final String LOG_MCMETA_PARSE_FAIL = "Failed to parse %s file for %s";
    private static final String LOG_NO_PAINTINGS = "Skipping potential pack \"%s\" because it contained no paintings";
    private static final String LOG_NO_ICON = "Missing %s file for pack \"%s\"";
    private static final String LOG_ICON_READ_FAIL = "Failed to read %s file for %s";

    public static Metadata readMetadata(Path path) {
        Metadata metadata;
        block8: {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            FileAccessor fileAccessor = basicFileAttributes.isDirectory() ? new DirectoryAccessor(path) : new ZipAccessor(path);
            try {
                metadata = PackReader.readMetadata(fileAccessor);
                if (fileAccessor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileAccessor != null) {
                        try {
                            fileAccessor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    CustomPaintingsMod.LOGGER.warn((Object)exception);
                    CustomPaintingsMod.LOGGER.warn("Error reading Custom Paintings pack \"{}\", skipping...", (Object)path.getFileName());
                    return null;
                }
            }
            fileAccessor.close();
        }
        return metadata;
    }

    public static HashMap<CustomId, Image> readPaintingImages(Metadata metadata) {
        HashMap<CustomId, Image> hashMap;
        block8: {
            Path path = metadata.path();
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            FileAccessor fileAccessor = basicFileAttributes.isDirectory() ? new DirectoryAccessor(path) : new ZipAccessor(path);
            try {
                hashMap = PackReader.readPaintingImages(fileAccessor, metadata);
                if (fileAccessor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileAccessor != null) {
                        try {
                            fileAccessor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    CustomPaintingsMod.LOGGER.warn((Object)exception);
                    CustomPaintingsMod.LOGGER.warn("Error reading Custom Paintings pack \"{}\", skipping...", (Object)path.getFileName());
                    return new HashMap<CustomId, Image>();
                }
            }
            fileAccessor.close();
        }
        return hashMap;
    }

    private static Metadata readMetadata(FileAccessor fileAccessor) {
        String string = CUSTOMPAINTINGS_JSON;
        if (!fileAccessor.hasFile(string)) {
            string = CUSTOM_PAINTINGS_JSON;
        }
        if (!fileAccessor.hasFile(string)) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_NO_META, fileAccessor.getFileName(), CUSTOMPAINTINGS_JSON));
            return null;
        }
        boolean bl = fileAccessor.hasFile(PACK_MCMETA);
        Pack pack = bl ? PackReader.readLegacyPack(fileAccessor, string) : PackReader.readPack(fileAccessor, string);
        return new Metadata(fileAccessor.getPath(), PackReader.generateFileUid(fileAccessor), pack, PackReader.readIcon(fileAccessor), bl);
    }

    private static Pack readPack(FileAccessor fileAccessor, String string) {
        CustomPaintingsJson customPaintingsJson = null;
        try (BufferedReader bufferedReader = fileAccessor.getBufferedReader(string);){
            customPaintingsJson = (CustomPaintingsJson)CustomPaintingsMod.GSON.fromJson((Reader)bufferedReader, CustomPaintingsJson.class);
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_META_PARSE_FAIL, fileAccessor.getFileName(), string), (Throwable)exception);
            return null;
        }
        if (customPaintingsJson.paintings().isEmpty()) {
            CustomPaintingsMod.LOGGER.warn(LOG_NO_PAINTINGS, (Object)fileAccessor.getFileName());
            return null;
        }
        return new Pack(customPaintingsJson.format(), customPaintingsJson.id(), customPaintingsJson.name(), customPaintingsJson.description(), customPaintingsJson.sourceLegacyPack(), customPaintingsJson.paintings(), customPaintingsJson.migrations());
    }

    private static Pack readLegacyPack(FileAccessor fileAccessor, String string) {
        Object object;
        LegacyCustomPaintingsJson legacyCustomPaintingsJson = null;
        try {
            object = fileAccessor.getBufferedReader(string);
            try {
                legacyCustomPaintingsJson = (LegacyCustomPaintingsJson)CustomPaintingsMod.GSON.fromJson((Reader)object, LegacyCustomPaintingsJson.class);
            }
            finally {
                if (object != null) {
                    ((BufferedReader)object).close();
                }
            }
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_META_PARSE_FAIL, fileAccessor.getFileName(), string), (Throwable)exception);
            return null;
        }
        if (legacyCustomPaintingsJson.paintings().isEmpty()) {
            CustomPaintingsMod.LOGGER.warn(LOG_NO_PAINTINGS, (Object)fileAccessor.getFileName());
            return null;
        }
        object = null;
        try (BufferedReader bufferedReader = fileAccessor.getBufferedReader(PACK_MCMETA);){
            object = (PackMcmeta)CustomPaintingsMod.GSON.fromJson((Reader)bufferedReader, PackMcmeta.class);
        }
        catch (Exception exception) {
            CustomPaintingsMod.LOGGER.warn(String.format(LOG_MCMETA_PARSE_FAIL, fileAccessor.getFileName(), PACK_MCMETA), (Throwable)exception);
        }
        return new Pack(legacyCustomPaintingsJson.id(), legacyCustomPaintingsJson.name(), object == null ? "" : ((PackMcmeta)object).pack().description(), legacyCustomPaintingsJson.paintings(), legacyCustomPaintingsJson.migrations());
    }

    private static FileUid generateFileUid(FileAccessor fileAccessor) {
        String string = fileAccessor.getFileName();
        long l = ResourceUtil.lastModified(fileAccessor.getPath());
        long l2 = ResourceUtil.fileSize(fileAccessor.getPath());
        return new FileUid(fileAccessor.isZip(), string, l, l2);
    }

    private static Image readIcon(FileAccessor fileAccessor) {
        String string = PACK_PNG;
        if (!fileAccessor.hasFile(string)) {
            string = ICON_PNG;
        }
        if (fileAccessor.hasFile(string)) {
            Image image;
            block10: {
                InputStream inputStream = fileAccessor.getInputStream(string);
                try {
                    image = Image.read(inputStream);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        CustomPaintingsMod.LOGGER.warn(String.format(LOG_ICON_READ_FAIL, string, fileAccessor.getFileName()), (Throwable)exception);
                    }
                }
                inputStream.close();
            }
            return image;
        }
        CustomPaintingsMod.LOGGER.warn(String.format(LOG_NO_ICON, PACK_PNG, fileAccessor.getFileName()));
        return null;
    }

    private static HashMap<CustomId, Image> readPaintingImages(FileAccessor fileAccessor, Metadata metadata) {
        HashMap<CustomId, Image> hashMap = new HashMap<CustomId, Image>();
        String string = metadata.pack().id();
        List<Painting> list = metadata.pack().paintings();
        for (Painting painting : list) {
            Image image = PackReader.readImage(fileAccessor, PackReader.getPaintingPath(fileAccessor, string, painting.id(), metadata.isLegacy()));
            if (image == null) continue;
            hashMap.put(new CustomId(string, painting.id()), image);
        }
        return hashMap;
    }

    private static String getPaintingPath(FileAccessor fileAccessor, String string, String string2, boolean bl) {
        ArrayList<CallSite> arrayList = bl ? new ArrayList<CallSite>(List.of("assets", string, "textures", "painting", string2 + ".png")) : new ArrayList<CallSite>(List.of("images", string2 + ".png"));
        return String.join((CharSequence)fileAccessor.getPathSeparator(), arrayList);
    }

    private static Image readImage(FileAccessor fileAccessor, String string) {
        Image image;
        block9: {
            if (!fileAccessor.hasFile(string)) {
                CustomPaintingsMod.LOGGER.warn("Missing painting image file for \"{}\"", (Object)string);
                return null;
            }
            InputStream inputStream = fileAccessor.getInputStream(string);
            try {
                image = Image.read(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    CustomPaintingsMod.LOGGER.warn("Failed to read painting image file for \"{}\"", (Object)string, (Object)exception);
                    return null;
                }
            }
            inputStream.close();
        }
        return image;
    }

    private PackReader() {
    }
}

