/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.roundaround.custompaintings.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.custompaintings.roundalib.client.gui.layout.NonPositioningLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.custompaintings.roundalib.client.gui.screen.ConfigScreen;
import me.roundaround.custompaintings.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.custompaintings.roundalib.client.gui.widget.drawable.LabelWidget;
import me.roundaround.custompaintings.roundalib.config.option.ConfigOption;
import me.roundaround.custompaintings.roundalib.observable.Subject;
import me.roundaround.custompaintings.roundalib.observable.Subscription;
import net.minecraft.class_11906;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;

public abstract class ConfigOptionSubScreen<D, O extends ConfigOption<D>>
extends class_437 {
    protected final ConfigScreen parent;
    protected final O option;
    protected final String modId;
    protected final class_2561 helpShortText;
    protected final class_2561 helpCloseText;
    protected final class_2561 helpResetText;
    protected Subject<Boolean> shiftState;
    protected final NonPositioningLayoutWidget nonPositioningRoot = new NonPositioningLayoutWidget();
    protected final List<Subscription> subscriptions = new ArrayList<Subscription>();
    protected LabelWidget titleLabel;
    protected LabelWidget helpLabel;
    protected LinearLayoutWidget actionRow;

    protected ConfigOptionSubScreen(class_2561 class_25612, ConfigScreen configScreen, O o) {
        super(class_25612);
        this.parent = configScreen;
        this.option = o;
        this.modId = ((ConfigOption)o).getModId();
        this.helpShortText = class_2561.method_43471((String)(this.modId + ".roundalib.help.short"));
        this.helpCloseText = class_2561.method_43471((String)(this.modId + ".roundalib.help.close"));
        this.helpResetText = class_11906.field_62586 ? class_2561.method_43471((String)(this.modId + ".roundalib.help.reset.mac")) : class_2561.method_43471((String)(this.modId + ".roundalib.help.reset.win"));
        this.shiftState = Subject.of(false);
    }

    protected void method_25426() {
        this.initElements();
        this.nonPositioningRoot.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
        this.method_48640();
    }

    protected void initElements() {
        this.titleLabel = this.createTitleLabel();
        this.placeTitleLabel(this.titleLabel);
        this.helpLabel = this.createHelpLabel();
        this.placeHelpLabel(this.helpLabel);
        this.actionRow = this.createActionRow();
        this.placeActionRow(this.actionRow);
    }

    protected void method_48640() {
        this.nonPositioningRoot.setPositionAndDimensions(0, 0, this.field_22789, this.field_22790);
        this.nonPositioningRoot.method_48222();
    }

    public void method_25419() {
        this.subscriptions.forEach(Subscription::close);
        this.subscriptions.clear();
        Objects.requireNonNull(this.field_22787).method_1507((class_437)this.parent.copy());
    }

    public boolean method_25404(class_11908 class_119082) {
        this.shiftState.set(class_119082.method_74239());
        if (class_119082.method_74228() == 82 && class_119082.method_74240()) {
            this.resetToDefault();
            return true;
        }
        return super.method_25404(class_119082);
    }

    public boolean method_16803(class_11908 class_119082) {
        this.shiftState.set(class_119082.method_74239());
        return super.method_16803(class_119082);
    }

    protected List<class_2561> getCurrentHelp() {
        return this.getCurrentHelp((Boolean)this.shiftState.get());
    }

    protected List<class_2561> getCurrentHelp(boolean bl) {
        return (Boolean)this.shiftState.get() != false ? this.getHelpLong() : this.getHelpShort();
    }

    protected List<class_2561> getHelpShort() {
        return List.of(this.helpShortText);
    }

    protected List<class_2561> getHelpLong() {
        return List.of(this.helpCloseText, this.helpResetText);
    }

    protected O getOption() {
        return this.option;
    }

    protected void setValue(D d) {
        ((ConfigOption)this.getOption()).setValue(d);
    }

    protected D getValue() {
        return ((ConfigOption)this.getOption()).getPendingValue();
    }

    protected String getValueAsString() {
        return ((ConfigOption)this.getOption()).getPendingValueAsString();
    }

    protected void resetToDefault() {
        ((ConfigOption)this.getOption()).setDefault();
    }

    protected boolean isDirty() {
        return ((ConfigOption)this.getOption()).isDirty();
    }

    protected LabelWidget createTitleLabel() {
        return this.createTitleLabel(this.method_25440());
    }

    protected LabelWidget createTitleLabel(class_2561 class_25612) {
        return LabelWidget.builder(this.field_22793, class_25612).alignTextCenterX().alignTextCenterY().overflowBehavior(LabelWidget.OverflowBehavior.SCROLL).hideBackground().showShadow().build();
    }

    protected void placeTitleLabel(LabelWidget labelWidget2) {
        this.nonPositioningRoot.add(labelWidget2, (nonPositioningLayoutWidget, labelWidget) -> labelWidget.method_55444(nonPositioningLayoutWidget.method_25368(), 33, nonPositioningLayoutWidget.method_46426(), nonPositioningLayoutWidget.method_46427()));
    }

    protected LabelWidget createHelpLabel() {
        LabelWidget labelWidget = LabelWidget.builder(this.field_22793, this.getCurrentHelp()).alignTextLeft().alignTextBottom().lineSpacing(2).hideBackground().showShadow().build();
        this.subscriptions.add(this.shiftState.subscribe(bl -> labelWidget.setText(this.getCurrentHelp((boolean)bl))));
        return labelWidget;
    }

    protected void placeHelpLabel(LabelWidget labelWidget2) {
        this.nonPositioningRoot.add(labelWidget2, (nonPositioningLayoutWidget, labelWidget) -> labelWidget.method_55444(nonPositioningLayoutWidget.method_25368() - 8, nonPositioningLayoutWidget.method_25364() - 8, nonPositioningLayoutWidget.method_46426() + 4, nonPositioningLayoutWidget.method_46427() + 4));
    }

    protected LinearLayoutWidget createActionRow() {
        LinearLayoutWidget linearLayoutWidget = LinearLayoutWidget.horizontal().spacing(4).defaultOffAxisContentAlignCenter();
        linearLayoutWidget.add(this.createBackButton());
        linearLayoutWidget.add(this.createResetButton());
        return linearLayoutWidget;
    }

    protected IconButtonWidget createBackButton() {
        return IconButtonWidget.builder(BuiltinIcon.BACK_18, this.modId).onPress(class_41852 -> this.method_25419()).messageAndTooltip((class_2561)class_2561.method_43471((String)(this.modId + ".roundalib.back.tooltip"))).build();
    }

    protected IconButtonWidget createResetButton() {
        IconButtonWidget iconButtonWidget = IconButtonWidget.builder(BuiltinIcon.UNDO_18, this.modId).onPress(class_41852 -> this.resetToDefault()).messageAndTooltip((class_2561)class_2561.method_43471((String)(this.modId + ".roundalib.reset.tooltip"))).build();
        this.subscriptions.add(((ConfigOption)this.getOption()).isPendingDefault.subscribe(bl -> {
            iconButtonWidget.field_22763 = bl == false;
        }));
        return iconButtonWidget;
    }

    protected void placeActionRow(LinearLayoutWidget linearLayoutWidget2) {
        this.nonPositioningRoot.add(linearLayoutWidget2.alignSelfRight().alignSelfBottom(), (nonPositioningLayoutWidget, linearLayoutWidget) -> linearLayoutWidget.method_48229(nonPositioningLayoutWidget.method_46426() + nonPositioningLayoutWidget.method_25368() - 4, nonPositioningLayoutWidget.method_46427() + nonPositioningLayoutWidget.method_25364() - 4));
    }
}

