/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.config.manage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import me.roundaround.custompaintings.roundalib.config.ConfigPath;
import me.roundaround.custompaintings.roundalib.config.ConnectedWorldContext;
import me.roundaround.custompaintings.roundalib.config.manage.ModConfig;
import me.roundaround.custompaintings.roundalib.config.option.ConfigOption;
import me.roundaround.custompaintings.roundalib.observable.Subscription;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;

public abstract class ModConfigImpl
implements ModConfig {
    protected final String modId;
    protected final String configId;
    protected final int configVersion;
    protected final LinkedHashMap<String, ArrayList<ConfigOption<?>>> byGroup = new LinkedHashMap();
    protected final LinkedHashMap<ConfigPath, ConfigOption<?>> byPath = new LinkedHashMap();
    protected final HashMap<ConfigPath, EnvType> envType = new HashMap();
    protected final HashSet<ConfigPath> noGuiControl = new HashSet();
    protected final HashSet<ConfigPath> singlePlayerOnly = new HashSet();
    protected final HashSet<ConfigPath> serverOrSinglePlayer = new HashSet();
    protected final List<Subscription> subscriptions = new ArrayList<Subscription>();
    protected int storeSuppliedVersion;
    protected boolean isInitialized = false;

    protected ModConfigImpl(String string) {
        this(string, 1);
    }

    protected ModConfigImpl(String string, String string2) {
        this(string, string2, 1);
    }

    protected ModConfigImpl(String string, int n) {
        this(string, string, n);
    }

    protected ModConfigImpl(String string, String string2, int n) {
        this.modId = string;
        this.configId = string2;
        this.configVersion = n;
    }

    public final void init() {
        if (this.isInitialized) {
            return;
        }
        this.initializeStore();
        this.isInitialized = true;
    }

    protected abstract void registerOptions();

    @Override
    public void syncWithStore() {
        this.clear();
        this.registerOptions();
        ModConfig.super.syncWithStore();
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public class_2561 getLabel() {
        return class_2561.method_43471((String)(this.getModId() + "." + this.getConfigId() + ".title"));
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public int getVersion() {
        return this.configVersion;
    }

    public String getConfigId() {
        return this.configId;
    }

    @Override
    public ConfigOption<?> getByPath(String string) {
        return this.getByPath(ConfigPath.parse(string));
    }

    @Override
    public ConfigOption<?> getByPath(ConfigPath configPath) {
        return this.byPath.get(configPath);
    }

    @Override
    public void clear() {
        this.byGroup.clear();
        this.byPath.clear();
    }

    protected boolean isActive(ConfigOption<?> configOption) {
        ConfigPath configPath = configOption.getPath();
        EnvType envType = this.envType.get(configPath);
        if (envType != null && envType != FabricLoader.getInstance().getEnvironmentType()) {
            return false;
        }
        if (this.singlePlayerOnly.contains(configPath) && !ConnectedWorldContext.isSinglePlayer()) {
            return false;
        }
        return !this.serverOrSinglePlayer.contains(configPath) || FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER || ConnectedWorldContext.isSinglePlayer();
    }

    protected boolean shouldShowGuiControl(ConfigOption<?> configOption) {
        if (!this.isActive(configOption)) {
            return false;
        }
        return !this.noGuiControl.contains(configOption.getPath());
    }

    public List<ConfigOption<?>> getAll() {
        return this.byPath.values().stream().filter(this::isActive).toList();
    }

    protected Map<String, List<ConfigOption<?>>> getByGroup(Predicate<ConfigOption<?>> predicate) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.byGroup.forEach((? super K string, ? super V arrayList) -> {
            List list = arrayList.stream().filter(predicate).toList();
            if (!list.isEmpty()) {
                linkedHashMap.put(string, list);
            }
        });
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Override
    public Map<String, List<ConfigOption<?>>> getByGroup() {
        return this.getByGroup(this::isActive);
    }

    @Override
    public Map<String, List<ConfigOption<?>>> getByGroupWithGuiControl() {
        return this.getByGroup(this::shouldShowGuiControl);
    }

    @Override
    public void setStoreSuppliedVersion(int n) {
        this.storeSuppliedVersion = n;
    }

    @Override
    public int getStoreSuppliedVersion() {
        return this.storeSuppliedVersion;
    }

    protected <T extends ConfigOption<?>> T register(T t) {
        t.setModId(this.modId);
        t.pendingValue.subscribe(this::refresh);
        this.byGroup.computeIfAbsent(t.getGroup(), string -> new ArrayList()).add(t);
        this.byPath.put(t.getPath(), t);
        return t;
    }

    protected <T extends ConfigOption<?>> RegistrationBuilder<T> buildRegistration(T t) {
        return new RegistrationBuilder<ConfigOption>(t, registrationBuilder -> {
            ConfigOption configOption2 = this.register(t);
            ConfigPath configPath = configOption2.getPath();
            if (registrationBuilder.envType != null) {
                this.envType.put(configPath, registrationBuilder.envType);
            }
            if (registrationBuilder.noGuiControl) {
                this.noGuiControl.add(configPath);
            }
            if (registrationBuilder.singlePlayerOnly) {
                this.singlePlayerOnly.add(configPath);
            }
            if (registrationBuilder.serverOrSinglePlayer) {
                this.serverOrSinglePlayer.add(configPath);
            }
            return configOption2;
        });
    }

    public static class RegistrationBuilder<T extends ConfigOption<?>> {
        protected final T option;
        protected final Function<? super RegistrationBuilder<T>, T> onCommit;
        protected EnvType envType = null;
        protected boolean noGuiControl = false;
        protected boolean singlePlayerOnly = false;
        protected boolean serverOrSinglePlayer = false;

        public RegistrationBuilder(T t, Function<? super RegistrationBuilder<T>, T> function) {
            this.option = t;
            this.onCommit = function;
        }

        public RegistrationBuilder<T> clientOnly() {
            this.envType = EnvType.CLIENT;
            return this;
        }

        public RegistrationBuilder<T> serverOnly() {
            this.envType = EnvType.SERVER;
            return this;
        }

        public RegistrationBuilder<T> noGuiControl() {
            this.noGuiControl = true;
            return this;
        }

        public RegistrationBuilder<T> singlePlayerOnly() {
            this.envType = EnvType.CLIENT;
            this.singlePlayerOnly = true;
            return this;
        }

        public RegistrationBuilder<T> serverOrSinglePlayer() {
            this.serverOrSinglePlayer = true;
            return this;
        }

        public T commit() {
            return (T)((ConfigOption)this.onCommit.apply(this));
        }
    }
}

