/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.roundalib.config.option;

import java.util.Optional;
import me.roundaround.custompaintings.roundalib.config.ConfigPath;
import me.roundaround.custompaintings.roundalib.config.option.ConfigOption;
import me.roundaround.custompaintings.roundalib.config.panic.IllegalArgumentPanic;
import me.roundaround.custompaintings.roundalib.config.panic.Panic;
import net.minecraft.class_3532;

public class IntConfigOption
extends ConfigOption<Integer> {
    private final Integer minValue;
    private final Integer maxValue;
    private final Integer step;
    private final boolean slider;

    protected IntConfigOption(Builder builder) {
        super(builder);
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.slider = builder.slider;
        this.step = builder.step;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public boolean useSlider() {
        return this.slider;
    }

    public int getStep() {
        if (this.step != null) {
            return this.step;
        }
        if (this.getMinValue() != null && this.getMaxValue() != null) {
            return Math.max(1, Math.round((float)(this.getMaxValue() - this.getMinValue()) / 10.0f));
        }
        return 1;
    }

    public boolean showStepButtons() {
        return this.step != null;
    }

    public boolean canIncrement() {
        if (this.step == null) {
            return false;
        }
        return (Integer)this.getPendingValue() < Optional.ofNullable(this.getMaxValue()).orElse(Integer.MAX_VALUE);
    }

    public boolean canDecrement() {
        if (this.step == null) {
            return false;
        }
        return (Integer)this.getPendingValue() > Optional.ofNullable(this.minValue).orElse(Integer.MIN_VALUE);
    }

    public boolean increment() {
        return this.step(1);
    }

    public boolean decrement() {
        return this.step(-1);
    }

    public boolean step(int n) {
        if (this.step == null) {
            return false;
        }
        int n2 = (Integer)this.getPendingValue();
        int n3 = Optional.ofNullable(this.getMinValue()).orElse(Integer.MIN_VALUE);
        int n4 = Optional.ofNullable(this.getMaxValue()).orElse(Integer.MAX_VALUE);
        int n5 = class_3532.method_15340((int)(n2 + this.step * n), (int)n3, (int)n4);
        if (n5 == n2) {
            return false;
        }
        this.setValue(n5);
        return true;
    }

    public static Builder builder(ConfigPath configPath) {
        return new Builder(configPath);
    }

    public static Builder sliderBuilder(ConfigPath configPath) {
        return new Builder(configPath).setUseSlider(true);
    }

    public static class Builder
    extends ConfigOption.AbstractBuilder<Integer, IntConfigOption, Builder> {
        private Integer minValue = null;
        private Integer maxValue = null;
        private Integer step = 1;
        private boolean slider = false;

        private Builder(ConfigPath configPath) {
            super(configPath);
        }

        @Override
        public Builder setDefaultValue(int n) {
            this.defaultValue = n;
            return this;
        }

        public Builder setMinValue(int n) {
            this.minValue = n;
            return this;
        }

        public Builder setMinValue(Integer n) {
            this.minValue = n;
            return this;
        }

        public Builder setMaxValue(int n) {
            this.maxValue = n;
            return this;
        }

        public Builder setMaxValue(Integer n) {
            this.maxValue = n;
            return this;
        }

        public Builder setStep(int n) {
            this.step = n;
            return this;
        }

        public Builder setStep(Integer n) {
            this.step = n;
            return this;
        }

        public Builder setUseSlider(boolean bl) {
            this.slider = bl;
            return this;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.maxValue != null) {
                this.validators.addFirst((n, configOption) -> n <= this.maxValue);
                if (this.minValue != null && this.minValue > this.maxValue) {
                    Panic.panic(new IllegalArgumentPanic("Min value cannot be larger than max value for IntConfigOption"));
                }
            }
            if (this.minValue != null) {
                this.validators.addFirst((n, configOption) -> n >= this.minValue);
            }
            if (this.slider && (this.minValue == null || this.maxValue == null)) {
                Panic.panic(new IllegalArgumentPanic("Min and max values must be defined to use slider control for IntConfigOption"));
            }
        }

        @Override
        protected IntConfigOption buildInternal() {
            return new IntConfigOption(this);
        }
    }
}

