/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.custompaintings.server;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.roundaround.custompaintings.entity.decoration.painting.MigrationData;
import me.roundaround.custompaintings.entity.decoration.painting.PaintingData;
import me.roundaround.custompaintings.network.PaintingAssignment;
import me.roundaround.custompaintings.server.network.ServerNetworking;
import me.roundaround.custompaintings.server.registry.ServerPaintingRegistry;
import me.roundaround.custompaintings.util.CustomId;
import net.minecraft.class_10741;
import net.minecraft.class_1297;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_18;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ServerPaintingManager
extends class_18 {
    public static final Codec<ServerPaintingManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(PaintingDataWithUuid.CODEC).xmap(ServerPaintingManager::listToMap, ServerPaintingManager::mapToList).fieldOf("Paintings").forGetter(serverPaintingManager -> serverPaintingManager.paintings)).apply((Applicative)instance, ServerPaintingManager::new));
    public static final class_10741<ServerPaintingManager> STATE_TYPE = new class_10741("custompaintings", ServerPaintingManager::new, CODEC, null);
    private final HashMap<UUID, PaintingData> paintings = new HashMap();
    private final HashMap<UUID, Integer> networkIds = new HashMap();

    private ServerPaintingManager() {
        this.method_80();
    }

    private ServerPaintingManager(Map<UUID, PaintingData> map) {
        this.paintings.putAll(map);
    }

    private static Map<UUID, PaintingData> listToMap(List<PaintingDataWithUuid> list) {
        HashMap<UUID, PaintingData> hashMap = new HashMap<UUID, PaintingData>(list.size());
        for (PaintingDataWithUuid paintingDataWithUuid : list) {
            hashMap.put(paintingDataWithUuid.paintingUuid(), paintingDataWithUuid);
        }
        return hashMap;
    }

    private static List<PaintingDataWithUuid> mapToList(Map<UUID, PaintingData> map) {
        return map.entrySet().stream().map(entry -> new PaintingDataWithUuid((UUID)entry.getKey(), (PaintingData)entry.getValue())).toList();
    }

    public void onEntityLoad(class_1534 class_15342) {
        this.loadPainting(class_15342);
        this.fixCustomName(class_15342);
    }

    public void onEntityUnload(class_1534 class_15342) {
        class_1297.class_5529 class_55292 = class_15342.method_35049();
        if (class_55292 == null || !class_55292.method_31486()) {
            return;
        }
        this.remove(class_15342.method_5667());
    }

    public void syncAllDataForPlayer(class_3222 class_32222) {
        Function<CustomId, Boolean> function = ServerPaintingRegistry.getInstance()::contains;
        List<PaintingAssignment> list = this.paintings.entrySet().stream().filter(entry -> this.networkIds.containsKey(entry.getKey())).map(entry -> {
            UUID uUID = (UUID)entry.getKey();
            PaintingData paintingData = (PaintingData)entry.getValue();
            return PaintingAssignment.from(this.networkIds.get(uUID), paintingData, function);
        }).toList();
        ServerNetworking.sendSyncAllDataPacket(class_32222, list);
    }

    public void setPaintingData(class_1534 class_15342, PaintingData paintingData) {
        this.setPaintingData(class_15342, paintingData, false);
    }

    public void setPaintingData(class_1534 class_15342, PaintingData paintingData, boolean bl) {
        block3: {
            block2: {
                class_15342.custompaintings$setData(paintingData);
                if (this.setTrackedData(class_15342.method_5667(), class_15342.method_5628(), paintingData)) break block2;
                if (!bl) break block3;
            }
            ServerNetworking.sendSetPaintingPacketToAll((class_3218)class_15342.method_73183(), PaintingAssignment.from(class_15342.method_5628(), paintingData, ServerPaintingRegistry.getInstance()::contains));
        }
    }

    private void loadPainting(class_1534 class_15342) {
        UUID uUID = class_15342.method_5667();
        PaintingData paintingData = this.paintings.get(uUID);
        if (paintingData == null) {
            paintingData = class_15342.custompaintings$getData();
        }
        if (paintingData.isEmpty()) {
            paintingData = new PaintingData((class_1535)class_15342.method_43404().comp_349());
        }
        this.setPaintingData(class_15342, paintingData, true);
    }

    private void fixCustomName(class_1534 class_15342) {
        PaintingData paintingData = class_15342.custompaintings$getData();
        class_2561 class_25612 = class_15342.method_5797();
        if (paintingData.isEmpty() || !class_15342.method_5807() || class_25612 == null) {
            return;
        }
        if (class_15342.method_5807() && class_25612.getString().isBlank()) {
            class_15342.method_5665(null);
            return;
        }
        if (!paintingData.hasLabel()) {
            return;
        }
        List<String> list = List.of(paintingData.name(), paintingData.artist(), paintingData.id().resource());
        String string = class_25612.getString();
        if (list.stream().anyMatch(string::startsWith)) {
            class_15342.method_5665(null);
            class_15342.method_5880(false);
        }
    }

    private void remove(UUID uUID) {
        this.networkIds.remove(uUID);
        if (this.paintings.remove(uUID) != null) {
            this.method_80();
        }
    }

    private boolean setTrackedData(UUID uUID, Integer n, PaintingData paintingData) {
        PaintingData paintingData2;
        if (n != null) {
            this.networkIds.put(uUID, n);
        }
        if ((paintingData2 = this.paintings.put(uUID, paintingData)) == null || !paintingData2.equals(paintingData)) {
            this.method_80();
            return true;
        }
        return false;
    }

    public static void syncAllDataForAllPlayers(MinecraftServer minecraftServer) {
        minecraftServer.method_3760().method_14571().forEach(class_32222 -> class_32222.method_51469().custompaintings$getPaintingManager().syncAllDataForPlayer((class_3222)class_32222));
    }

    public static void runMigration(class_3222 class_32222, CustomId customId) {
        boolean bl = ServerPaintingManager.tryRunMigration(class_32222, customId);
        ServerPaintingRegistry.getInstance().markMigrationFinished(customId, bl);
        if (class_32222 == null) {
            return;
        }
        MinecraftServer minecraftServer = class_32222.method_51469().method_8503();
        if (!minecraftServer.method_3806()) {
            return;
        }
        ServerNetworking.sendMigrationFinishPacketToAll(minecraftServer, customId, bl);
    }

    private static boolean tryRunMigration(class_3222 class_32222, CustomId customId) {
        if (class_32222 == null || !class_32222.method_64475(3) || customId == null) {
            return false;
        }
        MinecraftServer minecraftServer = class_32222.method_51469().method_8503();
        if (!minecraftServer.method_3806()) {
            return false;
        }
        ServerPaintingRegistry serverPaintingRegistry = ServerPaintingRegistry.getInstance();
        MigrationData migrationData = serverPaintingRegistry.getMigration(customId);
        if (migrationData == null) {
            return false;
        }
        var var5_5 = new Object(){
            boolean value = false;
        };
        minecraftServer.method_3738().forEach(class_32182 -> {
            ServerPaintingManager serverPaintingManager = class_32182.custompaintings$getPaintingManager();
            serverPaintingManager.paintings.forEach((uUID, paintingData) -> {
                CustomId customId3 = paintingData.id();
                ArrayDeque<CustomId> arrayDeque = new ArrayDeque<CustomId>(List.of(customId3));
                migrationData.pairs().forEach((customId, customId2) -> {
                    if (Objects.equals(arrayDeque.peek(), customId)) {
                        arrayDeque.push((CustomId)customId2);
                    }
                });
                Iterator<CustomId> iterator = arrayDeque.iterator();
                while (iterator.hasNext() && !serverPaintingRegistry.contains(iterator.next())) {
                    iterator.remove();
                }
                CustomId customId4 = arrayDeque.peek();
                if (customId3.equals(customId4)) {
                    return;
                }
                PaintingData paintingData2 = serverPaintingRegistry.get(customId4);
                Integer n = null;
                class_1297 class_12972 = class_32182.method_66347(uUID);
                if (class_12972 instanceof class_1534) {
                    class_1534 class_15342 = (class_1534)class_12972;
                    n = class_15342.method_5628();
                    class_15342.custompaintings$setData(paintingData2);
                }
                var3_3.value = var3_3.value || serverPaintingManager.setTrackedData((UUID)uUID, n, paintingData2);
            });
        });
        if (var5_5.value) {
            ServerPaintingManager.syncAllDataForAllPlayers(minecraftServer);
        }
        return true;
    }

    public Set<UUID> getUnknownPaintings() {
        return this.getUnknownPaintings(null);
    }

    public Set<UUID> getUnknownPaintings(CustomId customId) {
        ServerPaintingRegistry serverPaintingRegistry = ServerPaintingRegistry.getInstance();
        return this.paintings.entrySet().stream().filter(entry -> {
            CustomId customId2 = ((PaintingData)entry.getValue()).id();
            return !serverPaintingRegistry.contains(customId2) && (customId == null || customId.equals(customId2));
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Map<CustomId, Integer> getUnknownPaintingCounts() {
        HashMap<CustomId, Integer> hashMap = new HashMap<CustomId, Integer>();
        ServerPaintingRegistry serverPaintingRegistry = ServerPaintingRegistry.getInstance();
        this.paintings.forEach((uUID, paintingData) -> {
            CustomId customId = paintingData.id();
            if (serverPaintingRegistry.contains(customId)) {
                return;
            }
            hashMap.put(customId, hashMap.getOrDefault(customId, 0) + 1);
        });
        return hashMap;
    }

    public int fixUnknownPaintings(class_3218 class_32182, CustomId customId, CustomId customId2) {
        PaintingData paintingData = ServerPaintingRegistry.getInstance().get(customId2);
        if (paintingData == null || paintingData.isEmpty()) {
            return 0;
        }
        Set<UUID> set = this.getUnknownPaintings(customId);
        var var6_6 = new Object(this){
            int count = 0;
        };
        set.forEach(uUID -> {
            Integer n = null;
            class_1297 class_12972 = class_32182.method_66347(uUID);
            if (class_12972 instanceof class_1534) {
                class_1534 class_15342 = (class_1534)class_12972;
                n = class_15342.method_5628();
                class_15342.custompaintings$setData(paintingData);
            }
            if (this.setTrackedData((UUID)uUID, n, paintingData)) {
                ++var3_3.count;
            }
        });
        return var6_6.count;
    }

    public Set<MismatchedReference> getMismatchedPaintings() {
        return this.getMismatchedPaintings(PaintingData.MismatchedCategory.EVERYTHING);
    }

    public Set<MismatchedReference> getMismatchedPaintings(PaintingData.MismatchedCategory mismatchedCategory) {
        ServerPaintingRegistry serverPaintingRegistry = ServerPaintingRegistry.getInstance();
        return this.paintings.entrySet().stream().map(entry -> {
            PaintingData paintingData = (PaintingData)entry.getValue();
            PaintingData paintingData2 = serverPaintingRegistry.get(paintingData.id());
            if (paintingData2 == null || paintingData2.isEmpty() || !paintingData.isMismatched(paintingData2, mismatchedCategory)) {
                return null;
            }
            return new MismatchedReference((UUID)entry.getKey(), paintingData2);
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public int fixMismatchedPaintings(class_3218 class_32182, PaintingData.MismatchedCategory mismatchedCategory) {
        Set<MismatchedReference> set = this.getMismatchedPaintings(mismatchedCategory);
        var var4_4 = new Object(this){
            int count = 0;
        };
        set.forEach(mismatchedReference -> {
            UUID uUID = mismatchedReference.uuid();
            PaintingData paintingData = mismatchedReference.knownData();
            Integer n = null;
            class_1297 class_12972 = class_32182.method_66347(uUID);
            if (class_12972 instanceof class_1534) {
                class_1534 class_15342 = (class_1534)class_12972;
                n = class_15342.method_5628();
                class_15342.custompaintings$setData(paintingData);
            }
            if (this.setTrackedData(uUID, n, paintingData)) {
                ++var2_2.count;
            }
        });
        return var4_4.count;
    }

    public static Set<UUID> getUnknownPaintings(MinecraftServer minecraftServer, CustomId customId) {
        return Streams.stream((Iterable)minecraftServer.method_3738()).flatMap(class_32182 -> class_32182.custompaintings$getPaintingManager().getUnknownPaintings(customId).stream()).collect(Collectors.toSet());
    }

    public static Map<CustomId, Integer> getUnknownPaintingCounts(MinecraftServer minecraftServer) {
        return Streams.stream((Iterable)minecraftServer.method_3738()).flatMap(class_32182 -> class_32182.custompaintings$getPaintingManager().getUnknownPaintingCounts().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static int fixUnknownPaintings(MinecraftServer minecraftServer, CustomId customId, CustomId customId2) {
        return Streams.stream((Iterable)minecraftServer.method_3738()).mapToInt(class_32182 -> class_32182.custompaintings$getPaintingManager().fixUnknownPaintings((class_3218)class_32182, customId, customId2)).sum();
    }

    public static Set<MismatchedReference> getMismatchedPaintings(MinecraftServer minecraftServer) {
        return ServerPaintingManager.getMismatchedPaintings(minecraftServer, PaintingData.MismatchedCategory.EVERYTHING);
    }

    public static Set<MismatchedReference> getMismatchedPaintings(MinecraftServer minecraftServer, PaintingData.MismatchedCategory mismatchedCategory) {
        return Streams.stream((Iterable)minecraftServer.method_3738()).flatMap(class_32182 -> class_32182.custompaintings$getPaintingManager().getMismatchedPaintings(mismatchedCategory).stream()).collect(Collectors.toSet());
    }

    public static int fixMismatchedPaintings(MinecraftServer minecraftServer, PaintingData.MismatchedCategory mismatchedCategory) {
        return Streams.stream((Iterable)minecraftServer.method_3738()).mapToInt(class_32182 -> class_32182.custompaintings$getPaintingManager().fixMismatchedPaintings((class_3218)class_32182, mismatchedCategory)).sum();
    }

    private static class PaintingDataWithUuid
    extends PaintingData {
        public static final Codec<PaintingDataWithUuid> CODEC = RecordCodecBuilder.create(instance -> PaintingDataWithUuid.mapBaseCodecFields(instance).and((App)class_4844.field_25122.fieldOf("PaintingUuid").forGetter(PaintingDataWithUuid::paintingUuid)).apply((Applicative)instance, PaintingDataWithUuid::new));
        private final UUID paintingUuid;

        public PaintingDataWithUuid(CustomId customId, int n, int n2, @NotNull String string, @NotNull String string2, boolean bl, boolean bl2, UUID uUID) {
            super(customId, n, n2, string, string2, bl, bl2);
            this.paintingUuid = uUID;
        }

        public PaintingDataWithUuid(UUID uUID, PaintingData paintingData) {
            this(paintingData.id(), paintingData.width(), paintingData.height(), paintingData.name(), paintingData.artist(), paintingData.vanilla(), paintingData.unknown(), uUID);
        }

        public UUID paintingUuid() {
            return this.paintingUuid;
        }
    }

    public record MismatchedReference(UUID uuid, PaintingData knownData) {
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MismatchedReference)) {
                return false;
            }
            MismatchedReference mismatchedReference = (MismatchedReference)object;
            return Objects.equals(this.uuid, mismatchedReference.uuid);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.uuid);
        }
    }
}

